/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.as.wst.server.ui.xpl;

import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.Iterator;
import org.eclipse.jface.internal.text.html.HTML2TextReader;
import org.eclipse.jface.text.TextPresentation;
import org.eclipse.jface.window.ToolTip;
import org.eclipse.swt.custom.StyleRange;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseMoveListener;
import org.eclipse.swt.events.ShellAdapter;
import org.eclipse.swt.events.ShellEvent;
import org.eclipse.swt.events.ShellListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;

public abstract class ServerToolTip
extends ToolTip {
    protected Shell FOCUSSED_TOOLTIP;
    protected Object tooltipSelection;
    protected Label hintLabel;
    protected Tree tree;
    protected int x;
    protected int y;

    public ServerToolTip(Tree tree) {
        super((Control)tree);
        this.tree = tree;
        tree.addMouseMoveListener(new MouseMoveListener(){

            public void mouseMove(MouseEvent e) {
                ServerToolTip.this.x = e.x;
                ServerToolTip.this.y = e.y;
            }
        });
        tree.addKeyListener((KeyListener)new CustomKeyListener(true, true));
    }

    protected void handleEscape() {
        if (this.FOCUSSED_TOOLTIP != null) {
            this.FOCUSSED_TOOLTIP.dispose();
            this.FOCUSSED_TOOLTIP = null;
            this.tooltipSelection = null;
        }
        this.activate();
    }

    protected void handlef6() {
        if (this.FOCUSSED_TOOLTIP == null && this.tooltipSelection != null) {
            this.deactivate();
            this.hide();
            this.createFocusedTooltip((Control)this.tree);
        }
    }

    public void createFocusedTooltip(Control control) {
        final Shell stickyTooltip = new Shell(control.getShell(), 540676);
        stickyTooltip.setLayout((Layout)new FillLayout());
        stickyTooltip.setBackground(stickyTooltip.getDisplay().getSystemColor(29));
        stickyTooltip.addShellListener((ShellListener)new ShellAdapter(){

            public void shellClosed(ShellEvent e) {
                ServerToolTip.this.handleEscape();
            }
        });
        control.getDisplay().asyncExec(new Runnable(){

            @Override
            public void run() {
                Event event = new Event();
                event.x = ServerToolTip.this.x;
                event.y = ServerToolTip.this.y;
                event.widget = ServerToolTip.this.tree;
                ServerToolTip.this.createToolTipContentArea(event, (Composite)stickyTooltip);
                stickyTooltip.pack();
                stickyTooltip.setLocation(stickyTooltip.getDisplay().getCursorLocation());
                ServerToolTip.this.hintLabel.setText("Press 'ESC' to Hide.");
                stickyTooltip.setVisible(true);
            }
        });
        this.FOCUSSED_TOOLTIP = stickyTooltip;
    }

    protected Object getToolTipArea(Event event) {
        TreeItem o = this.tree.getItem(new Point(event.x, event.y));
        return o;
    }

    protected boolean shouldCreateToolTip(Event event) {
        if (this.tree.getItem(new Point(event.x, event.y)) == null) {
            return false;
        }
        TreeItem o = this.tree.getItem(new Point(event.x, event.y));
        boolean ret = o instanceof TreeItem && !this.isMyType(o.getData()) ? false : super.shouldCreateToolTip(event);
        if (!ret) {
            this.tooltipSelection = null;
        }
        return ret;
    }

    protected abstract boolean isMyType(Object var1);

    protected abstract void fillStyledText(Composite var1, StyledText var2, Object var3);

    protected Composite createToolTipContentArea(Event event, Composite parent) {
        TreeItem o = this.tree.getItem(new Point(event.x, event.y));
        if (o == null) {
            return null;
        }
        this.tooltipSelection = o;
        FillLayout layout = (FillLayout)parent.getLayout();
        layout.type = 512;
        parent.setLayout((Layout)layout);
        parent.setBackground(parent.getDisplay().getSystemColor(29));
        StyledText sText = new StyledText(parent, 0);
        sText.setEditable(false);
        sText.setBackground(parent.getBackground());
        sText.addKeyListener((KeyListener)new CustomKeyListener(true, false));
        this.fillStyledText(parent, sText, o);
        this.hintLabel = new Label(parent, 2048);
        this.hintLabel.setAlignment(131072);
        this.hintLabel.setBackground(parent.getDisplay().getSystemColor(29));
        this.hintLabel.setText("Press 'F6' for Focus.");
        this.hintLabel.setForeground(parent.getDisplay().getSystemColor(16));
        Display display = parent.getDisplay();
        FontData[] fd = parent.getFont().getFontData();
        int size2 = fd.length;
        int i = 0;
        while (i < size2) {
            fd[i].setHeight(7);
            ++i;
        }
        final Font font = new Font((Device)display, fd);
        parent.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                font.dispose();
            }
        });
        this.hintLabel.setFont(font);
        this.parseText(sText.getText(), sText);
        return parent;
    }

    protected void parseText(String htmlText, StyledText sText) {
        String text;
        TextPresentation presentation = new TextPresentation();
        HTML2TextReader reader = new HTML2TextReader((Reader)new StringReader(htmlText), presentation);
        try {
            text = reader.getString();
        }
        catch (IOException e) {
            text = "";
        }
        sText.setText(text);
        Iterator iter = presentation.getAllStyleRangeIterator();
        while (iter.hasNext()) {
            StyleRange sr = (StyleRange)iter.next();
            sText.setStyleRange(sr);
        }
    }

    private class CustomKeyListener
    implements KeyListener {
        private boolean handleEscape;
        private boolean handlef6;

        public CustomKeyListener(boolean handlesEscape, boolean handlesf6) {
            this.handleEscape = handlesEscape;
            this.handlef6 = handlesf6;
        }

        public void keyPressed(KeyEvent e) {
            if (e == null) {
                return;
            }
            if (this.handleEscape && e.keyCode == 27) {
                ServerToolTip.this.handleEscape();
            }
            if (this.handlef6 && e.keyCode == 0x100000F) {
                ServerToolTip.this.handlef6();
            }
        }

        public void keyReleased(KeyEvent e) {
        }
    }
}

