/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.jmx.jvmmonitor.internal.tools;

import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.jboss.tools.common.jdt.debug.tools.ToolsCore;
import org.jboss.tools.common.jdt.debug.tools.ToolsCoreException;
import org.jboss.tools.jmx.jvmmonitor.core.IHeapDumpHandler;
import org.jboss.tools.jmx.jvmmonitor.core.JvmCoreException;
import org.jboss.tools.jmx.jvmmonitor.internal.tools.Messages;

public class HeapDumpHandler
implements IHeapDumpHandler {
    private static final int BUFFER_SIZE = 2048;

    public String dumpHeap(int pid, boolean isLive) throws JvmCoreException {
        ToolsCore.AttachedVM virtualMachine = null;
        try {
            virtualMachine = ToolsCore.attach((int)pid);
            String string = HeapDumpHandler.getHeapHistogram(virtualMachine, isLive);
            return string;
        }
        catch (ToolsCoreException e) {
            throw new JvmCoreException(4, e.getMessage(), (Throwable)e);
        }
        finally {
            if (virtualMachine != null) {
                try {
                    ToolsCore.detach((ToolsCore.AttachedVM)virtualMachine);
                }
                catch (ToolsCoreException toolsCoreException) {}
            }
        }
    }

    public int getMaxClassesNumber() {
        IEclipsePreferences prefs = InstanceScope.INSTANCE.getNode("org.jboss.tools.jmx.jvmmonitor.tools");
        return prefs.getInt("org.jboss.tools.jmx.jvmmonitor.tools.class.maxNumber", 3000);
    }

    private static String getHeapHistogram(ToolsCore.AttachedVM virtualMachine, boolean isLive) throws JvmCoreException {
        InputStream in = null;
        try {
            in = ToolsCore.getHeapHistogram((ToolsCore.AttachedVM)virtualMachine, (boolean)isLive);
        }
        catch (ToolsCoreException tce) {
            throw new JvmCoreException(4, tce.getMessage(), (Throwable)tce);
        }
        byte[] bytes = new byte[2048];
        StringBuilder builder = new StringBuilder();
        try {
            try {
                int length;
                while ((length = in.read(bytes)) != -1) {
                    String string = new String(bytes, 0, length, "UTF8");
                    builder.append(string);
                }
            }
            catch (UnsupportedEncodingException e) {
                throw new JvmCoreException(4, Messages.charsetNotSupportedMsg, (Throwable)e);
            }
            catch (IOException e) {
                throw new JvmCoreException(4, Messages.readInputStreamFailedMsg, (Throwable)e);
            }
        }
        finally {
            try {
                in.close();
            }
            catch (IOException iOException) {}
        }
        return builder.toString();
    }
}

