/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.jmx.jolokia.internal.connection;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanConstructorInfo;
import javax.management.MBeanFeatureInfo;
import javax.management.MBeanInfo;
import javax.management.MBeanNotificationInfo;
import javax.management.MBeanOperationInfo;
import javax.management.MBeanParameterInfo;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;

public class JolokiaMBeanUtility {
    public MBeanAttributeInfo[] getAttributeInfos(JSONObject obj) {
        if (obj != null) {
            return (MBeanAttributeInfo[])obj.entrySet().stream().map(entry -> {
                JSONObject value = (JSONObject)entry.getValue();
                return new MBeanAttributeInfo((String)entry.getKey(), (String)value.get((Object)"type"), (String)value.get((Object)"desc"), (Boolean)value.get((Object)"rw"), (Boolean)value.get((Object)"rw"), false);
            }).sorted(Comparator.comparing(MBeanFeatureInfo::getName)).toArray(MBeanAttributeInfo[]::new);
        }
        return new MBeanAttributeInfo[0];
    }

    public MBeanOperationInfo[] getOperationInfos(JSONObject operations) {
        if (operations != null) {
            ArrayList<MBeanOperationInfo> collector = new ArrayList<MBeanOperationInfo>();
            Set entries = operations.keySet();
            for (String opName : entries) {
                collector.addAll(this.computeOperationInfos(operations, opName));
            }
            collector.sort(Comparator.comparing(MBeanFeatureInfo::getName));
            return collector.toArray(new MBeanOperationInfo[collector.size()]);
        }
        return new MBeanOperationInfo[0];
    }

    private Set<MBeanOperationInfo> computeOperationInfos(JSONObject obj, String opName) {
        Object operationInfos = obj.get((Object)opName);
        if (operationInfos instanceof JSONObject) {
            return Collections.singleton(this.createOperationInfos(opName, (JSONObject)operationInfos));
        }
        HashSet<MBeanOperationInfo> res = new HashSet<MBeanOperationInfo>();
        for (Object operationInfo : (JSONArray)operationInfos) {
            res.add(this.createOperationInfos(opName, (JSONObject)operationInfo));
        }
        return res;
    }

    private MBeanOperationInfo createOperationInfos(String opName, JSONObject operationInfo) {
        String ret = (String)operationInfo.get((Object)"ret");
        String desc = (String)operationInfo.get((Object)"desc");
        int impact = 3;
        MBeanParameterInfo[] paramsArr = this.computeParamInfos(operationInfo);
        return new MBeanOperationInfo(opName, desc, paramsArr, ret, impact);
    }

    private MBeanParameterInfo[] computeParamInfos(JSONObject v) {
        JSONArray args = (JSONArray)v.get((Object)"args");
        Iterator argsIt = args.iterator();
        ArrayList<MBeanParameterInfo> params = new ArrayList<MBeanParameterInfo>();
        while (argsIt.hasNext()) {
            JSONObject argsKey = (JSONObject)argsIt.next();
            String argName = (String)argsKey.get((Object)"name");
            String argType = (String)argsKey.get((Object)"type");
            String argDesc = (String)argsKey.get((Object)"desc");
            MBeanParameterInfo paramInfo = new MBeanParameterInfo(argName, argType, argDesc);
            params.add(paramInfo);
        }
        return params.toArray(new MBeanParameterInfo[params.size()]);
    }

    public MBeanConstructorInfo[] getContructorInfos(JSONObject obj) {
        return new MBeanConstructorInfo[0];
    }

    public MBeanNotificationInfo[] getNotificationInfos(JSONObject obj) {
        return new MBeanNotificationInfo[0];
    }

    public MBeanInfo createMBeanInfoFromSingletonList(JSONObject obj) {
        Object className = obj.get((Object)"class");
        String classNameForUser = className != null ? className.toString() : "Unknown";
        Object description = obj.get((Object)"description");
        String desc = description == null ? "null" : description.toString();
        MBeanAttributeInfo[] attributes = this.getAttributeInfos((JSONObject)obj.get((Object)"attr"));
        MBeanOperationInfo[] operations = this.getOperationInfos((JSONObject)obj.get((Object)"op"));
        MBeanConstructorInfo[] constructors = this.getContructorInfos(null);
        MBeanNotificationInfo[] notifications = this.getNotificationInfos(null);
        return new MBeanInfo(classNameForUser, desc, attributes, constructors, operations, notifications);
    }
}

