/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.jmx.jolokia.internal.ui;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.internal.ui.MultipleInputDialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.Text;
import org.jboss.tools.foundation.ui.util.FormDataUtility;
import org.jboss.tools.foundation.ui.xpl.taskwizard.IWizardHandle;
import org.jboss.tools.foundation.ui.xpl.taskwizard.WizardFragment;
import org.jboss.tools.jmx.core.ExtensionManager;
import org.jboss.tools.jmx.core.IConnectionProvider;
import org.jboss.tools.jmx.core.IConnectionWrapper;
import org.jboss.tools.jmx.jolokia.JolokiaConnectionWrapper;
import org.jboss.tools.jmx.jolokia.internal.JolokiaConnectionProvider;
import org.jboss.tools.jmx.jolokia.internal.ui.JolokiaSharedImages;
import org.jboss.tools.jmx.ui.IEditableConnectionWizardPage;

public class JolokiaConnectionWizardPage
extends WizardFragment
implements IEditableConnectionWizardPage {
    private static final String KEY_LABEL = "Header key: ";
    private static final String VAL_LABEL = "Header value: ";
    private JolokiaConnectionWrapper initial;
    private Text nameText;
    private Text urlText;
    private String name;
    private String url;
    private String getOrPost;
    private boolean ignoreSSL;
    private TableViewer viewer;
    private Table table;
    private Button addHeaderBtn;
    private Button removeHeaderBtn;
    private Button editHeaderBtn;
    private Button ignoreSSLErrorBtn;
    private Button getBtn;
    private Button postBtn;
    private HashMap<String, String> headers;
    private IWizardHandle handle;

    public JolokiaConnectionWizardPage() {
        this.headers = this.initial == null ? new HashMap() : new HashMap<String, String>(this.initial.getHeaders());
    }

    public boolean hasComposite() {
        return true;
    }

    public Composite createComposite(Composite parent, IWizardHandle handle) {
        this.handle = handle;
        this.getPage().setTitle("Jolokia JMX Connection");
        return this.createControl(parent);
    }

    private void preCreateControl() {
        if (this.initial == null) {
            this.getPage().setTitle("New Jolokia JMX Connection");
        } else {
            this.getPage().setTitle("Edit Jolokia JMX Connection");
        }
        this.getPage().setImageDescriptor(JolokiaSharedImages.getDefault().descriptor("image/jolokia_ban.png"));
        this.setComplete(false);
    }

    public Composite createControl(Composite parent) {
        this.preCreateControl();
        Composite c = this.fillControl(parent);
        if (this.initial != null) {
            this.name = this.initial.getId();
            this.nameText.setText(this.name);
            this.url = this.initial.getUrl();
            this.urlText.setText(this.url);
            this.ignoreSSL = this.initial.isIgnoreSSLErrors();
            this.ignoreSSLErrorBtn.setSelection(this.ignoreSSL);
            this.getOrPost = this.initial.getType();
            Map<String, String> fromInitial = this.initial.getHeaders();
            this.headers.putAll(fromInitial);
            this.viewer.refresh();
        } else {
            this.getOrPost = "POST";
        }
        boolean post = "POST".equals(this.getOrPost);
        this.postBtn.setSelection(post);
        this.getBtn.setSelection(!post);
        this.addListeners();
        return c;
    }

    private void addListeners() {
        this.addHeaderBtn.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                JolokiaConnectionWizardPage.this.addHeaderPressed();
            }
        });
        this.editHeaderBtn.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                JolokiaConnectionWizardPage.this.editHeaderPressed();
            }
        });
        this.removeHeaderBtn.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                JolokiaConnectionWizardPage.this.removeHeaderPressed();
            }
        });
        this.nameText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                JolokiaConnectionWizardPage.this.name = JolokiaConnectionWizardPage.this.nameText.getText();
                JolokiaConnectionWizardPage.this.validate();
            }
        });
        this.urlText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                JolokiaConnectionWizardPage.this.url = JolokiaConnectionWizardPage.this.urlText.getText();
                JolokiaConnectionWizardPage.this.validate();
            }
        });
        this.ignoreSSLErrorBtn.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                JolokiaConnectionWizardPage.this.ignoreSSL = JolokiaConnectionWizardPage.this.ignoreSSLErrorBtn.getSelection();
                JolokiaConnectionWizardPage.this.validate();
            }
        });
        SelectionAdapter getOrPostListener = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (JolokiaConnectionWizardPage.this.getBtn.getSelection()) {
                    JolokiaConnectionWizardPage.this.getOrPost = "GET";
                } else if (JolokiaConnectionWizardPage.this.postBtn.getSelection()) {
                    JolokiaConnectionWizardPage.this.getOrPost = "POST";
                } else {
                    JolokiaConnectionWizardPage.this.getOrPost = null;
                }
                JolokiaConnectionWizardPage.this.validate();
            }
        };
        this.getBtn.addSelectionListener((SelectionListener)getOrPostListener);
        this.postBtn.addSelectionListener((SelectionListener)getOrPostListener);
    }

    private void addHeaderPressed() {
        this.openHeaderDialog(false, "", "");
    }

    private void editHeaderPressed() {
        IStructuredSelection sel = (IStructuredSelection)this.viewer.getSelection();
        if (sel != null && sel.getFirstElement() != null) {
            String kInitial = (String)sel.getFirstElement();
            String vInitial = this.headers.get(kInitial);
            this.openHeaderDialog(true, kInitial, vInitial);
        }
    }

    private void openHeaderDialog(boolean editing, String keyInitial, String valInitial) {
        String title = editing ? "Edit Header" : "Add Header";
        CustomMultipleInputDialog dialog = new CustomMultipleInputDialog(this.addHeaderBtn.getShell(), title);
        dialog.addTextField(KEY_LABEL, keyInitial, false);
        dialog.addTextField(VAL_LABEL, valInitial, false);
        if (dialog.open() == 0) {
            String k = dialog.getStringValue(KEY_LABEL).trim();
            String v = dialog.getStringValue(VAL_LABEL).trim();
            if (!k.isEmpty() && !v.isEmpty()) {
                this.headers.remove(keyInitial);
                this.headers.put(k, v);
                this.viewer.refresh();
                this.validate();
            }
        }
    }

    private void removeHeaderPressed() {
        IStructuredSelection sel = (IStructuredSelection)this.viewer.getSelection();
        if (sel != null) {
            String k = (String)sel.getFirstElement();
            this.headers.remove(k);
            this.viewer.refresh();
            this.validate();
        }
    }

    public Composite fillControl(Composite parent) {
        Composite c = new Composite(parent, 0);
        c.setLayout((Layout)new FillLayout());
        Composite main = new Composite(c, 0);
        main.setLayout((Layout)new FormLayout());
        Composite primary = new Composite(main, 2048);
        primary.setLayout((Layout)new GridLayout(4, false));
        Label name = new Label(primary, 0);
        this.nameText = new Text(primary, 2052);
        name.setText("Connection Name: ");
        Label url = new Label(primary, 0);
        this.urlText = new Text(primary, 2052);
        url.setText("Jolokia URL: ");
        this.viewer = new TableViewer(main, 68356);
        TableViewerColumn colHeaderKey = new TableViewerColumn(this.viewer, 0);
        colHeaderKey.getColumn().setWidth(200);
        colHeaderKey.getColumn().setText("Header Key");
        colHeaderKey.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                return element.toString();
            }
        });
        TableViewerColumn colHeaderVal = new TableViewerColumn(this.viewer, 0);
        colHeaderVal.getColumn().setWidth(200);
        colHeaderVal.getColumn().setText("Header Value");
        colHeaderVal.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                return JolokiaConnectionWizardPage.this.headers == null ? null : (String)JolokiaConnectionWizardPage.this.headers.get(element);
            }
        });
        this.table = this.viewer.getTable();
        this.table.setHeaderVisible(true);
        this.table.setLinesVisible(true);
        this.viewer.setContentProvider((IContentProvider)new ArrayContentProvider(){

            public Object[] getElements(Object inputElement) {
                Set s = JolokiaConnectionWizardPage.this.headers.keySet();
                ArrayList k = new ArrayList(s);
                Collections.sort(k);
                return k.toArray(new String[k.size()]);
            }
        });
        this.viewer.setInput(this.headers);
        this.addHeaderBtn = new Button(main, 8);
        this.editHeaderBtn = new Button(main, 8);
        this.removeHeaderBtn = new Button(main, 8);
        this.addHeaderBtn.setText("Add Header...");
        this.removeHeaderBtn.setText("Remove Header");
        this.editHeaderBtn.setText("Edit Header");
        Label requestTypeLabel = new Label(main, 0);
        requestTypeLabel.setText("Request Type: ");
        this.getBtn = new Button(main, 16);
        this.getBtn.setText("GET");
        this.postBtn = new Button(main, 16);
        this.postBtn.setText("POST");
        this.ignoreSSLErrorBtn = new Button(main, 32);
        this.ignoreSSLErrorBtn.setText("Do NOT verify SSL Certificates (Dangerous, for local use only!!)");
        this.nameText.setLayoutData((Object)GridDataFactory.defaultsFor((Control)this.nameText).span(3, 1).create());
        this.urlText.setLayoutData((Object)GridDataFactory.defaultsFor((Control)this.urlText).span(3, 1).create());
        FormDataUtility fdu = new FormDataUtility();
        primary.setLayoutData((Object)fdu.createFormData((Object)0, 5, null, 0, (Object)0, 5, (Object)100, -5));
        FormData fd2 = fdu.createFormData((Object)primary, 10, (Object)requestTypeLabel, -5, (Object)0, 5, (Object)80, -5);
        fd2.height = 100;
        this.table.setLayoutData((Object)fd2);
        this.addHeaderBtn.setLayoutData((Object)fdu.createFormData((Object)primary, 10, null, 0, (Object)this.table, 5, (Object)100, -5));
        this.editHeaderBtn.setLayoutData((Object)fdu.createFormData((Object)this.addHeaderBtn, 5, null, 0, (Object)this.table, 5, (Object)100, -5));
        this.removeHeaderBtn.setLayoutData((Object)fdu.createFormData((Object)this.editHeaderBtn, 5, null, 0, (Object)this.table, 5, (Object)100, -5));
        requestTypeLabel.setLayoutData((Object)fdu.createFormData(null, 0, (Object)this.ignoreSSLErrorBtn, -5, (Object)0, 5, null, 0));
        this.getBtn.setLayoutData((Object)fdu.createFormData(null, 0, (Object)this.ignoreSSLErrorBtn, -5, (Object)requestTypeLabel, 5, null, 0));
        this.postBtn.setLayoutData((Object)fdu.createFormData(null, 0, (Object)this.ignoreSSLErrorBtn, -5, (Object)this.getBtn, 5, null, 0));
        this.ignoreSSLErrorBtn.setLayoutData((Object)fdu.createFormData(null, 5, (Object)100, -5, (Object)0, 5, (Object)100, -5));
        return c;
    }

    private void validate() {
        JolokiaConnectionProvider provider = (JolokiaConnectionProvider)ExtensionManager.getProvider((String)"org.jboss.tools.jmx.jolokia.JolokiaConnectionProvider");
        IConnectionWrapper inUse = provider.findConnection(this.nameText.getText());
        if (inUse != null && inUse != this.initial) {
            this.handle.setMessage("Connection name already in use.", 3);
            this.setComplete(false);
            return;
        }
        if (this.isEmpty(this.name) || this.isEmpty(this.url) || this.isEmpty(this.getOrPost)) {
            this.handle.setMessage(null, 0);
            this.setComplete(false);
            return;
        }
        this.handle.setMessage(null, 0);
        this.setComplete(true);
        this.handle.update();
    }

    private boolean isEmpty(String s) {
        return s == null || s.isEmpty();
    }

    public IConnectionWrapper getConnection() throws CoreException {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("id", this.name);
        map.put("url", this.url);
        map.put("headers", this.headers);
        map.put("ignoreSSLErrors", this.ignoreSSL);
        map.put("getOrPost", this.getOrPost);
        IConnectionProvider provider = ExtensionManager.getProvider((String)"org.jboss.tools.jmx.jolokia.JolokiaConnectionProvider");
        return provider.createConnection(map);
    }

    public void setInitialConnection(IConnectionWrapper wrapper) {
        this.initial = (JolokiaConnectionWrapper)wrapper;
    }

    private class CustomMultipleInputDialog
    extends MultipleInputDialog {
        public CustomMultipleInputDialog(Shell shell, String title) {
            super(shell, title);
        }

        protected Point getInitialSize() {
            return new Point(400, 200);
        }
    }
}

