/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ide.eclipse.as.rse.core;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.model.IDebugTarget;
import org.eclipse.debug.core.model.IProcess;
import org.eclipse.osgi.util.NLS;
import org.eclipse.wst.server.core.IServer;
import org.eclipse.wst.server.core.IServerAttributes;
import org.eclipse.wst.server.core.IServerListener;
import org.eclipse.wst.server.core.ServerEvent;
import org.eclipse.wst.server.core.ServerUtil;
import org.jboss.ide.eclipse.as.core.util.JBossServerBehaviorUtils;
import org.jboss.ide.eclipse.as.core.util.PollThreadUtils;
import org.jboss.ide.eclipse.as.core.util.ServerHomeValidationUtility;
import org.jboss.ide.eclipse.as.rse.core.Messages;
import org.jboss.ide.eclipse.as.rse.core.RSECorePlugin;
import org.jboss.ide.eclipse.as.rse.core.RSELaunchConfigProperties;
import org.jboss.ide.eclipse.as.rse.core.RSEServerDummyProcess;
import org.jboss.ide.eclipse.as.rse.core.StandardRSEStartLaunchDelegate;
import org.jboss.ide.eclipse.as.rse.core.subsystems.RSEDeploymentOptionsController;
import org.jboss.ide.eclipse.as.wtp.core.debug.AttachDebuggerServerListener;
import org.jboss.ide.eclipse.as.wtp.core.server.behavior.ControllableServerBehavior;
import org.jboss.ide.eclipse.as.wtp.core.server.behavior.IControllableServerBehavior;
import org.jboss.ide.eclipse.as.wtp.core.server.behavior.ServerProfileModel;
import org.jboss.tools.as.core.server.controllable.systems.IDeploymentOptionsController;

public class StandardRSEJBossStartLaunchDelegate
extends StandardRSEStartLaunchDelegate {
    protected static final String DELIMETER = ":";
    protected static final String ECHO_KEY_DISCOVER_PID = "JBTOOLS_SERVER_START_CMD";

    @Override
    protected void beforeVMRunner(ILaunchConfiguration configuration, String mode, ILaunch launch, IProgressMonitor monitor) throws CoreException {
        IControllableServerBehavior beh = JBossServerBehaviorUtils.getControllableBehavior((ILaunchConfiguration)configuration);
        new ServerHomeValidationUtility().validateServerHome(beh.getServer(), true);
        super.beforeVMRunner(configuration, mode, launch, monitor);
    }

    @Override
    protected void actualLaunch(ILaunchConfiguration configuration, String mode, ILaunch launch, IProgressMonitor monitor) throws CoreException {
        RSELaunchConfigProperties propertyUtil = new RSELaunchConfigProperties();
        boolean detectStartupCommand = propertyUtil.isDetectStartupCommand(configuration, true);
        IServer server = ServerUtil.getServer((ILaunchConfiguration)configuration);
        boolean attachDebugger = server.getAttribute("org.jboss.ide.eclipse.as.core.server.launch.DebugLaunchConstants.ATTACH_DEBUGGER", true);
        this.logPotentialConfigErrors(server);
        if ("debug".equals(mode) && detectStartupCommand && attachDebugger) {
            this.launchDebug(configuration, mode, launch, monitor);
        } else {
            this.launchRun(configuration, mode, launch, monitor);
        }
    }

    protected void launchRun(ILaunchConfiguration configuration, String mode, ILaunch launch, IProgressMonitor monitor) throws CoreException {
        IControllableServerBehavior beh = JBossServerBehaviorUtils.getControllableBehavior((ILaunchConfiguration)configuration);
        IServer server = ServerUtil.getServer((ILaunchConfiguration)configuration);
        String command = new RSELaunchConfigProperties().getStartupCommand(configuration);
        if (command.trim().length() == 0) {
            if (beh != null) {
                ((ControllableServerBehavior)beh).setServerStopped();
            }
            throw new CoreException((IStatus)new Status(4, "org.jboss.ide.eclipse.as.rse.core", "Unable to start server: command to run is empty", null));
        }
        RSEServerDummyProcess dp = this.addDummyProcess(server, launch, command, "Launching " + server.getName());
        this.executeRemoteCommand(command, server, dp);
    }

    protected void launchDebug(ILaunchConfiguration configuration, String mode, ILaunch launch, IProgressMonitor monitor) throws CoreException {
        IControllableServerBehavior beh = JBossServerBehaviorUtils.getControllableBehavior((ILaunchConfiguration)configuration);
        IServer server = ServerUtil.getServer((ILaunchConfiguration)configuration);
        String command = new RSELaunchConfigProperties().getDebugStartupCommand(configuration);
        if (command.trim().length() == 0) {
            if (beh != null) {
                ((ControllableServerBehavior)beh).setServerStopped();
            }
            throw new CoreException((IStatus)new Status(4, "org.jboss.ide.eclipse.as.rse.core", "Unable to start server: command to run is empty", null));
        }
        RSEServerDummyProcess dp = this.addDummyProcess(server, launch, command, "Debugging " + server.getName());
        this.executeRemoteCommand(command, server, dp);
    }

    @Override
    protected void externallyManagedPollForStarted(IServer server, IControllableServerBehavior beh, String mode, ILaunch launch) {
        ((ControllableServerBehavior)beh).setServerStarting();
        this.attachDebugListenerAndLaunchPoller(server, mode, null);
    }

    @Override
    protected void afterVMRunner(ILaunchConfiguration configuration, String mode, ILaunch launch, IProgressMonitor monitor) throws CoreException {
        IServer s = ServerUtil.getServer((ILaunchConfiguration)configuration);
        this.attachDebugListenerAndLaunchPoller(s, mode, launch);
    }

    private void attachDebugListenerAndLaunchPoller(IServer s, String mode, ILaunch launch) {
        boolean attachDebugger = s.getAttribute("org.jboss.ide.eclipse.as.core.server.launch.DebugLaunchConstants.ATTACH_DEBUGGER", true);
        if ("debug".equals(mode) && attachDebugger) {
            AttachDebuggerServerListener listener = this.createAttachDebuggerListener(launch);
            s.addServerListener((IServerListener)listener);
        }
        this.pollServer(s, true);
    }

    private AttachDebuggerServerListener createAttachDebuggerListener(final ILaunch rseLaunch) {
        boolean register = rseLaunch == null;
        return new AttachDebuggerServerListener(register){

            protected void serverStarted(ServerEvent event) {
                super.serverStarted(event);
                ILaunch debuggerLaunch = this.getLaunch();
                if (debuggerLaunch != null && !this.shouldRegisterDebuggerLaunch()) {
                    IProcess[] processes = debuggerLaunch.getProcesses();
                    int i = 0;
                    while (i < processes.length) {
                        rseLaunch.addProcess(processes[i]);
                        ++i;
                    }
                    IDebugTarget[] delegateTargets = debuggerLaunch.getDebugTargets();
                    int i2 = 0;
                    while (i2 < delegateTargets.length) {
                        rseLaunch.addDebugTarget(delegateTargets[i2]);
                        ++i2;
                    }
                }
            }
        };
    }

    @Override
    protected boolean isStarted(IServer server) {
        return PollThreadUtils.isServerStarted((IServer)server).isOK();
    }

    @Override
    protected void pollServer(IServer server, boolean expectedState) {
        PollThreadUtils.pollServer((IServer)server, (boolean)expectedState);
    }

    @Override
    protected void setServerAlreadyStarted(ILaunchConfiguration configuration, String mode, IControllableServerBehavior beh, IServer server, ILaunch launch, String command) throws CoreException {
        this.addDummyProcess(server, launch, command, "Launching " + server.getName());
        boolean attachDebugger = server.getAttribute("org.jboss.ide.eclipse.as.core.server.launch.DebugLaunchConstants.ATTACH_DEBUGGER", true);
        if ("debug".equals(mode) && attachDebugger) {
            AttachDebuggerServerListener listener = this.createAttachDebuggerListener(launch);
            server.addServerListener((IServerListener)listener);
        }
        ((ControllableServerBehavior)beh).setServerStarted();
    }

    protected void logPotentialConfigErrors(IServer server) {
        IControllableServerBehavior beh = JBossServerBehaviorUtils.getControllableBehavior((IServerAttributes)server);
        try {
            IDeploymentOptionsController c = (IDeploymentOptionsController)beh.getController("deploymentOptions");
            if (c instanceof RSEDeploymentOptionsController) {
                String depType = ((RSEDeploymentOptionsController)c).getCurrentDeploymentLocationType();
                String profile = ServerProfileModel.getProfile((IServerAttributes)server);
                if ("rse".equals(profile) && depType != null && !"server".equals(depType)) {
                    boolean depFlag = server.getAttribute("org.jboss.ide.eclipse.as.core.server.addDeploymentScanner", true);
                    boolean exposePort = server.getAttribute("org.jboss.ide.eclipse.as.core.server.EXPOSE_MANAGEMENT_SERVICE", false);
                    if (!depFlag || !exposePort) {
                        RSECorePlugin.pluginLog().logWarning(NLS.bind((String)Messages.configErrorNonStandardDeploy, (Object)server.getName()));
                    }
                }
            }
        }
        catch (CoreException coreException) {
            // empty catch block
        }
    }
}

