/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.as.test.core.catalog;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import junit.framework.TestCase;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ProjectScope;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.preferences.DefaultScope;
import org.eclipse.core.runtime.preferences.IPreferencesService;
import org.eclipse.core.runtime.preferences.IScopeContext;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.wst.validation.ValidationResult;
import org.eclipse.wst.xml.core.internal.XMLCorePlugin;
import org.eclipse.wst.xml.core.internal.catalog.provisional.ICatalog;
import org.eclipse.wst.xml.core.internal.catalog.provisional.ICatalogEntry;
import org.eclipse.wst.xml.core.internal.catalog.provisional.INextCatalog;
import org.eclipse.wst.xml.core.internal.contentmodel.CMDocument;
import org.eclipse.wst.xml.core.internal.contentmodel.CMNamedNodeMap;
import org.eclipse.wst.xml.core.internal.contentmodel.CMNode;
import org.eclipse.wst.xml.core.internal.contentmodel.ContentModelManager;
import org.eclipse.wst.xml.core.internal.validation.XMLValidationConfiguration;
import org.eclipse.wst.xml.core.internal.validation.XMLValidationReport;
import org.eclipse.wst.xml.core.internal.validation.core.NestedValidatorContext;
import org.eclipse.wst.xml.core.internal.validation.core.ValidationMessage;
import org.eclipse.wst.xml.core.internal.validation.core.ValidationReport;
import org.eclipse.wst.xml.core.internal.validation.eclipse.XMLValidator;
import org.eclipse.wst.xml.ui.internal.wizards.NewXMLGenerator;
import org.eclipse.wst.xml.ui.internal.wizards.XMLSchemaValidationChecker;
import org.jboss.tools.as.test.core.internal.utils.MatrixUtils;
import org.jboss.tools.test.util.JobUtils;
import org.junit.AfterClass;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class CatalogValidationTest
extends TestCase {
    private static IProject project;
    private static HashMap<String, Integer> expectedErrors;
    private static ArrayList<String> noRootElement;
    private ICatalogEntry entry;

    static {
        expectedErrors = new HashMap();
        expectedErrors.put("module-1_0.xsd", 2);
        expectedErrors.put("module-1_1.xsd", 4);
        expectedErrors.put("module-1_2.xsd", 4);
        expectedErrors.put("module-1_3.xsd", 4);
        expectedErrors.put("module-1_5.xsd", 4);
        noRootElement = new ArrayList();
        noRootElement.add("jboss-common_5_1.xsd");
        noRootElement.add("jboss-common_6_0.xsd");
        noRootElement.add("xml.xsd");
    }

    @Parameterized.Parameters
    public static Collection<Object[]> data() {
        ICatalog xmlCatalog = XMLCorePlugin.getDefault().getDefaultXMLCatalog();
        ArrayList<ICatalogEntry> list = new ArrayList<ICatalogEntry>();
        CatalogValidationTest.fillCatalogEntryList(xmlCatalog, list);
        return MatrixUtils.toMatrix(new Object[][]{list.toArray(new ICatalogEntry[list.size()])});
    }

    private static void fillCatalogEntryList(ICatalog c, ArrayList<ICatalogEntry> list) {
        ICatalogEntry[] all = c.getCatalogEntries();
        int i = 0;
        while (i < all.length) {
            String uri = all[i].getURI();
            if (uri.contains("org.jboss.tools.as.catalog")) {
                list.add(all[i]);
            }
            ++i;
        }
        INextCatalog[] nextCatalogs = c.getNextCatalogs();
        int i2 = 0;
        while (i2 < nextCatalogs.length) {
            CatalogValidationTest.fillCatalogEntryList(nextCatalogs[i2].getReferencedCatalog(), list);
            ++i2;
        }
    }

    public CatalogValidationTest(ICatalogEntry entry) {
        this.entry = entry;
    }

    @BeforeClass
    public static void createProject() {
        IProject t1 = ResourcesPlugin.getWorkspace().getRoot().getProject("catalogtest");
        try {
            t1.create((IProgressMonitor)new NullProgressMonitor());
            JobUtils.waitForIdle();
            t1.open((IProgressMonitor)new NullProgressMonitor());
            JobUtils.waitForIdle();
            project = t1;
        }
        catch (CoreException ce) {
            CatalogValidationTest.fail((String)ce.getMessage());
        }
    }

    @AfterClass
    public static void deleteProject() {
        try {
            project.delete(true, true, (IProgressMonitor)new NullProgressMonitor());
        }
        catch (CoreException ce) {
            ce.printStackTrace();
        }
    }

    @Test
    public void testValidateXLFiles() {
        this.testOneSchema(project, this.entry);
    }

    private void testOneSchema(IProject project, ICatalogEntry n) {
        block16: {
            String lastSegment = new Path(n.getURI()).lastSegment();
            if (noRootElement.contains(lastSegment)) {
                return;
            }
            IFile file = null;
            try {
                try {
                    Integer expected;
                    NewXMLGenerator gen = this.createGeneratorForCatalogEntry(n);
                    String fname = lastSegment.replace(".xsd", ".xml");
                    file = project.getFile(fname);
                    file.create((InputStream)new ByteArrayInputStream("".getBytes()), true, (IProgressMonitor)new NullProgressMonitor());
                    gen.createXMLDocument(file, file.getLocation().toOSString());
                    System.out.println(file.getLocation().toOSString());
                    project.refreshLocal(2, (IProgressMonitor)new NullProgressMonitor());
                    ValidationReport report = this.validate(file.getLocation().toFile().toURI().toString(), file.getContents(), project, null);
                    int tangibleErrorCount = 0;
                    boolean generatedFileIsValid = report.isValid();
                    StringBuilder errorMessage = new StringBuilder();
                    errorMessage.append("XML file generated from schema " + n.getURI() + " is invalid.\n");
                    if (!generatedFileIsValid) {
                        ValidationMessage[] msg = report.getValidationMessages();
                        int k = 0;
                        while (k < msg.length) {
                            if (msg[k].getColumnNumber() != 0) {
                                errorMessage.append(msg[k].getMessage());
                                errorMessage.append("\n");
                                ++tangibleErrorCount;
                            }
                            ++k;
                        }
                    }
                    int eCount = (expected = expectedErrors.get(new Path(n.getURI()).lastSegment())) == null ? 0 : expected;
                    CatalogValidationTest.assertFalse((String)("Failure validating catalog entry " + new Path(n.getURI()).lastSegment() + ",  " + errorMessage.toString()), (tangibleErrorCount > eCount ? 1 : 0) != 0);
                }
                catch (Exception e) {
                    e.printStackTrace();
                    System.out.println("Failure validating catalog entry " + new Path(n.getURI()).lastSegment() + ",  " + e.getMessage());
                    CatalogValidationTest.fail((String)e.getMessage());
                    if (file == null) break block16;
                    try {
                        file.delete(true, (IProgressMonitor)new NullProgressMonitor());
                    }
                    catch (Exception e2) {
                        e2.printStackTrace();
                    }
                }
            }
            finally {
                if (file != null) {
                    try {
                        file.delete(true, (IProgressMonitor)new NullProgressMonitor());
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            }
        }
    }

    public ValidationReport validate(String uri, InputStream inputstream, IProject context, ValidationResult result) {
        try {
            XMLValidationReport valreport;
            XMLValidator validator = XMLValidator.getInstance();
            IScopeContext[] fPreferenceScopes = this.createPreferenceScopes(context);
            XMLValidationConfiguration configuration = new XMLValidationConfiguration();
            try {
                configuration.setFeature("INDICATE_NO_GRAMMAR", 1);
                IPreferencesService preferencesService = Platform.getPreferencesService();
                configuration.setFeature("INDICATE_NO_DOCUMENT_ELEMENT", preferencesService.getInt(XMLCorePlugin.getDefault().getBundle().getSymbolicName(), "indiciateNoDocumentElement", -1, fPreferenceScopes));
                configuration.setFeature("USE_XINCLUDE", preferencesService.getBoolean(XMLCorePlugin.getDefault().getBundle().getSymbolicName(), "xinclude", false, fPreferenceScopes));
                configuration.setFeature("HONOUR_ALL_SCHEMA_LOCATIONS", preferencesService.getBoolean(XMLCorePlugin.getDefault().getBundle().getSymbolicName(), "honourAllSchemaLocations", true, fPreferenceScopes));
            }
            catch (Exception preferencesService) {
                // empty catch block
            }
            XMLValidationReport xMLValidationReport = valreport = validator.validate(uri, inputstream, configuration, result, new NestedValidatorContext());
            return xMLValidationReport;
        }
        finally {
            if (inputstream != null) {
                try {
                    inputstream.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    protected IScopeContext[] createPreferenceScopes(IProject project) {
        ProjectScope projectScope;
        if (project != null && project.isAccessible() && (projectScope = new ProjectScope(project)).getNode(XMLCorePlugin.getDefault().getBundle().getSymbolicName()).getBoolean("use-project-settings", false)) {
            return new IScopeContext[]{projectScope, new InstanceScope(), new DefaultScope()};
        }
        return new IScopeContext[]{new InstanceScope(), new DefaultScope()};
    }

    private NewXMLGenerator createGeneratorForCatalogEntry(ICatalogEntry n) {
        NewXMLGenerator gen = new NewXMLGenerator();
        String uri = n.getURI();
        XMLSchemaValidationChecker validator = new XMLSchemaValidationChecker();
        validator.isValid(uri);
        CMDocument doc = ContentModelManager.getInstance().createCMDocument(uri, null);
        gen.setCMDocument(doc);
        gen.setDefaultSystemId(uri);
        int buildPolicy = 0;
        buildPolicy = buildPolicy | 4 | 0x10;
        gen.setBuildPolicy(buildPolicy |= 8);
        String defaultRootName = (String)gen.getCMDocument().getProperty("http://org.eclipse.wst/cm/properties/defaultRootName");
        CMNamedNodeMap nameNodeMap = gen.getCMDocument().getElements();
        Iterator it = nameNodeMap.iterator();
        String rootNode = null;
        while (it.hasNext()) {
            CMNode test = (CMNode)it.next();
            String string = rootNode = rootNode == null ? test.getNodeName() : rootNode;
            if (!test.getNodeName().equals(defaultRootName)) continue;
            rootNode = test.getNodeName();
            break;
        }
        gen.setRootElementName(rootNode);
        gen.setXMLCatalogEntry(n);
        try {
            gen.createNamespaceInfoList();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return gen;
    }
}

