/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.as.test.core.parametized.server;

import java.util.Collection;
import junit.framework.TestCase;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.wst.server.core.IServer;
import org.eclipse.wst.server.core.IServerWorkingCopy;
import org.jboss.ide.eclipse.as.core.server.IServerModeDetails;
import org.jboss.ide.eclipse.as.core.server.internal.LocalServerModeDetails;
import org.jboss.ide.eclipse.as.rse.core.RSEServerModeDetails;
import org.jboss.ide.eclipse.as.wtp.core.server.behavior.ServerProfileModel;
import org.jboss.tools.as.test.core.internal.utils.ServerCreationTestUtils;
import org.jboss.tools.as.test.core.internal.utils.ServerParameterUtils;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleException;

@RunWith(value=Parameterized.class)
public class ServerModeRuntimeDetailsTest
extends TestCase {
    private String serverType;
    private IServer server;

    @Parameterized.Parameters
    public static Collection<Object[]> data() {
        return ServerParameterUtils.asCollection(ServerParameterUtils.getJBossServerTypeParameters());
    }

    public ServerModeRuntimeDetailsTest(String serverType) {
        this.serverType = serverType;
    }

    @Before
    public void setUp() {
        this.server = ServerCreationTestUtils.createMockServerWithRuntime(this.serverType, String.valueOf(((Object)((Object)this)).getClass().getName()) + this.serverType);
    }

    @After
    public void tearDown() throws Exception {
        ServerCreationTestUtils.deleteAllServersAndRuntimes();
    }

    @Test
    public void testServerDefaults() {
        ServerModeRuntimeDetailsTest.forceStart("org.jboss.ide.eclipse.as.rse.core");
        IServerModeDetails ret = (IServerModeDetails)Platform.getAdapterManager().getAdapter((Object)this.server, IServerModeDetails.class);
        ServerModeRuntimeDetailsTest.assertNotNull((Object)ret);
        ServerModeRuntimeDetailsTest.assertTrue((boolean)(ret instanceof LocalServerModeDetails));
        IServerWorkingCopy wc = this.server.createWorkingCopy();
        ServerProfileModel.setProfile((IServerWorkingCopy)wc, (String)"rse");
        try {
            this.server = wc.save(true, (IProgressMonitor)new NullProgressMonitor());
        }
        catch (CoreException ce) {
            ServerModeRuntimeDetailsTest.fail((String)ce.getMessage());
        }
        ret = (IServerModeDetails)Platform.getAdapterManager().getAdapter((Object)this.server, IServerModeDetails.class);
        ServerModeRuntimeDetailsTest.assertNotNull((Object)ret);
        ServerModeRuntimeDetailsTest.assertTrue((boolean)(ret instanceof RSEServerModeDetails));
        wc = this.server.createWorkingCopy();
        ServerProfileModel.setProfile((IServerWorkingCopy)wc, (String)"garbage222");
        try {
            this.server = wc.save(true, (IProgressMonitor)new NullProgressMonitor());
        }
        catch (CoreException ce) {
            ServerModeRuntimeDetailsTest.fail((String)ce.getMessage());
        }
        ret = (IServerModeDetails)Platform.getAdapterManager().getAdapter((Object)this.server, IServerModeDetails.class);
        ServerModeRuntimeDetailsTest.assertNull((Object)ret);
    }

    private static boolean forceStart(String bundleId) {
        Bundle bundle = Platform.getBundle((String)bundleId);
        if (bundle != null && bundle.getState() != 32) {
            try {
                bundle.start();
            }
            catch (BundleException bundleException) {
                // empty catch block
            }
        }
        return bundle.getState() == 32;
    }
}

