/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.as.test.core.parametized.server;

import java.io.File;
import java.util.Collection;
import junit.framework.TestCase;
import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.wst.server.core.IServer;
import org.jboss.ide.eclipse.as.core.JBossServerCorePlugin;
import org.jboss.tools.as.test.core.ASMatrixTests;
import org.jboss.tools.as.test.core.internal.utils.ServerCreationTestUtils;
import org.jboss.tools.as.test.core.parametized.server.ServerParameterUtils;
import org.jboss.tools.test.util.JobUtils;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class XPathModelTest
extends TestCase {
    public static int serverCount = 0;
    private String serverType;

    static {
        JobUtils.waitForIdle((long)5000L);
    }

    @Parameterized.Parameters
    public static Collection<Object[]> data() {
        return ServerParameterUtils.asCollection(ServerParameterUtils.getJBossServerTypeParamterers());
    }

    @Before
    public void setUp() {
        JobUtils.waitForIdle();
    }

    public XPathModelTest(String serverType) {
        this.serverType = serverType;
    }

    @After
    public void tearDown() throws Exception {
        try {
            ASMatrixTests.cleanup();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Test
    public void serverTestImpl() {
        TestListener listener = new TestListener();
        Job.getJobManager().addJobChangeListener((IJobChangeListener)listener);
        System.out.println("creating server for type " + this.serverType);
        IServer server = ServerCreationTestUtils.createMockServerWithRuntime(this.serverType, "server" + ++serverCount);
        System.out.println("Expecting server created and xpath model created");
        File xpathFile = JBossServerCorePlugin.getServerStateLocation((IServer)server).append("xpaths.xml").toFile();
        Job j = listener.getJob();
        try {
            j.join();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        Job.getJobManager().removeJobChangeListener((IJobChangeListener)listener);
        boolean found = xpathFile.exists();
        if (!found) {
            System.out.println("The XPath File has not been created for servertype=" + this.serverType + ". Xpaths will be lost on workspace restart");
            XPathModelTest.fail((String)("The XPath File has not been created for servertype=" + this.serverType + ". Xpaths will be lost on workspace restart"));
        }
    }

    private class TestListener
    implements IJobChangeListener {
        private Job xpathJob = null;

        private TestListener() {
        }

        public void aboutToRun(IJobChangeEvent event) {
        }

        public void awake(IJobChangeEvent event) {
        }

        public void done(IJobChangeEvent event) {
        }

        public void running(IJobChangeEvent event) {
        }

        public void scheduled(IJobChangeEvent event) {
            Job sched = event.getJob();
            if (sched.getName().equals("Add Server XPath Details")) {
                this.xpathJob = sched;
            }
        }

        public void sleeping(IJobChangeEvent event) {
        }

        public Job getJob() {
            return this.xpathJob;
        }
    }
}

