/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.archives.scanner;

import java.io.File;
import org.jboss.tools.archives.scanner.Scanner;
import org.jboss.tools.archives.scanner.internal.MatchPatterns;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractScanner<T>
implements Scanner<T> {
    public static final String[] DEFAULTEXCLUDES = new String[]{"**/*~", "**/#*#", "**/.#*", "**/%*%", "**/._*", "**/CVS", "**/CVS/**", "**/.cvsignore", "**/RCS", "**/RCS/**", "**/SCCS", "**/SCCS/**", "**/vssver.scc", "**/project.pj", "**/.svn", "**/.svn/**", "**/.arch-ids", "**/.arch-ids/**", "**/.bzr", "**/.bzr/**", "**/.MySCMServerInfo", "**/.DS_Store", "**/.metadata", "**/.metadata/**", "**/.hg", "**/.hg/**", "**/.git", "**/.gitignore", "**/.gitattributes", "**/.git/**", "**/BitKeeper", "**/BitKeeper/**", "**/ChangeSet", "**/ChangeSet/**", "**/_darcs", "**/_darcs/**", "**/.darcsrepo", "**/.darcsrepo/**", "**/-darcs-backup*", "**/.darcs-temp-mail"};
    protected String[] includes;
    private MatchPatterns includesPatterns;
    protected String[] excludes;
    private MatchPatterns excludesPatterns;
    protected boolean isCaseSensitive = true;

    public void setCaseSensitive(boolean isCaseSensitive) {
        this.isCaseSensitive = isCaseSensitive;
    }

    @Override
    public void setIncludes(String[] includes) {
        if (includes == null || includes.length == 0) {
            this.includes = null;
        } else {
            this.includes = new String[includes.length];
            int i = 0;
            while (i < includes.length) {
                this.includes[i] = this.normalizePattern(includes[i]);
                ++i;
            }
        }
    }

    @Override
    public void setExcludes(String[] excludes) {
        if (excludes == null) {
            this.excludes = null;
        } else {
            this.excludes = new String[excludes.length];
            int i = 0;
            while (i < excludes.length) {
                this.excludes[i] = this.normalizePattern(excludes[i]);
                ++i;
            }
        }
    }

    private String normalizePattern(String pattern) {
        if ((pattern = pattern.trim()).startsWith("%regex[")) {
            pattern = File.separatorChar == '\\' ? AbstractScanner.replace(pattern, "/", "\\\\") : AbstractScanner.replace(pattern, "\\\\", "/");
        } else if ((pattern = pattern.replace(File.separatorChar == '/' ? (char)'\\' : '/', File.separatorChar)).endsWith(File.separator)) {
            pattern = String.valueOf(pattern) + "**";
        }
        return pattern;
    }

    private static String replace(String text, String repl, String with) {
        int end;
        if (text == null || repl == null || with == null || repl.length() == 0) {
            return text;
        }
        StringBuilder buf = new StringBuilder(text.length());
        int start = 0;
        while ((end = text.indexOf(repl, start)) != -1) {
            buf.append(text, start, end).append(with);
            start = end + repl.length();
        }
        buf.append(text, start, text.length());
        return buf.toString();
    }

    protected boolean isIncluded(String name) {
        return this.includesPatterns.matches(name, this.isCaseSensitive);
    }

    protected boolean isIncluded(String name, String[] tokenizedName) {
        return this.includesPatterns.matches(name, tokenizedName, this.isCaseSensitive);
    }

    protected boolean couldHoldIncluded(String name) {
        return this.includesPatterns.matchesPatternStart(name, this.isCaseSensitive);
    }

    protected boolean isExcluded(String name) {
        return this.excludesPatterns.matches(name, this.isCaseSensitive);
    }

    protected boolean isExcluded(String name, String[] tokenizedName) {
        return this.excludesPatterns.matches(name, tokenizedName, this.isCaseSensitive);
    }

    @Override
    public void addDefaultExcludes() {
        int excludesLength = this.excludes == null ? 0 : this.excludes.length;
        String[] newExcludes = new String[excludesLength + DEFAULTEXCLUDES.length];
        if (excludesLength > 0) {
            System.arraycopy(this.excludes, 0, newExcludes, 0, excludesLength);
        }
        int i = 0;
        while (i < DEFAULTEXCLUDES.length) {
            newExcludes[i + excludesLength] = DEFAULTEXCLUDES[i].replace('/', File.separatorChar);
            ++i;
        }
        this.excludes = newExcludes;
    }

    protected void setupDefaultFilters() {
        if (this.includes == null) {
            this.includes = new String[1];
            this.includes[0] = "**";
        }
        if (this.excludes == null) {
            this.excludes = new String[0];
        }
    }

    protected void setupMatchPatterns() {
        this.includesPatterns = MatchPatterns.from(this.includes);
        this.excludesPatterns = MatchPatterns.from(this.excludes);
    }
}

