/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ide.eclipse.as.reddeer.server.requirement;

import java.util.List;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElementWrapper;
import javax.xml.bind.annotation.XmlElements;
import javax.xml.bind.annotation.XmlRootElement;
import org.jboss.ide.eclipse.as.reddeer.server.family.FamilyAS;
import org.jboss.ide.eclipse.as.reddeer.server.family.FamilyEAP;
import org.jboss.ide.eclipse.as.reddeer.server.family.FamilyWildFly;
import org.jboss.reddeer.requirements.server.IServerFamily;
import org.jboss.reddeer.requirements.server.IServerReqConfig;

@XmlRootElement(name="jboss-server-requirement", namespace="http://www.jboss.org/NS/ServerReq")
public class ServerRequirementConfig
implements IServerReqConfig {
    private String runtime;
    @XmlElementWrapper(name="type", namespace="http://www.jboss.org/NS/ServerReq")
    @XmlElements(value={@XmlElement(name="familyAS", namespace="http://www.jboss.org/NS/ServerReq", type=FamilyAS.class), @XmlElement(name="familyEAP", namespace="http://www.jboss.org/NS/ServerReq", type=FamilyEAP.class), @XmlElement(name="familyWildFly", namespace="http://www.jboss.org/NS/ServerReq", type=FamilyWildFly.class)})
    private List<IServerFamily> family;
    @XmlElement(namespace="http://www.jboss.org/NS/ServerReq")
    private Remote remote;

    public IServerFamily getServerFamily() {
        return this.family.get(0);
    }

    public String getRuntime() {
        return this.runtime;
    }

    private static String safeProperty(String s) {
        String key;
        String v;
        if (s != null && s.startsWith("${") && s.endsWith("}") && (v = System.getProperty(key = s.substring(2, s.length() - 1))) != null) {
            return v;
        }
        return s;
    }

    @XmlElement(namespace="http://www.jboss.org/NS/ServerReq")
    public void setRuntime(String runtime) {
        this.runtime = ServerRequirementConfig.safeProperty(runtime);
    }

    public Remote getRemote() {
        return this.remote;
    }

    public boolean equals(Object arg) {
        if (arg == null || !(arg instanceof ServerRequirementConfig)) {
            return false;
        }
        if (arg == this) {
            return true;
        }
        ServerRequirementConfig conf = (ServerRequirementConfig)arg;
        if (this.getRuntime() == null && conf.getRuntime() != null || this.getRuntime() != null && conf.getRuntime() == null) {
            return false;
        }
        IServerFamily family1 = this.getServerFamily();
        IServerFamily family2 = conf.getServerFamily();
        if (!this.runtime.equals(conf.runtime) || family1 == null && family2 != null) {
            return false;
        }
        return family1.getLabel().equals(family2.getLabel()) && family1.getVersion().equals(family2.getVersion());
    }

    @XmlRootElement(name="remote", namespace="http://www.jboss.org/NS/ServerReq")
    public static class Remote {
        private String host;
        private String remoteServerHome;
        private String username;
        private String password;
        private boolean isExternallyManaged;

        public String getHost() {
            return this.host;
        }

        @XmlElement(namespace="http://www.jboss.org/NS/ServerReq")
        public void setHost(String hostname) {
            this.host = ServerRequirementConfig.safeProperty(hostname);
        }

        public String getRemoteServerHome() {
            return this.remoteServerHome;
        }

        @XmlElement(namespace="http://www.jboss.org/NS/ServerReq", name="remote-server-home")
        public void setRemoteServerHome(String home) {
            this.remoteServerHome = ServerRequirementConfig.safeProperty(home);
        }

        public String getUsername() {
            return this.username;
        }

        @XmlElement(namespace="http://www.jboss.org/NS/ServerReq")
        public void setUsername(String username) {
            this.username = ServerRequirementConfig.safeProperty(username);
        }

        public String getPassword() {
            return this.password;
        }

        @XmlElement(namespace="http://www.jboss.org/NS/ServerReq")
        public void setPassword(String password) {
            this.password = ServerRequirementConfig.safeProperty(password);
        }

        public boolean getIsExternallyManaged() {
            return this.isExternallyManaged;
        }

        @XmlElement(namespace="http://www.jboss.org/NS/ServerReq")
        public void setIsExternallyManaged(boolean isExternallyManaged) {
            this.isExternallyManaged = isExternallyManaged;
        }
    }
}

