/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ide.eclipse.as.wtp.core.modules;

import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.jst.j2ee.internal.deployables.BinaryFileModuleDelegate;
import org.eclipse.wst.common.componentcore.ComponentCore;
import org.eclipse.wst.common.componentcore.internal.StructureEdit;
import org.eclipse.wst.common.componentcore.internal.flat.IChildModuleReference;
import org.eclipse.wst.common.componentcore.resources.IVirtualComponent;
import org.eclipse.wst.common.project.facet.core.IFacetedProject;
import org.eclipse.wst.common.project.facet.core.IProjectFacet;
import org.eclipse.wst.common.project.facet.core.IProjectFacetVersion;
import org.eclipse.wst.common.project.facet.core.ProjectFacetsManager;
import org.eclipse.wst.server.core.IModule;
import org.eclipse.wst.server.core.internal.Module;
import org.eclipse.wst.server.core.internal.ModuleFactory;
import org.eclipse.wst.server.core.internal.ServerPlugin;
import org.eclipse.wst.server.core.model.ModuleDelegate;
import org.eclipse.wst.server.core.util.ProjectModuleFactoryDelegate;
import org.eclipse.wst.web.internal.deployables.FlatComponentDeployable;
import org.jboss.ide.eclipse.as.wtp.core.modules.JBTFlatModuleDelegate;

public abstract class JBTFlatProjectModuleFactory
extends ProjectModuleFactoryDelegate
implements IResourceChangeListener {
    public static final String BINARY_PREFIX = "/binary:";
    protected Map<IModule, FlatComponentDeployable> moduleDelegates = new HashMap<IModule, FlatComponentDeployable>(5);

    public static void ensureFactoryLoaded(String factoryId) {
        ModuleFactory[] factories = ServerPlugin.getModuleFactories();
        int i = 0;
        while (i < factories.length) {
            if (factories[i].getId().equals(factoryId)) {
                factories[i].getDelegate((IProgressMonitor)new NullProgressMonitor());
            }
            ++i;
        }
    }

    public void initialize() {
        super.initialize();
        ResourcesPlugin.getWorkspace().addResourceChangeListener((IResourceChangeListener)this);
    }

    protected IModule[] createModules(IProject project) {
        IVirtualComponent component = ComponentCore.createComponent((IProject)project);
        if (component != null) {
            return this.createModuleDelegates(component);
        }
        return null;
    }

    public ModuleDelegate getModuleDelegate(IModule module) {
        if (module == null) {
            return null;
        }
        ModuleDelegate md = (ModuleDelegate)this.moduleDelegates.get(module);
        if (md == null && ((Module)module).getInternalId().startsWith(BINARY_PREFIX)) {
            return this.createBinaryDelegate(module);
        }
        if (md == null) {
            this.createModules(module.getProject());
            md = (ModuleDelegate)this.moduleDelegates.get(module);
        }
        return md;
    }

    protected abstract boolean canHandleProject(IProject var1);

    protected abstract String getModuleType(IProject var1);

    protected abstract String getModuleVersion(IProject var1);

    protected abstract String getModuleType(File var1);

    protected abstract String getModuleVersion(File var1);

    protected FlatComponentDeployable createModuleDelegate(IProject project, IVirtualComponent component) {
        return new JBTFlatModuleDelegate(project, component, this);
    }

    protected FlatComponentDeployable getNestedDelegate(IVirtualComponent component) {
        return new JBTFlatModuleDelegate(component.getProject(), component, this);
    }

    protected IModule[] createModuleDelegates(IVirtualComponent component) {
        if (component != null && this.canHandleProject(component.getProject())) {
            String type = this.getModuleType(component.getProject());
            String version = this.getModuleVersion(component.getProject());
            IModule module = this.createModule(component.getName(), component.getName(), type, version, component.getProject());
            FlatComponentDeployable moduleDelegate = this.createModuleDelegate(component.getProject(), component);
            this.moduleDelegates.put(module, moduleDelegate);
            return new IModule[]{module};
        }
        return null;
    }

    public IModule createChildModule(FlatComponentDeployable parent, IChildModuleReference child) {
        File file = child.getFile();
        if (file != null) {
            Path p = new Path(file.getAbsolutePath());
            String id = BINARY_PREFIX + file.getAbsolutePath();
            IModule nestedModule = this.createModule(id, file.getName(), this.getModuleType(file), this.getModuleVersion(file), parent.getProject());
            FlatComponentDeployable moduleDelegate = this.getNestedDelegate(child.getComponent());
            this.moduleDelegates.put(nestedModule, moduleDelegate);
            return nestedModule;
        }
        return null;
    }

    public ModuleDelegate createBinaryDelegate(IModule module) {
        String internalId = ((Module)module).getInternalId();
        String path = internalId.substring(BINARY_PREFIX.length());
        File f = new File(path);
        return new BinaryFileModuleDelegate(f);
    }

    public void resourceChanged(IResourceChangeEvent event) {
        this.cleanAllDelegates();
    }

    protected void cleanAllDelegates() {
        Iterator<FlatComponentDeployable> i = this.moduleDelegates.values().iterator();
        while (i.hasNext()) {
            i.next().clearCache();
        }
        this.modulesChanged();
    }

    protected IPath[] getListenerPaths() {
        return new IPath[]{new Path(".project"), new Path(StructureEdit.MODULE_META_FILE_NAME), new Path(".settings/org.eclipse.wst.common.project.facet.core.xml")};
    }

    protected void clearCache(IProject project) {
        super.clearCache(project);
        ArrayList<IModule> modulesToRemove = null;
        for (IModule module : this.moduleDelegates.keySet()) {
            if (module.getProject() == null || !module.getProject().equals((Object)project)) continue;
            if (modulesToRemove == null) {
                modulesToRemove = new ArrayList<IModule>();
            }
            modulesToRemove.add(module);
        }
        if (modulesToRemove != null) {
            for (IModule module : modulesToRemove) {
                this.moduleDelegates.remove(module);
            }
        }
    }

    protected String getFacetVersion(IProject project, String facetName) {
        IProjectFacet facet = ProjectFacetsManager.getProjectFacet((String)facetName);
        IFacetedProject facetedProject = null;
        try {
            facetedProject = ProjectFacetsManager.create((IProject)project);
            if (facetedProject.hasProjectFacet(facet)) {
                IProjectFacetVersion version = facetedProject.getProjectFacetVersion(facet);
                return version.getVersionString();
            }
        }
        catch (CoreException coreException) {
            // empty catch block
        }
        return null;
    }

    protected boolean hasProjectFacet(IProject project, String facetName) {
        return this.verifyFacetExists(project, facetName);
    }

    @Deprecated
    protected boolean verifyFacetExists(IProject project, String facetName) {
        IProjectFacet facet = ProjectFacetsManager.getProjectFacet((String)facetName);
        IFacetedProject facetedProject = null;
        try {
            facetedProject = ProjectFacetsManager.create((IProject)project);
            if (facetedProject.hasProjectFacet(facet)) {
                return true;
            }
        }
        catch (CoreException coreException) {
            // empty catch block
        }
        return false;
    }
}

