/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ide.eclipse.as.wtp.core.server.behavior;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Date;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.osgi.util.NLS;
import org.eclipse.wst.server.core.IServerAttributes;
import org.eclipse.wst.server.core.internal.ProgressUtil;
import org.eclipse.wst.server.core.internal.ServerPlugin;
import org.jboss.ide.eclipse.as.core.server.IDeployableServer;
import org.jboss.ide.eclipse.as.core.util.FileUtil;
import org.jboss.ide.eclipse.as.core.util.ProgressMonitorUtil;
import org.jboss.ide.eclipse.as.core.util.ServerConverter;
import org.jboss.ide.eclipse.as.core.util.StreamUtils;
import org.jboss.ide.eclipse.as.wtp.core.Messages;
import org.jboss.ide.eclipse.as.wtp.core.server.behavior.AbstractSubsystemController;
import org.jboss.ide.eclipse.as.wtp.core.server.behavior.IFilesystemController;

public class LocalFilesystemController
extends AbstractSubsystemController
implements IFilesystemController {
    public static final String ENV_TEMPORARY_DEPLOY_DIRECTORY = "ISubsystemController.TemporaryDeployFolder";
    private static final File tempDir = ServerPlugin.getInstance().getStateLocation().toFile();
    private static final String TEMPFILE_PREFIX = "tmp";

    @Override
    public IStatus copyFile(File file, IPath absoluteRemotePath, IProgressMonitor monitor) throws CoreException {
        monitor.beginTask("Copying " + absoluteRemotePath.toString(), 100);
        if (file != null) {
            if (!file.exists()) {
                return new Status(4, "org.jboss.ide.eclipse.as.wtp.core", 1644298251, NLS.bind((String)org.eclipse.wst.server.core.internal.Messages.errorReading, (Object)file.getAbsolutePath()), null);
            }
            FileInputStream in = null;
            try {
                in = new FileInputStream(file);
            }
            catch (IOException e) {
                new Status(4, "org.jboss.ide.eclipse.as.wtp.core", 1644298251, NLS.bind((String)org.eclipse.wst.server.core.internal.Messages.errorReading, (Object)file.getAbsolutePath()), (Throwable)e);
            }
            IStatus ret = this.copyFile(in, absoluteRemotePath, file.lastModified());
            monitor.worked(100);
            monitor.done();
            if (ret != null && !ret.isOK()) {
                return ret;
            }
        }
        return Status.OK_STATUS;
    }

    private IStatus copyFile(InputStream in, String to) {
        try {
            FileUtil.writeTo(in, to);
            IStatus iStatus = Status.OK_STATUS;
            return iStatus;
        }
        catch (IOException e) {
            Status status = new Status(4, "org.jboss.ide.eclipse.as.wtp.core", 1644298251, NLS.bind((String)org.eclipse.wst.server.core.internal.Messages.errorCopyingFile, (Object[])new String[]{to, e.getLocalizedMessage()}), (Throwable)e);
            return status;
        }
        finally {
            StreamUtils.safeClose(in);
        }
    }

    private IStatus copyFile(InputStream in, IPath to, long ts) throws CoreException {
        File tempFile = null;
        try {
            try {
                File file = to.toFile();
                tempFile = this.writeToTempFile(in, to);
                this.moveTempFile(tempFile, file);
                if (ts != -1L && ts != 0L) {
                    file.setLastModified(ts);
                }
            }
            catch (CoreException e) {
                throw e;
            }
            catch (Exception e) {
                Status status = new Status(4, "org.jboss.ide.eclipse.as.wtp.core", 1644298251, NLS.bind((String)org.eclipse.wst.server.core.internal.Messages.errorCopyingFile, (Object)to.toString(), (Object)e.getLocalizedMessage()), null);
                if (tempFile != null && tempFile.exists()) {
                    tempFile.deleteOnExit();
                }
                StreamUtils.safeClose(in);
                return status;
            }
        }
        finally {
            if (tempFile != null && tempFile.exists()) {
                tempFile.deleteOnExit();
            }
            StreamUtils.safeClose(in);
        }
        return null;
    }

    private File writeToTempFile(InputStream in, IPath filePath) throws IOException {
        File tempFile = File.createTempFile(TEMPFILE_PREFIX, "." + filePath.getFileExtension(), this.getTempFolder());
        FileUtil.writeTo(in, tempFile);
        return tempFile;
    }

    private void moveTempFile(File tempFile, File file) throws CoreException {
        if (file.exists() && !this.safeDelete(file, 2)) {
            try {
                FileInputStream in = new FileInputStream(tempFile);
                IStatus status = this.copyFile(in, file.getPath());
                this.throwOnErrorStatus(file, status);
                return;
            }
            catch (FileNotFoundException fileNotFoundException) {
            }
            finally {
                tempFile.delete();
            }
        }
        if (!this.safeRename(tempFile, file, 10)) {
            throw new CoreException((IStatus)new Status(4, "org.jboss.ide.eclipse.as.wtp.core", 1644298249, NLS.bind((String)Messages.PublishRenameFailure, (Object)tempFile.toString(), (Object)file.getAbsolutePath()), null));
        }
    }

    private void throwOnErrorStatus(File file, IStatus status) throws CoreException {
        if (!status.isOK()) {
            String msg = NLS.bind((String)org.eclipse.wst.server.core.internal.Messages.errorDeleting, (Object)file.toString());
            Throwable t = status.getException() == null ? new Exception(msg) : status.getException();
            MultiStatus status2 = new MultiStatus("org.jboss.ide.eclipse.as.wtp.core", 1644298251, msg, t);
            status2.add(status);
            throw new CoreException((IStatus)status2);
        }
    }

    private boolean safeRename(File from, File to, int retrys) {
        File dir = to.getParentFile();
        if (dir != null && !dir.exists()) {
            dir.mkdirs();
        }
        int count = 0;
        while (count < retrys) {
            if (from.renameTo(to)) {
                return true;
            }
            if (++count >= retrys) continue;
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        return false;
    }

    protected File getTempFolder() {
        IPath tempFolder = (IPath)this.getEnvironment().get(ENV_TEMPORARY_DEPLOY_DIRECTORY);
        File f = null;
        if (tempFolder != null) {
            f = tempFolder.toFile();
        } else {
            String t;
            IDeployableServer ds = ServerConverter.getDeployableServer((IServerAttributes)this.getServer());
            if (ds != null && (t = ds.getTempDeployFolder()) != null) {
                f = new File(t);
            }
        }
        if (f != null) {
            if (!f.exists()) {
                f.mkdirs();
            }
            if (f.exists()) {
                return f;
            }
        }
        return tempDir;
    }

    @Override
    public IStatus deleteResource(IPath absolutePath, IProgressMonitor monitor) throws CoreException {
        File file = absolutePath.toFile();
        IStatus results = null;
        if (file.isDirectory()) {
            results = this.deleteDirectory(absolutePath.toFile(), monitor);
        } else if (!file.delete()) {
            String msg = NLS.bind((String)org.eclipse.wst.server.core.internal.Messages.errorDeleting, (Object)absolutePath.toFile().getAbsolutePath());
            Status s = new Status(4, "org.jboss.ide.eclipse.as.wtp.core", 1644298251, msg, (Throwable)new Exception(msg));
            results = s;
        }
        return results == null ? Status.OK_STATUS : results;
    }

    private IStatus deleteDirectory(File dir, IProgressMonitor monitor) throws CoreException {
        if (!dir.exists() || !dir.isDirectory()) {
            return new Status(4, "org.jboss.ide.eclipse.as.wtp.core", 1644298251, NLS.bind((String)org.eclipse.wst.server.core.internal.Messages.errorNotADirectory, (Object)dir.getAbsolutePath()), null);
        }
        File workspaceFile = ResourcesPlugin.getWorkspace().getRoot().getLocation().toFile();
        if (dir.equals(workspaceFile)) {
            throw new CoreException((IStatus)new Status(4, "org.jboss.ide.eclipse.as.wtp.core", "Attempt to delete workspace prevented", (Throwable)new Exception("Attempt to delete workspace prevented")));
        }
        ArrayList<Object> status = new ArrayList<Object>(2);
        try {
            File[] files = dir.listFiles();
            int size = files.length;
            monitor = ProgressUtil.getMonitorFor((IProgressMonitor)monitor);
            monitor.beginTask(NLS.bind((String)org.eclipse.wst.server.core.internal.Messages.deletingTask, (Object[])new String[]{dir.getAbsolutePath()}), size * 10);
            boolean deleteCurrent = true;
            int i = 0;
            while (i < size) {
                File current = files[i];
                if (current.isFile()) {
                    if (!current.delete()) {
                        String msg = NLS.bind((String)org.eclipse.wst.server.core.internal.Messages.errorDeleting, (Object)files[i].getAbsolutePath());
                        status.add(new Status(4, "org.jboss.ide.eclipse.as.wtp.core", 1644298251, msg, (Throwable)new Exception(msg)));
                        deleteCurrent = false;
                    }
                    monitor.worked(10);
                } else if (current.isDirectory()) {
                    monitor.subTask(NLS.bind((String)org.eclipse.wst.server.core.internal.Messages.deletingTask, (Object[])new String[]{current.getAbsolutePath()}));
                    IStatus stat = this.deleteDirectory(current, ProgressMonitorUtil.getSubMon(monitor, 10));
                    if (stat != null && !stat.isOK()) {
                        deleteCurrent = false;
                        status.add(stat);
                    }
                }
                ++i;
            }
            if (deleteCurrent && !dir.delete()) {
                String msg = NLS.bind((String)org.eclipse.wst.server.core.internal.Messages.errorDeleting, (Object)dir.getAbsolutePath());
                status.add(new Status(4, "org.jboss.ide.eclipse.as.wtp.core", 1644298251, msg, (Throwable)new Exception(msg)));
            }
            monitor.done();
        }
        catch (Exception e) {
            status.add(new Status(4, "org.jboss.ide.eclipse.as.wtp.core", 1644298251, e.getLocalizedMessage(), (Throwable)e));
        }
        if (status.size() > 0) {
            String msg = NLS.bind((String)org.eclipse.wst.server.core.internal.Messages.errorDeleting, (Object)dir.getAbsolutePath());
            IStatus[] arr = status.toArray(new IStatus[status.size()]);
            return new MultiStatus("org.jboss.ide.eclipse.as.wtp.core", 1644298251, arr, msg, (Throwable)new Exception(msg));
        }
        return Status.OK_STATUS;
    }

    private boolean safeDelete(File f, int retrys) {
        int count = 0;
        while (count < retrys) {
            if (!f.exists()) {
                return true;
            }
            f.delete();
            if (!f.exists()) {
                return true;
            }
            if (++count >= retrys) continue;
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        return false;
    }

    @Override
    public IStatus makeDirectoryIfRequired(IPath absolutePath, IProgressMonitor monitor) throws CoreException {
        absolutePath.toFile().mkdirs();
        return Status.OK_STATUS;
    }

    @Override
    public IStatus touchResource(IPath absolutePath, IProgressMonitor monitor) throws CoreException {
        File tmp = absolutePath.toFile();
        if (!tmp.exists()) {
            try {
                tmp.createNewFile();
            }
            catch (IOException ioe) {
                throw new CoreException((IStatus)new Status(4, "org.jboss.ide.eclipse.as.wtp.core", "Unable to create file " + absolutePath));
            }
        }
        tmp.setLastModified(new Date().getTime());
        return Status.OK_STATUS;
    }

    @Override
    public boolean isFile(IPath absolutePath, IProgressMonitor monitor) throws CoreException {
        File tmp = absolutePath.toFile();
        return tmp.exists() && tmp.isFile();
    }

    @Override
    public boolean exists(IPath path, IProgressMonitor monitor) throws CoreException {
        return path.toFile().exists();
    }
}

