/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ide.eclipse.as.wtp.core.util;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.jdt.internal.launching.environments.EnvironmentsManager;
import org.eclipse.jdt.launching.IVMInstall;
import org.eclipse.jdt.launching.IVMInstall2;
import org.eclipse.jdt.launching.IVMInstallType;
import org.eclipse.jdt.launching.JavaRuntime;
import org.eclipse.jdt.launching.environments.IExecutionEnvironment;

public class VMInstallUtil {
    private static final Pattern MAJOR_MINOR_PATTERN = Pattern.compile("^(\\d+)\\.(\\d+)\\..*");
    private static final boolean PREFER_HIGHEST = true;
    private static final boolean PREFER_LOWEST = false;

    public static IVMInstall findVMInstall(String type, String id) {
        if (type != null && id != null) {
            IVMInstallType vmInstallType = JavaRuntime.getVMInstallType((String)type);
            IVMInstall[] vmInstalls = vmInstallType.getVMInstalls();
            int i = 0;
            while (i < vmInstalls.length) {
                if (id.equals(vmInstalls[i].getId())) {
                    return vmInstalls[i];
                }
                ++i;
            }
        }
        return null;
    }

    public static IVMInstall[] getAllVMInstalls() {
        ArrayList<IVMInstall> allRet = new ArrayList<IVMInstall>();
        IVMInstallType[] allTypes = JavaRuntime.getVMInstallTypes();
        int i = 0;
        while (i < allTypes.length) {
            IVMInstallType vmInstallType = allTypes[i];
            IVMInstall[] vmInstalls = vmInstallType.getVMInstalls();
            int j = 0;
            while (j < vmInstalls.length) {
                allRet.add(vmInstalls[j]);
                ++j;
            }
            ++i;
        }
        return allRet.toArray(new IVMInstall[allRet.size()]);
    }

    public static IVMInstall findVMInstall(IExecutionEnvironment min) {
        return VMInstallUtil.findVMInstall(min, null);
    }

    public static IVMInstall findVMInstall(IExecutionEnvironment min, IExecutionEnvironment max) {
        return VMInstallUtil.findVMInstall(min, max, min, false);
    }

    public static IVMInstall findVMInstall(IExecutionEnvironment min, IExecutionEnvironment max, IExecutionEnvironment defaultEnv) {
        return VMInstallUtil.findVMInstall(min, max, defaultEnv, false);
    }

    private static IVMInstall findVMInstall(IExecutionEnvironment min, IExecutionEnvironment max, IExecutionEnvironment defaultEnv, boolean preference) {
        IVMInstall install;
        int i;
        IVMInstall[] installs;
        if (defaultEnv != null && defaultEnv.getDefaultVM() != null && !VMInstallUtil.isHigherThanMaximumAllowed(min.getDefaultVM(), max)) {
            return defaultEnv.getDefaultVM();
        }
        if (!preference) {
            installs = min.getCompatibleVMs();
            i = 0;
            while (i < installs.length) {
                install = installs[i];
                if (min.isStrictlyCompatible(install)) {
                    return install;
                }
                ++i;
            }
        } else if (preference && max != null) {
            installs = max.getCompatibleVMs();
            i = 0;
            while (i < installs.length) {
                install = installs[i];
                if (max.isStrictlyCompatible(install)) {
                    return install;
                }
                ++i;
            }
        }
        if (min != null) {
            List<IVMInstall2> sorted;
            installs = VMInstallUtil.getValidJREs(min, max);
            IVMInstall workspaceDefault = JavaRuntime.getDefaultVMInstall();
            if (installs != null && workspaceDefault != null) {
                int i2 = 0;
                while (i2 < installs.length) {
                    if (workspaceDefault.equals(installs[i2])) {
                        return workspaceDefault;
                    }
                    ++i2;
                }
            }
            if ((sorted = VMInstallUtil.sortVMs(installs)).size() > 0) {
                if (!preference) {
                    return (IVMInstall)sorted.get(0);
                }
                if (preference) {
                    return (IVMInstall)sorted.get(sorted.size() - 1);
                }
            }
            if (installs != null && installs.length > 0 && installs[0] != null) {
                return installs[0];
            }
        }
        IVMInstall i3 = min == null ? null : min.getDefaultVM();
        return i3 == null ? JavaRuntime.getDefaultVMInstall() : i3;
    }

    public static boolean hasValidJRE(IExecutionEnvironment minimum, IExecutionEnvironment maximum, IExecutionEnvironment selected) {
        IVMInstall[] valid = VMInstallUtil.getValidJREs(minimum, maximum);
        ArrayList<IVMInstall> validArray = new ArrayList<IVMInstall>(Arrays.asList(valid));
        if (selected != null) {
            IVMInstall[] compatible = selected.getCompatibleVMs();
            int i = 0;
            while (i < compatible.length) {
                if (validArray.contains(compatible[i])) {
                    return true;
                }
                ++i;
            }
        }
        return false;
    }

    private static boolean isHigherThanMaximumAllowed(IVMInstall install, IExecutionEnvironment maximum) {
        if (maximum == null) {
            return false;
        }
        IExecutionEnvironment[] invalid = VMInstallUtil.findSuperEnvironments(maximum);
        int i = 0;
        while (i < invalid.length) {
            IVMInstall[] invalidArray = invalid[i].getCompatibleVMs();
            if (Arrays.asList(invalidArray).contains(install)) {
                return false;
            }
            ++i;
        }
        return true;
    }

    private static List<IVMInstall2> sortVMs(IVMInstall[] installs) {
        ArrayList<IVMInstall2> all = new ArrayList<IVMInstall2>();
        int i = 0;
        while (i < installs.length) {
            String version;
            if (installs[i] instanceof IVMInstall2 && (version = ((IVMInstall2)installs[i]).getJavaVersion()) != null) {
                try {
                    VMInstallUtil.getMajorMinor(version);
                    all.add((IVMInstall2)installs[i]);
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    // empty catch block
                }
            }
            ++i;
        }
        Collections.sort(all, new Comparator<IVMInstall2>(){

            @Override
            public int compare(IVMInstall2 o1, IVMInstall2 o2) {
                String arg0vers = o1.getJavaVersion();
                String arg1vers = o2.getJavaVersion();
                return VMInstallUtil.compareJavaVersions(arg0vers, arg1vers);
            }
        });
        return all;
    }

    private static int compareJavaVersions(String version0, String version1) {
        int[] arg1majorMinor;
        int[] arg0majorMinor = VMInstallUtil.getMajorMinor(version0);
        if (arg0majorMinor[0] < (arg1majorMinor = VMInstallUtil.getMajorMinor(version1))[0]) {
            return -1;
        }
        if (arg0majorMinor[0] > arg1majorMinor[0]) {
            return 1;
        }
        if (arg0majorMinor[1] < arg1majorMinor[1]) {
            return -1;
        }
        if (arg0majorMinor[1] > arg1majorMinor[1]) {
            return 1;
        }
        return 0;
    }

    private static int[] getMajorMinor(String version) {
        Matcher m = MAJOR_MINOR_PATTERN.matcher(version);
        if (!m.matches()) {
            throw new IllegalArgumentException("Malformed version string");
        }
        return new int[]{Integer.parseInt(m.group(1)), Integer.parseInt(m.group(2))};
    }

    public static IExecutionEnvironment[] findAllValidEnvironments(IExecutionEnvironment minimum, IExecutionEnvironment maximum) {
        ArrayList<IExecutionEnvironment> toReturn = new ArrayList<IExecutionEnvironment>();
        toReturn.add(minimum);
        if (maximum != null) {
            toReturn.add(maximum);
        }
        IExecutionEnvironment[] superEnv = VMInstallUtil.findSuperEnvironments(minimum);
        IExecutionEnvironment[] forbiddenEnv = VMInstallUtil.findSuperEnvironments(maximum);
        ArrayList<IExecutionEnvironment> superList = new ArrayList<IExecutionEnvironment>(Arrays.asList(superEnv));
        superList.removeAll(Arrays.asList(forbiddenEnv));
        Iterator<IExecutionEnvironment> it = superList.iterator();
        while (it.hasNext()) {
            IExecutionEnvironment working = it.next();
            if (working.getCompatibleVMs().length != 0 && !toReturn.contains(working)) continue;
            it.remove();
        }
        toReturn.addAll(superList);
        return toReturn.toArray(new IExecutionEnvironment[toReturn.size()]);
    }

    public static IExecutionEnvironment[] findSuperEnvironments(IExecutionEnvironment minimum) {
        if (minimum == null) {
            return new IExecutionEnvironment[0];
        }
        ArrayList<IExecutionEnvironment> toReturn = new ArrayList<IExecutionEnvironment>();
        IExecutionEnvironment[] all = EnvironmentsManager.getDefault().getExecutionEnvironments();
        int i = 0;
        while (i < all.length) {
            IExecutionEnvironment[] sub = all[i].getSubEnvironments();
            if (!toReturn.contains(all[i]) && Arrays.asList(sub).contains(minimum)) {
                toReturn.add(all[i]);
            }
            ++i;
        }
        return toReturn.toArray(new IExecutionEnvironment[toReturn.size()]);
    }

    public static IVMInstall[] getValidJREs(IExecutionEnvironment minimum, IExecutionEnvironment maximum) {
        if (minimum == null) {
            return new IVMInstall[0];
        }
        IVMInstall[] minimumInstalls = minimum.getCompatibleVMs();
        if (maximum == null) {
            return minimumInstalls;
        }
        ArrayList<IVMInstall> ret = new ArrayList<IVMInstall>(Arrays.asList(minimumInstalls));
        IExecutionEnvironment[] invalid = VMInstallUtil.findSuperEnvironments(maximum);
        int i = 0;
        while (i < invalid.length) {
            ret.removeAll(Arrays.asList(invalid[i].getCompatibleVMs()));
            ++i;
        }
        return ret.toArray(new IVMInstall[ret.size()]);
    }
}

