/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ide.eclipse.as.jmx.integration;

import java.io.IOException;
import java.net.MalformedURLException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.wst.server.core.IServer;
import org.eclipse.wst.server.core.IServerAttributes;
import org.eclipse.wst.server.core.IServerListener;
import org.eclipse.wst.server.core.ServerEvent;
import org.jboss.ide.eclipse.as.core.JBossServerCorePlugin;
import org.jboss.ide.eclipse.as.core.server.internal.ExtendedServerPropertiesAdapterFactory;
import org.jboss.ide.eclipse.as.core.server.internal.extendedproperties.JBossExtendedProperties;
import org.jboss.ide.eclipse.as.jmx.integration.AbstractJBossJMXConnectionProvider;
import org.jboss.ide.eclipse.as.jmx.integration.JBossJMXConnectionProviderModel;
import org.jboss.tools.jmx.core.ExtensionManager;
import org.jboss.tools.jmx.core.IConnectionProvider;
import org.jboss.tools.jmx.core.IConnectionProviderListener;
import org.jboss.tools.jmx.core.IConnectionWrapper;
import org.jboss.tools.jmx.core.providers.DefaultConnectionWrapper;
import org.jboss.tools.jmx.core.providers.MBeanServerConnectionDescriptor;

public class JBoss70ConnectionProvider
extends AbstractJBossJMXConnectionProvider {
    public static final String PROVIDER_ID = "org.jboss.ide.eclipse.as.core.extensions.jmx.JBoss70ConnectionProvider";

    public JBoss70ConnectionProvider() {
        JBossJMXConnectionProviderModel.getDefault().registerProvider(0, this);
    }

    @Override
    public String getName(IConnectionWrapper wrapper) {
        MBeanServerConnectionDescriptor desc;
        if (wrapper instanceof ExtendedDefaultConnectionWrapper && (desc = ((ExtendedDefaultConnectionWrapper)wrapper).getDescriptor()) != null) {
            return desc.getID();
        }
        return null;
    }

    @Override
    protected boolean belongsHere(IServer server) {
        int type;
        JBossExtendedProperties props = ExtendedServerPropertiesAdapterFactory.getJBossExtendedProperties((IServerAttributes)server);
        int n = type = props == null ? -1 : props.getJMXProviderType();
        return type == 0;
    }

    @Override
    protected IConnectionWrapper createConnection(IServer server) {
        return this.createDefaultServerConnection(server);
    }

    protected IConnectionWrapper createDefaultServerConnection(IServer server) {
        String SIMPLE_PREFIX = "service:jmx:rmi:///jndi/rmi://";
        String SIMPLE_SUFFIX = "/jmxrmi";
        String host = server.getHost();
        String port = "1090";
        String url = String.valueOf(SIMPLE_PREFIX) + host + ":" + port + SIMPLE_SUFFIX;
        MBeanServerConnectionDescriptor desc = new MBeanServerConnectionDescriptor(server.getName(), url, "", "");
        try {
            return new ExtendedDefaultConnectionWrapper(desc, server);
        }
        catch (MalformedURLException murle) {
            return null;
        }
    }

    @Override
    public String getId() {
        return PROVIDER_ID;
    }

    private class ExtendedDefaultConnectionWrapper
    extends DefaultConnectionWrapper
    implements IServerListener,
    IConnectionProviderListener {
        private IServer server;

        public ExtendedDefaultConnectionWrapper(MBeanServerConnectionDescriptor descriptor, IServer server) throws MalformedURLException {
            super(descriptor);
            this.server = server;
            server.addServerListener((IServerListener)this);
        }

        public void serverChanged(ServerEvent event) {
            int eventKind = event.getKind();
            if ((eventKind & 0x10) != 0 && (eventKind & 1) != 0) {
                boolean started = event.getServer().getServerState() == 2;
                try {
                    if (started) {
                        this.connect();
                    } else {
                        this.disconnect();
                    }
                }
                catch (IOException ioe) {
                    Status s = null;
                    s = started ? new Status(4, "org.jboss.ide.eclipse.as.core", "Unable to reach JBoss instance. Please ensure your server is up and exposes its management ports via the -Djboss.bind.address.management=yourwebsite.com system property.") : new Status(4, "org.jboss.ide.eclipse.as.core", "Error disconnecting from this server's JMX service: " + event.getServer().getName(), (Throwable)ioe);
                    JBossServerCorePlugin.log((IStatus)s);
                }
            }
        }

        public void connectionAdded(IConnectionWrapper connection) {
        }

        public void connectionRemoved(IConnectionWrapper connection) {
            if (connection == this) {
                this.server.removeServerListener((IServerListener)this);
            }
        }

        public void connectionChanged(IConnectionWrapper connection) {
        }

        public IConnectionProvider getProvider() {
            return ExtensionManager.getProvider((String)JBoss70ConnectionProvider.PROVIDER_ID);
        }
    }
}

