/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ide.eclipse.archives.core.model.internal;

import java.util.HashMap;
import org.eclipse.core.runtime.IPath;
import org.jboss.ide.eclipse.archives.core.model.IArchiveModelRootNode;
import org.jboss.ide.eclipse.archives.core.model.IArchiveNode;
import org.jboss.ide.eclipse.archives.core.model.IArchiveNodeDelta;
import org.jboss.ide.eclipse.archives.core.model.IArchiveStandardFileSet;
import org.jboss.ide.eclipse.archives.core.model.internal.ArchiveFileSetImpl;
import org.jboss.ide.eclipse.archives.core.model.internal.ArchiveFolderImpl;
import org.jboss.ide.eclipse.archives.core.model.internal.ArchiveImpl;
import org.jboss.ide.eclipse.archives.core.model.internal.ArchiveNodeDeltaImpl;
import org.jboss.ide.eclipse.archives.core.model.internal.xb.XbFileSet;
import org.jboss.ide.eclipse.archives.core.model.internal.xb.XbFolder;
import org.jboss.ide.eclipse.archives.core.model.internal.xb.XbPackage;
import org.jboss.ide.eclipse.archives.core.model.internal.xb.XbPackageNodeWithProperties;

public class ArchiveDeltaPreNodeFactory {
    public IArchiveNode createNode(IArchiveNodeDelta parentDelta, IArchiveNode postChange, HashMap attributeChanges, HashMap propertyChanges) {
        switch (postChange.getNodeType()) {
            case 2: {
                if (!(postChange instanceof IArchiveStandardFileSet)) break;
                XbFileSet fs = ArchiveDeltaPreNodeFactory.createFileset((ArchiveFileSetImpl)postChange, attributeChanges, propertyChanges);
                return new DeltaFileset(fs, parentDelta, postChange);
            }
            case 3: {
                if (!(postChange instanceof ArchiveFolderImpl)) break;
                XbFolder folder = ArchiveDeltaPreNodeFactory.createFolder((ArchiveFolderImpl)postChange, attributeChanges, propertyChanges);
                return new DeltaFolder(folder, parentDelta, postChange);
            }
            case 0: {
                if (!(postChange instanceof ArchiveImpl)) break;
                XbPackage pack = ArchiveDeltaPreNodeFactory.createPackage((ArchiveImpl)postChange, attributeChanges, propertyChanges);
                return new DeltaArchive(pack, parentDelta, postChange);
            }
        }
        return null;
    }

    protected static XbFileSet createFileset(ArchiveFileSetImpl postChange, HashMap attributeChanges, HashMap propertyChanges) {
        XbFileSet fs = new XbFileSet((XbFileSet)postChange.nodeDelegate);
        if (attributeChanges.containsKey("org.jboss.ide.eclipse.archives.core.model.IPackageFileSet.includes")) {
            fs.setIncludes(ArchiveDeltaPreNodeFactory.getBeforeString(attributeChanges, "org.jboss.ide.eclipse.archives.core.model.IPackageFileSet.includes"));
        }
        if (attributeChanges.containsKey("org.jboss.ide.eclipse.archives.core.model.IPackageFileSet.excludes")) {
            fs.setExcludes(ArchiveDeltaPreNodeFactory.getBeforeString(attributeChanges, "org.jboss.ide.eclipse.archives.core.model.IPackageFileSet.excludes"));
        }
        if (attributeChanges.containsKey("org.jboss.ide.eclipse.archives.core.model.IPackageFileSet.sourcePath")) {
            fs.setDir(ArchiveDeltaPreNodeFactory.getBeforeString(attributeChanges, "org.jboss.ide.eclipse.archives.core.model.IPackageFileSet.sourcePath"));
        }
        if (attributeChanges.containsKey("org.jboss.ide.eclipse.archives.core.model.IPackageFileSet.inWorkspace")) {
            fs.setInWorkspace(ArchiveDeltaPreNodeFactory.getBeforeBoolean(attributeChanges, "org.jboss.ide.eclipse.archives.core.model.IPackageFileSet.inWorkspace"));
        }
        if (attributeChanges.containsKey("org.jboss.ide.eclipse.archives.core.model.IPackageFileSet.flattened")) {
            fs.setFlattened(ArchiveDeltaPreNodeFactory.getBeforeBoolean(attributeChanges, "org.jboss.ide.eclipse.archives.core.model.IPackageFileSet.flattened"));
        }
        ArchiveDeltaPreNodeFactory.undoPropertyChanges(fs, propertyChanges);
        return fs;
    }

    protected static XbFolder createFolder(ArchiveFolderImpl postChange, HashMap attributeChanges, HashMap propertyChanges) {
        XbFolder folder = new XbFolder((XbFolder)postChange.nodeDelegate);
        if (attributeChanges.containsKey("org.jboss.ide.eclipse.archives.core.model.INamedContainerArchiveNodename")) {
            folder.setName(ArchiveDeltaPreNodeFactory.getBeforeString(attributeChanges, "org.jboss.ide.eclipse.archives.core.model.INamedContainerArchiveNodename"));
        }
        ArchiveDeltaPreNodeFactory.undoPropertyChanges(folder, propertyChanges);
        return folder;
    }

    protected static XbPackage createPackage(ArchiveImpl postChange, HashMap attributeChanges, HashMap propertyChanges) {
        XbPackage pack = new XbPackage((XbPackage)postChange.nodeDelegate);
        if (attributeChanges.containsKey("org.jboss.ide.eclipse.archives.core.model.INamedContainerArchiveNodename")) {
            pack.setName(ArchiveDeltaPreNodeFactory.getBeforeString(attributeChanges, "org.jboss.ide.eclipse.archives.core.model.INamedContainerArchiveNodename"));
        }
        if (attributeChanges.containsKey("org.jboss.ide.eclipse.archives.core.model.IPackage.packageType")) {
            pack.setPackageType(ArchiveDeltaPreNodeFactory.getBeforeString(attributeChanges, "org.jboss.ide.eclipse.archives.core.model.IPackage.packageType"));
        }
        if (attributeChanges.containsKey("org.jboss.ide.eclipse.archives.core.model.IPackage.destination")) {
            pack.setToDir(ArchiveDeltaPreNodeFactory.getBeforeString(attributeChanges, "org.jboss.ide.eclipse.archives.core.model.IPackage.destination"));
        }
        if (attributeChanges.containsKey("org.jboss.ide.eclipse.archives.core.model.IPackage.inWorkspace")) {
            pack.setInWorkspace(ArchiveDeltaPreNodeFactory.getBeforeBoolean(attributeChanges, "org.jboss.ide.eclipse.archives.core.model.IPackage.inWorkspace"));
        }
        if (attributeChanges.containsKey("org.jboss.ide.eclipse.archives.core.model.IPackage.exploded")) {
            pack.setExploded(ArchiveDeltaPreNodeFactory.getBeforeBoolean(attributeChanges, "org.jboss.ide.eclipse.archives.core.model.IPackage.exploded"));
        }
        ArchiveDeltaPreNodeFactory.undoPropertyChanges(pack, propertyChanges);
        return pack;
    }

    public static boolean getBeforeBoolean(HashMap map, String key) {
        ArchiveNodeDeltaImpl.NodeDelta delta = (ArchiveNodeDeltaImpl.NodeDelta)map.get(key);
        if (delta != null) {
            return (Boolean)delta.getBefore();
        }
        return true;
    }

    public static String getBeforeString(HashMap map, String key) {
        ArchiveNodeDeltaImpl.NodeDelta delta = (ArchiveNodeDeltaImpl.NodeDelta)map.get(key);
        if (delta != null) {
            return (String)delta.getBefore();
        }
        return null;
    }

    public static void undoPropertyChanges(XbPackageNodeWithProperties node, HashMap changes) {
        for (String key : changes.keySet()) {
            ArchiveNodeDeltaImpl.NodeDelta val = (ArchiveNodeDeltaImpl.NodeDelta)changes.get(key);
            if (val.getBefore() == null) {
                node.getProperties().getProperties().remove(key);
                continue;
            }
            node.getProperties().getProperties().setProperty(key, (String)val.getBefore());
        }
    }

    public static class DeltaArchive
    extends ArchiveImpl {
        private IArchiveNodeDelta parentDelta;
        private IArchiveNode impl;

        public DeltaArchive(XbPackage pack, IArchiveNodeDelta parentDelta, IArchiveNode impl) {
            super(pack);
            this.parentDelta = parentDelta;
            this.impl = impl;
        }

        public IArchiveNode getParent() {
            return this.parentDelta == null ? null : this.parentDelta.getPreNode();
        }

        public IPath getProjectPath() {
            return this.impl.getProjectPath();
        }

        public IArchiveModelRootNode getModelRootNode() {
            return this.impl.getModelRootNode();
        }
    }

    public static class DeltaFileset
    extends ArchiveFileSetImpl {
        private IArchiveNodeDelta parentDelta;
        private IArchiveNode impl;

        public DeltaFileset(XbFileSet fileset, IArchiveNodeDelta parentDelta, IArchiveNode impl) {
            super(fileset);
            this.parentDelta = parentDelta;
            this.impl = impl;
        }

        public IArchiveNode getParent() {
            return this.parentDelta == null ? null : this.parentDelta.getPreNode();
        }

        public IPath getProjectPath() {
            return this.impl.getProjectPath();
        }

        public IArchiveModelRootNode getModelRootNode() {
            return this.impl.getModelRootNode();
        }
    }

    public static class DeltaFolder
    extends ArchiveFolderImpl {
        private IArchiveNodeDelta parentDelta;
        private IArchiveNode impl;

        public DeltaFolder(XbFolder folder, IArchiveNodeDelta parentDelta, IArchiveNode impl) {
            super(folder);
            this.parentDelta = parentDelta;
            this.impl = impl;
        }

        public IArchiveNode getParent() {
            return this.parentDelta == null ? null : this.parentDelta.getPreNode();
        }

        public IPath getProjectPath() {
            return this.impl.getProjectPath();
        }

        public IArchiveModelRootNode getModelRootNode() {
            return this.impl.getModelRootNode();
        }
    }
}

