/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ide.eclipse.as.core;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.wst.server.core.IServer;
import org.eclipse.wst.server.core.IServerType;
import org.jboss.ide.eclipse.as.core.JBossServerCorePlugin;
import org.jboss.ide.eclipse.as.core.server.IProvideCredentials;
import org.jboss.ide.eclipse.as.core.server.IServerProvider;
import org.jboss.ide.eclipse.as.core.server.IServerStatePollerType;
import org.jboss.ide.eclipse.as.core.server.internal.ServerStatePollerType;
import org.jboss.tools.jmx.core.IJMXRunnable;

public class ExtensionManager {
    private static ExtensionManager instance;
    private HashMap<String, ServerStatePollerType> pollers;
    private HashMap<String, IProvideCredentials> credentialProviders;
    private IServerJMXRunner jmxRunner = null;
    private Object JMX_RUNNER_NOT_FOUND = null;

    public static ExtensionManager getDefault() {
        if (instance == null) {
            instance = new ExtensionManager();
        }
        return instance;
    }

    public void loadPollers() {
        this.pollers = new HashMap();
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        IConfigurationElement[] cf = registry.getConfigurationElementsFor("org.jboss.ide.eclipse.as.core", "pollers");
        int i = 0;
        while (i < cf.length) {
            String id = cf[i].getAttribute("id");
            ServerStatePollerType sspt = new ServerStatePollerType(cf[i]);
            if (this.pollers.get(id) != null) {
                Status s = new Status(4, "org.jboss.ide.eclipse.as.core", "Two pollers with conflicting id's have been declared and will clobber each other. The existing poller will be kept.\n " + this.pollers.get(id).toString() + "\n" + sspt.toString());
                JBossServerCorePlugin.getDefault().getLog().log((IStatus)s);
            } else {
                this.pollers.put(id, sspt);
            }
            ++i;
        }
    }

    public IServerStatePollerType getPollerType(String id) {
        if (this.pollers == null) {
            this.loadPollers();
        }
        return this.pollers.get(id);
    }

    public IServerStatePollerType[] getStartupPollers(IServerType serverType, String mode) {
        if (this.pollers == null) {
            this.loadPollers();
        }
        ArrayList<ServerStatePollerType> list = new ArrayList<ServerStatePollerType>();
        for (ServerStatePollerType type : this.pollers.values()) {
            if (!type.supportsStartup() || !this.pollerSupportsServerType(type, serverType) || mode != null && !this.pollerSupportsServerMode(type, mode)) continue;
            list.add(type);
        }
        return list.toArray(new ServerStatePollerType[list.size()]);
    }

    public IServerStatePollerType[] getStartupPollers(IServerType serverType) {
        return this.getShutdownPollers(serverType, null);
    }

    public IServerStatePollerType[] getShutdownPollers(IServerType serverType, String mode) {
        if (this.pollers == null) {
            this.loadPollers();
        }
        ArrayList<ServerStatePollerType> list = new ArrayList<ServerStatePollerType>();
        for (ServerStatePollerType type : this.pollers.values()) {
            if (!type.supportsShutdown() || !this.pollerSupportsServerType(type, serverType) || mode != null && !this.pollerSupportsServerMode(type, mode)) continue;
            list.add(type);
        }
        return list.toArray(new ServerStatePollerType[list.size()]);
    }

    public IServerStatePollerType[] getShutdownPollers(IServerType serverType) {
        return this.getShutdownPollers(serverType, null);
    }

    protected boolean pollerSupportsServerType(IServerStatePollerType type, IServerType serverType) {
        return this.commaSeparatedContains(type.getServerTypes(), serverType.getId());
    }

    protected boolean pollerSupportsServerMode(IServerStatePollerType type, String mode) {
        return this.commaSeparatedContains(type.getServerModes(), mode);
    }

    private boolean commaSeparatedContains(String cs, String val) {
        if (cs == null || cs.equals("")) {
            return true;
        }
        String[] arr = cs.split(",");
        int i = 0;
        while (i < arr.length) {
            if (arr[i].trim().equals(val)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public void loadCredentialProviders() {
        this.credentialProviders = new HashMap();
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        IConfigurationElement[] cf = registry.getConfigurationElementsFor("org.jboss.ide.eclipse.as.core", "pollerFailureHandler");
        int i = 0;
        while (i < cf.length) {
            try {
                this.credentialProviders.put(cf[i].getAttribute("id"), (IProvideCredentials)cf[i].createExecutableExtension("class"));
            }
            catch (CoreException e) {
                JBossServerCorePlugin.log(e.getStatus());
            }
            ++i;
        }
    }

    public IProvideCredentials[] getCredentialProviders() {
        if (this.credentialProviders == null) {
            this.loadCredentialProviders();
        }
        Collection<IProvideCredentials> c = this.credentialProviders.values();
        return c.toArray(new IProvideCredentials[c.size()]);
    }

    public IProvideCredentials getFirstCredentialProvider(IServerProvider serverProvider, List<String> requiredProperties) {
        IProvideCredentials[] handlers = this.getCredentialProviders();
        int i = 0;
        while (i < handlers.length) {
            if (handlers[i].accepts(serverProvider, requiredProperties)) {
                return handlers[i];
            }
            ++i;
        }
        return null;
    }

    public IServerJMXRunner getJMXRunner() {
        if (this.jmxRunner != null) {
            return this.jmxRunner;
        }
        if (this.JMX_RUNNER_NOT_FOUND != null) {
            return null;
        }
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        IConfigurationElement[] cf = registry.getConfigurationElementsFor("org.jboss.ide.eclipse.as.core", "jmxRunner");
        int i = 0;
        while (i < cf.length) {
            try {
                Object o = cf[i].createExecutableExtension("class");
                if (o != null && o instanceof IServerJMXRunner) {
                    return (IServerJMXRunner)o;
                }
            }
            catch (CoreException e) {
                JBossServerCorePlugin.log(e.getStatus());
            }
            ++i;
        }
        this.JMX_RUNNER_NOT_FOUND = new Object();
        return null;
    }

    @Deprecated
    public static interface IServerJMXRunnable
    extends IJMXRunnable {
    }

    public static interface IServerJMXRunner {
        public void run(IServer var1, IJMXRunnable var2) throws CoreException;

        public void beginTransaction(IServer var1, Object var2);

        public void endTransaction(IServer var1, Object var2);
    }
}

