/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ide.eclipse.as.core.server.internal;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.wst.server.core.IModule;
import org.eclipse.wst.server.core.IServer;
import org.eclipse.wst.server.core.internal.Server;
import org.jboss.ide.eclipse.as.core.server.IServerModuleStateVerifier;
import org.jboss.ide.eclipse.as.core.server.internal.extendedproperties.JBossExtendedProperties;
import org.jboss.ide.eclipse.as.wtp.core.server.behavior.IModuleStateController;

public class UpdateModuleStateJob
extends Job {
    private IServer server;
    private IServerModuleStateVerifier verifier;
    private IModuleStateController controller;
    private boolean wait;
    private int maxWait;

    public UpdateModuleStateJob(IServer server) {
        this(server, null, false, 0);
    }

    public UpdateModuleStateJob(IServer server, IServerModuleStateVerifier verifier) {
        this(server, verifier, false, 0);
    }

    public UpdateModuleStateJob(IServer server, IServerModuleStateVerifier verifier, boolean wait, int maxWait) {
        super("Checking module status for server " + server.getName());
        this.setSystem(true);
        this.wait = wait;
        this.maxWait = maxWait;
        this.server = server;
        if (verifier == null) {
            JBossExtendedProperties properties = (JBossExtendedProperties)server.loadAdapter(JBossExtendedProperties.class, null);
            this.verifier = properties.getModuleStateVerifier();
        } else {
            this.verifier = verifier;
        }
    }

    public UpdateModuleStateJob(IModuleStateController controller, IServer server) {
        this(controller, server, false, 0);
    }

    public UpdateModuleStateJob(IModuleStateController controller, IServer server, boolean wait, int maxWait) {
        super("Check module status for server " + server.getName());
        this.wait = wait;
        this.maxWait = maxWait;
        this.server = server;
        this.controller = controller;
    }

    protected IStatus run(IProgressMonitor monitor) {
        if (this.verifier == null && this.controller == null) {
            return Status.CANCEL_STATUS;
        }
        if (this.server.getServerState() != 2) {
            return Status.OK_STATUS;
        }
        if (!this.wait) {
            return this.runQuick(monitor);
        }
        return this.runWait(monitor);
    }

    private IStatus runWait(IProgressMonitor monitor) {
        boolean allStarted = false;
        long startTime = System.currentTimeMillis();
        long endTime = startTime + (long)this.maxWait;
        IModule[] modules = this.server.getModules();
        monitor.beginTask("Checking module states for " + this.server.getName(), this.maxWait * 1000);
        while (!allStarted && System.currentTimeMillis() < endTime) {
            allStarted = true;
            long thisLoopStart = System.currentTimeMillis();
            int i22 = 0;
            while (i22 < modules.length) {
                IModule[] temp = new IModule[]{modules[i22]};
                int state = this.getModuleState(temp, (IProgressMonitor)new SubProgressMonitor(monitor, 1000));
                boolean started = state == 2;
                allStarted = allStarted && started;
                ((Server)this.server).setModuleState(temp, state);
                ++i22;
            }
            try {
                Thread.sleep(500L);
            }
            catch (InterruptedException i22) {
                // empty catch block
            }
            long timeDif = System.currentTimeMillis() - thisLoopStart;
            monitor.worked((int)timeDif - modules.length * 100);
        }
        return Status.OK_STATUS;
    }

    private IStatus runQuick(IProgressMonitor monitor) {
        IModule[] modules = this.server.getModules();
        monitor.beginTask("Verifying Module State", modules.length * 1000);
        int i = 0;
        while (i < modules.length) {
            IModule[] temp = new IModule[]{modules[i]};
            int state = this.getModuleState(temp, (IProgressMonitor)new SubProgressMonitor(monitor, 1000));
            ((Server)this.server).setModuleState(temp, state);
            ++i;
        }
        return Status.OK_STATUS;
    }

    private int getModuleState(IModule[] temp, IProgressMonitor monitor) {
        if (this.verifier != null) {
            return this.verifier.getModuleState(this.server, temp, (IProgressMonitor)new SubProgressMonitor(monitor, 1000));
        }
        if (this.controller != null) {
            return this.controller.getModuleState(temp, (IProgressMonitor)new SubProgressMonitor(monitor, 1000));
        }
        return 0;
    }
}

