/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ide.eclipse.as.core.server.internal.v7;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.jboss.ide.eclipse.as.core.server.IJBossServerRuntime;
import org.jboss.ide.eclipse.as.core.server.bean.JBossServerType;
import org.jboss.ide.eclipse.as.core.server.bean.ServerBeanLoader;
import org.jboss.ide.eclipse.as.core.server.internal.launch.configuration.JBossLaunchConfigProperties;
import org.jboss.ide.eclipse.as.core.util.ArgsUtil;

public class JBoss7LaunchConfigProperties
extends JBossLaunchConfigProperties {
    public void setModulesFolder(String mp, ILaunchConfigurationWorkingCopy launchConfig) throws CoreException {
        String progArgs;
        if (this.isSet(mp) && !(progArgs = this.getProgramArguments((ILaunchConfiguration)launchConfig)).contains(mp)) {
            progArgs = ArgsUtil.setArg((String)progArgs, (String)"-mp", null, (String)("\"" + mp + "\""));
            this.setProgramArguments(progArgs, launchConfig);
        }
    }

    public void setConfigurationFile(String file, ILaunchConfigurationWorkingCopy launchConfig) throws CoreException {
        if (this.isSet(file)) {
            String progArgs = this.getProgramArguments((ILaunchConfiguration)launchConfig);
            progArgs = ArgsUtil.setArg((String)progArgs, null, (String)"--server-config", (String)file);
            this.setProgramArguments(progArgs, launchConfig);
        }
    }

    public void setBaseDirectory(String file, ILaunchConfigurationWorkingCopy launchConfig) throws CoreException {
        if (this.isSet(file)) {
            String progArgs = this.getProgramArguments((ILaunchConfiguration)launchConfig);
            progArgs = ArgsUtil.setArg((String)progArgs, null, (String)"-Djboss.server.base.dir", (String)file);
            this.setProgramArguments(progArgs, launchConfig);
        }
    }

    public void setBootLogFile(String blf, ILaunchConfigurationWorkingCopy launchConfig) throws CoreException {
        if (this.isSet(blf)) {
            String vmArgs = this.getVMArguments((ILaunchConfiguration)launchConfig);
            vmArgs = ArgsUtil.setArg((String)vmArgs, null, (String)"-Dorg.jboss.boot.log.file", (String)blf);
            this.setVmArguments(vmArgs, launchConfig);
        }
    }

    public void setPreferIP4(boolean flag, ILaunchConfigurationWorkingCopy launchConfig) throws CoreException {
        String vmArgs = this.getVMArguments((ILaunchConfiguration)launchConfig);
        vmArgs = ArgsUtil.setArg((String)vmArgs, null, (String)"-Djava.net.preferIPv4Stack", (String)new Boolean(flag).toString());
        this.setVmArguments(vmArgs, launchConfig);
    }

    public void setLoggingConfigFile(String lcf, ILaunchConfigurationWorkingCopy launchConfig) throws CoreException {
        if (this.isSet(lcf)) {
            String vmArgs = this.getVMArguments((ILaunchConfiguration)launchConfig);
            vmArgs = ArgsUtil.setArg((String)vmArgs, null, (String)"-Dlogging.configuration", (String)lcf);
            this.setVmArguments(vmArgs, launchConfig);
        }
    }

    @Override
    public void setServerHome(String serverHome, IJBossServerRuntime runtime, ILaunchConfigurationWorkingCopy launchConfig) throws CoreException {
        if (this.isSet(serverHome)) {
            String vmArguments = this.getVMArguments((ILaunchConfiguration)launchConfig);
            String arguments = ArgsUtil.setArg((String)vmArguments, null, (String)"-Djboss.home.dir", (String)serverHome);
            this.setVmArguments(arguments, launchConfig);
        }
    }

    private boolean supportsBindingFlag(ILaunchConfigurationWorkingCopy launchConfig) throws CoreException {
        String v;
        ServerBeanLoader loader = this.getBeanLoader(launchConfig);
        return !loader.getServerBean().getType().equals(JBossServerType.AS7) || "7.0.2".compareTo(v = loader.getFullServerVersion()) < 0;
    }

    @Override
    public void setHost(String host, ILaunchConfigurationWorkingCopy launchConfig) throws CoreException {
        String currentHost;
        if (!this.supportsBindingFlag(launchConfig)) {
            return;
        }
        if (this.isSet(host) && ((currentHost = this.getHost((ILaunchConfiguration)launchConfig)) == null || !host.equals(currentHost))) {
            String programArguments = this.getProgramArguments((ILaunchConfiguration)launchConfig);
            programArguments = ArgsUtil.setArg((String)programArguments, (String)"-b", null, (String)host);
            this.setProgramArguments(programArguments, launchConfig);
        }
    }

    public void setExposedManagement(String host, ILaunchConfigurationWorkingCopy launchConfig) throws CoreException {
        if (this.isSet(host)) {
            String vmArguments = this.getVMArguments((ILaunchConfiguration)launchConfig);
            String arguments = ArgsUtil.setArg((String)vmArguments, null, (String)"-Djboss.bind.address.management", (String)host);
            this.setVmArguments(arguments, launchConfig);
        }
    }
}

