/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ide.eclipse.as.rse.ui;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.commands.operations.IUndoableOperation;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.fieldassist.ControlDecoration;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.osgi.util.NLS;
import org.eclipse.rse.core.model.IHost;
import org.eclipse.rse.services.clientserver.messages.SystemMessageException;
import org.eclipse.rse.services.files.IFileService;
import org.eclipse.rse.services.files.IHostFile;
import org.eclipse.rse.subsystems.files.core.servicesubsystem.IFileServiceSubSystem;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.progress.IProgressService;
import org.jboss.ide.eclipse.as.rse.core.RSEFrameworkUtils;
import org.jboss.ide.eclipse.as.rse.ui.RSEDeploymentPreferenceComposite;
import org.jboss.ide.eclipse.as.rse.ui.RSEUIMessages;
import org.jboss.ide.eclipse.as.ui.UIUtil;
import org.jboss.ide.eclipse.as.ui.editor.IDeploymentTypeUI;
import org.jboss.ide.eclipse.as.ui.editor.ServerModeSectionComposite;

public class JBossRSEDeploymentPrefComposite
extends RSEDeploymentPreferenceComposite {
    private Text rseServerHome;
    private Text rseServerConfig;
    private Button rseBrowse;
    private Button rseTest;
    private ControlDecoration serverHomeDecoration;
    private ControlDecoration serverConfigDecoration;

    public JBossRSEDeploymentPrefComposite(Composite parent, int style, IDeploymentTypeUI.IServerModeUICallback callback) {
        super(parent, style, callback);
        String error = this.validateWidgets(false);
        callback.setComplete(error == null);
    }

    @Override
    protected void createRSEWidgets(Composite child) {
        this.handleJBossServer(child);
    }

    private void handleJBossServer(Composite composite) {
        Label serverHomeLabel = new Label((Composite)this, 0);
        serverHomeLabel.setText("Remote Server Home: ");
        this.rseBrowse = new Button((Composite)this, 0);
        this.rseBrowse.setText("Browse...");
        this.rseBrowse.setLayoutData((Object)UIUtil.createFormData2((Object)composite, (int)5, null, (int)0, null, (int)0, (Object)100, (int)-5));
        this.rseBrowse.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                JBossRSEDeploymentPrefComposite.this.browseClicked2();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                JBossRSEDeploymentPrefComposite.this.browseClicked2();
            }
        });
        this.rseServerHome = new Text((Composite)this, 2052);
        serverHomeLabel.setLayoutData((Object)UIUtil.createFormData2((Object)composite, (int)7, null, (int)0, (Object)0, (int)10, null, (int)0));
        this.rseServerHome.setLayoutData((Object)UIUtil.createFormData2((Object)composite, (int)5, null, (int)0, (Object)serverHomeLabel, (int)10, (Object)this.rseBrowse, (int)-5));
        this.rseServerHome.setText(this.callback.getServer().getAttribute("org.jboss.ide.eclipse.as.rse.core.RSEServerHomeDir", ""));
        this.serverHomeDecoration = new ControlDecoration((Control)this.rseServerHome, 0x1000000);
        this.rseServerHome.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                JBossRSEDeploymentPrefComposite.this.serverHomeChanged();
            }
        });
        Label serverConfigLabel = new Label((Composite)this, 0);
        serverConfigLabel.setText(RSEUIMessages.REMOTE_SERVER_CONFIG);
        this.rseServerConfig = new Text((Composite)this, 2052);
        serverConfigLabel.setLayoutData((Object)UIUtil.createFormData2((Object)this.rseServerHome, (int)7, null, (int)0, (Object)0, (int)10, null, (int)0));
        String defaultConfig = this.getRuntime() == null ? "default" : this.getRuntime().getJBossConfiguration();
        this.rseServerConfig.setText(this.callback.getServer().getAttribute("org.jboss.ide.eclipse.as.rse.core.RSEServerConfig", defaultConfig));
        this.rseServerConfig.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                JBossRSEDeploymentPrefComposite.this.serverConfigChanged();
            }
        });
        this.serverConfigDecoration = new ControlDecoration((Control)this.rseServerConfig, 0x1000000);
        this.callback.getServer().addPropertyChangeListener((PropertyChangeListener)this);
        this.rseTest = new Button((Composite)this, 0);
        this.rseTest.setText(RSEUIMessages.TEST);
        this.rseTest.setLayoutData((Object)UIUtil.createFormData2((Object)this.rseServerHome, (int)5, null, (int)0, null, (int)0, (Object)100, (int)-5));
        this.rseServerConfig.setLayoutData((Object)UIUtil.createFormData2((Object)this.rseServerHome, (int)5, null, (int)0, (Object)serverConfigLabel, (int)5, (Object)this.rseTest, (int)-5));
        this.rseTest.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                JBossRSEDeploymentPrefComposite.this.testPressed();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
    }

    private void testPressed() {
        this.rseTest.setEnabled(false);
        IWorkbench wb = PlatformUI.getWorkbench();
        IProgressService ps = wb.getProgressService();
        final IStatus[] s = new IStatus[1];
        Exception e = null;
        final String home = this.rseServerHome.getText();
        final String config = this.rseServerConfig.getText();
        try {
            ps.busyCursorWhile(new IRunnableWithProgress(){

                public void run(IProgressMonitor pm) {
                    s[0] = JBossRSEDeploymentPrefComposite.this.testPressed(home, config, pm);
                }
            });
        }
        catch (InvocationTargetException ite) {
            e = ite;
        }
        catch (InterruptedException ie) {
            e = ie;
        }
        if (s[0] == null && e != null) {
            s[0] = new Status(4, "org.jboss.ide.eclipse.as.rse.core", e.getMessage(), (Throwable)e);
        }
        this.rseTest.setEnabled(true);
        IStatus s2 = s[0];
        if (s2.isOK()) {
            s2 = new Status(1, "org.jboss.ide.eclipse.as.rse.core", RSEUIMessages.REMOTE_SERVER_TEST_SUCCESS);
        }
        this.showMessageDialog(RSEUIMessages.REMOTE_SERVER_TEST, s2, this.rseServerHome.getShell());
    }

    private IStatus testPressed(String home, String config, IProgressMonitor pm) {
        pm.beginTask(RSEUIMessages.VALIDATING_REMOTE_CONFIG, 1200);
        IHost host = this.combo.getHost();
        if (host == null) {
            pm.done();
            return this.getTestFailStatus(RSEUIMessages.EMPTY_HOST);
        }
        pm.worked(100);
        IFileServiceSubSystem fileSubSystem = RSEFrameworkUtils.findFileTransferSubSystem((IHost)host);
        if (fileSubSystem == null) {
            pm.done();
            return this.getTestFailStatus(NLS.bind((String)RSEUIMessages.FILE_SUBSYSTEM_NOT_FOUND, (Object)host.getName()));
        }
        pm.worked(100);
        if (!fileSubSystem.isConnected()) {
            try {
                fileSubSystem.connect((IProgressMonitor)new NullProgressMonitor(), false);
            }
            catch (Exception e) {
                pm.done();
                return this.getTestFailStatus(NLS.bind((String)RSEUIMessages.REMOTE_FILESYSTEM_CONNECT_FAILED, (Object)e.getLocalizedMessage()));
            }
        }
        pm.worked(300);
        IFileService service = fileSubSystem.getFileService();
        if (service == null) {
            pm.done();
            return this.getTestFailStatus(NLS.bind((String)RSEUIMessages.FILESERVICE_NOT_FOUND, (Object)host.getName()));
        }
        pm.worked(100);
        String root = home;
        Path root2 = new Path(root);
        try {
            IHostFile file = service.getFile(root2.removeLastSegments(1).toPortableString(), root2.lastSegment(), (IProgressMonitor)new NullProgressMonitor());
            if (file == null || !file.exists()) {
                pm.done();
                return this.getTestFailStatus(NLS.bind((String)RSEUIMessages.REMOTE_HOME_NOT_FOUND, (Object[])new Object[]{root2, service.getName(), host.getName()}));
            }
            pm.worked(300);
            if (config == null || config.trim().length() == 0) {
                return this.getTestFailStatus(RSEUIMessages.REMOTE_CONFIG_BLANK);
            }
            file = service.getFile((root2 = root2.append("server").append(config)).removeLastSegments(1).toPortableString(), root2.lastSegment(), (IProgressMonitor)new NullProgressMonitor());
            if (file == null || !file.exists()) {
                pm.done();
                return this.getTestFailStatus(NLS.bind((String)RSEUIMessages.REMOTE_CONFIG_NOT_FOUND, (Object)root2));
            }
            pm.worked(300);
        }
        catch (SystemMessageException sme) {
            pm.done();
            return this.getTestFailStatus(String.valueOf(RSEUIMessages.ERROR_CHECKING_REMOTE_SYSTEM) + sme.getLocalizedMessage());
        }
        pm.done();
        return Status.OK_STATUS;
    }

    private IStatus getTestFailStatus(String string) {
        return new Status(4, "org.jboss.ide.eclipse.as.rse.core", string);
    }

    protected void browseClicked2() {
        String browseVal = this.browseClicked3(this.rseServerHome.getShell());
        if (browseVal != null) {
            this.rseServerHome.setText(browseVal);
            this.serverHomeChanged();
        }
    }

    @Override
    protected void propertyChangeBody(PropertyChangeEvent evt) {
        super.propertyChangeBody(evt);
        if (evt.getPropertyName().equals("org.jboss.ide.eclipse.as.rse.core.RSEServerHomeDir")) {
            this.updateTextIfChanges(this.rseServerHome, evt.getNewValue().toString());
        } else if (evt.getPropertyName().equals("org.jboss.ide.eclipse.as.rse.core.RSEServerConfig")) {
            this.updateTextIfChanges(this.rseServerConfig, evt.getNewValue().toString());
        }
    }

    protected void serverConfigChanged() {
        if (!this.isUpdatingFromModelChange()) {
            this.callback.execute((IUndoableOperation)new ServerModeSectionComposite.ChangeServerPropertyCommand(this.callback.getServer(), "org.jboss.ide.eclipse.as.rse.core.RSEServerConfig", this.rseServerConfig.getText(), this.getRuntime() == null ? "" : this.getRuntime().getJBossConfiguration(), RSEUIMessages.CHANGE_REMOTE_SERVER_CONFIG));
        }
        this.validateWidgets(true);
    }

    protected void serverHomeChanged() {
        if (!this.isUpdatingFromModelChange()) {
            String safeString = this.callback.getRuntime() != null ? (this.callback.getRuntime().getLocation() != null ? this.callback.getRuntime().getLocation().toString() : "") : "";
            this.callback.execute((IUndoableOperation)new ServerModeSectionComposite.ChangeServerPropertyCommand(this.callback.getServer(), "org.jboss.ide.eclipse.as.rse.core.RSEServerHomeDir", this.rseServerHome.getText(), safeString, RSEUIMessages.CHANGE_REMOTE_SERVER_HOME));
        }
        this.validateWidgets(true);
    }

    protected String validateWidgets(boolean updateErrorMessage) {
        Image image;
        boolean isEmpty;
        String errorMsg = null;
        if (this.serverHomeDecoration != null) {
            boolean bl = isEmpty = this.rseServerHome == null || this.rseServerHome.getText() == null || this.rseServerHome.getText().trim().isEmpty();
            if (isEmpty) {
                this.serverHomeDecoration.setDescriptionText("Remote server home cannot be empty.");
                image = PlatformUI.getWorkbench().getSharedImages().getImage("IMG_DEC_FIELD_ERROR");
                this.serverHomeDecoration.setImage(image);
                this.serverHomeDecoration.show();
                errorMsg = this.serverHomeDecoration.getDescriptionText();
            } else {
                this.serverHomeDecoration.hide();
            }
        }
        if (this.serverConfigDecoration != null) {
            boolean bl = isEmpty = this.rseServerConfig == null || this.rseServerConfig.getText() == null || this.rseServerConfig.getText().trim().isEmpty();
            if (isEmpty) {
                this.serverConfigDecoration.setDescriptionText(RSEUIMessages.REMOTE_CONFIG_BLANK);
                image = PlatformUI.getWorkbench().getSharedImages().getImage("IMG_DEC_FIELD_ERROR");
                this.serverConfigDecoration.setImage(image);
                this.serverConfigDecoration.show();
                if (errorMsg == null) {
                    errorMsg = this.serverConfigDecoration.getDescriptionText();
                }
            } else {
                this.serverConfigDecoration.hide();
            }
        }
        if (updateErrorMessage) {
            this.callback.setErrorMessage(errorMsg);
        }
        this.callback.setComplete(errorMsg == null);
        return errorMsg;
    }
}

