/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.archives.reddeer.component;

import org.jboss.reddeer.common.condition.WaitCondition;
import org.jboss.reddeer.common.exception.RedDeerException;
import org.jboss.reddeer.common.wait.WaitWhile;
import org.jboss.reddeer.core.condition.JobIsRunning;
import org.jboss.reddeer.swt.api.Shell;
import org.jboss.reddeer.swt.api.TreeItem;
import org.jboss.reddeer.swt.condition.ShellIsAvailable;
import org.jboss.reddeer.swt.impl.button.PushButton;
import org.jboss.reddeer.swt.impl.menu.ContextMenu;
import org.jboss.reddeer.swt.impl.shell.DefaultShell;
import org.jboss.tools.archives.reddeer.archives.jdt.integration.LibFilesetDialog;
import org.jboss.tools.archives.reddeer.archives.ui.FilesetDialog;
import org.jboss.tools.archives.reddeer.archives.ui.NewFolderDialog;
import org.jboss.tools.archives.reddeer.archives.ui.NewJarDialog;
import org.jboss.tools.archives.reddeer.component.Fileset;
import org.jboss.tools.archives.reddeer.component.UserLibraryFileset;

public class Folder {
    private TreeItem folder;

    public String getName() {
        return this.folder.getText();
    }

    public Folder(TreeItem folder) {
        this.folder = folder;
    }

    public NewJarDialog newJarArchive() {
        this.folder.select();
        new ContextMenu(new String[]{"New Archive", "JAR"}).select();
        return new NewJarDialog();
    }

    public NewFolderDialog newFolder() {
        this.folder.select();
        new ContextMenu(new String[]{"New Folder"}).select();
        return new NewFolderDialog();
    }

    public FilesetDialog newFileset() {
        this.folder.select();
        new ContextMenu(new String[]{"New Fileset"}).select();
        return new FilesetDialog();
    }

    public LibFilesetDialog newUserLibraryFileset() {
        this.folder.select();
        new ContextMenu(new String[]{"New User Library Fileset"}).select();
        return new LibFilesetDialog();
    }

    public NewFolderDialog editFolder() {
        this.folder.select();
        new ContextMenu(new String[]{"Edit Folder"}).select();
        return new NewFolderDialog();
    }

    public void deleteFolder(boolean withContextMenu) {
        this.folder.select();
        new ContextMenu(new String[]{"Delete Folder"}).select();
        try {
            DefaultShell s = new DefaultShell("Delete selected nodes?");
            new PushButton("Yes").click();
            new WaitWhile((WaitCondition)new ShellIsAvailable((Shell)s));
        }
        catch (RedDeerException redDeerException) {}
        new WaitWhile((WaitCondition)new JobIsRunning());
    }

    public Folder getFolder(String folderName) {
        return new Folder(this.folder.getItem(folderName));
    }

    public Fileset getFileset(String filesetName) {
        return new Fileset(this.folder.getItem(filesetName));
    }

    public UserLibraryFileset getUserLibraryFileset(String userLibraryFilesetName) {
        return new UserLibraryFileset(this.folder.getItem(userLibraryFilesetName));
    }
}

