/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ide.eclipse.as.classpath.core.runtime;

import java.util.HashMap;
import org.eclipse.core.runtime.IPath;
import org.eclipse.wst.server.core.IRuntimeType;
import org.jboss.ide.eclipse.as.classpath.core.ClasspathCorePlugin;
import org.jboss.ide.eclipse.as.classpath.core.runtime.IRuntimePathProvider;
import org.jboss.ide.eclipse.as.classpath.core.runtime.cache.internal.InternalRuntimeClasspathModel;
import org.jboss.ide.eclipse.as.classpath.core.runtime.cache.internal.RuntimeClasspathModelIO;
import org.jboss.ide.eclipse.as.classpath.core.runtime.internal.DefaultClasspathModelLoader;
import org.jboss.ide.eclipse.as.core.JBossServerCorePlugin;

public class CustomRuntimeClasspathModel {
    protected static final IPath DEFAULT_CLASSPATH_FS_ROOT = JBossServerCorePlugin.getGlobalSettingsLocation().append("filesets").append("runtimeClasspaths");
    private static CustomRuntimeClasspathModel instance;
    private HashMap<String, InternalRuntimeClasspathModel> modelMap = new HashMap();

    public static CustomRuntimeClasspathModel getInstance() {
        if (instance == null) {
            instance = new CustomRuntimeClasspathModel();
        }
        return instance;
    }

    private CustomRuntimeClasspathModel() {
    }

    public IRuntimePathProvider[] getEntries(IRuntimeType type) {
        InternalRuntimeClasspathModel model;
        if (type == null) {
            return new IRuntimePathProvider[0];
        }
        String id = type.getId();
        if (this.modelMap.get(id) == null && (model = new RuntimeClasspathModelIO().readModel(type)) != null) {
            this.modelMap.put(id, model);
        }
        if ((model = this.modelMap.get(id)) != null) {
            return model.getStandardProviders();
        }
        return this.getDefaultEntries(type);
    }

    public IRuntimePathProvider[] getDefaultEntries(IRuntimeType type) {
        InternalRuntimeClasspathModel model = new DefaultClasspathModelLoader().getDefaultRuntimeClasspathModel(type);
        return model.getStandardProviders();
    }

    public void savePathProviders(IRuntimeType runtime, IRuntimePathProvider[] sets) {
        InternalRuntimeClasspathModel m = new InternalRuntimeClasspathModel();
        m.addProviders(sets);
        String id = runtime.getId();
        this.modelMap.put(id, m);
        new RuntimeClasspathModelIO().saveModel(runtime, m);
        ClasspathCorePlugin.clearCachedClasspathEntries(runtime);
    }
}

