/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ide.eclipse.as.classpath.core.runtime.cache.internal;

import java.text.MessageFormat;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.wst.server.core.IRuntime;
import org.eclipse.wst.server.core.IRuntimeLifecycleListener;
import org.jboss.ide.eclipse.as.classpath.core.ClasspathCorePlugin;
import org.jboss.ide.eclipse.as.classpath.core.internal.Messages;
import org.jboss.ide.eclipse.as.classpath.core.runtime.cache.internal.RuntimeKey;
import org.jboss.ide.eclipse.as.core.server.IJBossServerRuntime;

public class RuntimeClasspathCache
implements IRuntimeLifecycleListener {
    private static RuntimeClasspathCache instance = null;
    private Map<RuntimeKey, IClasspathEntry[]> runtimeClasspaths = new HashMap<RuntimeKey, IClasspathEntry[]>();

    public static RuntimeClasspathCache getInstance() {
        if (instance == null) {
            instance = new RuntimeClasspathCache();
        }
        return instance;
    }

    RuntimeClasspathCache() {
    }

    public void runtimeRemoved(IRuntime runtime) {
        this.removeRuntimeClasspath(runtime);
    }

    public void runtimeChanged(IRuntime runtime) {
        this.removeRuntimeClasspath(runtime);
    }

    public void runtimeAdded(IRuntime runtime) {
    }

    private void removeRuntimeClasspath(IRuntime runtime) {
        if (runtime == null) {
            return;
        }
        RuntimeKey key = RuntimeClasspathCache.getRuntimeKey(runtime);
        if (key != null) {
            this.runtimeClasspaths.remove(key);
        }
    }

    private Map<RuntimeKey, IClasspathEntry[]> getRuntimeClasspaths() {
        return this.runtimeClasspaths;
    }

    public IClasspathEntry[] getEntries(IRuntime rt) {
        return this.getRuntimeClasspaths().get(RuntimeClasspathCache.getRuntimeKey(rt));
    }

    public void cacheEntries(IRuntime rt, IClasspathEntry[] entries) {
        this.getRuntimeClasspaths().put(RuntimeClasspathCache.getRuntimeKey(rt), entries);
    }

    static RuntimeKey getRuntimeKey(IRuntime runtime) {
        if (runtime == null) {
            RuntimeClasspathCache.logError(runtime);
            return null;
        }
        IJBossServerRuntime jbsrt = (IJBossServerRuntime)runtime.loadAdapter(IJBossServerRuntime.class, (IProgressMonitor)new NullProgressMonitor());
        if (jbsrt == null) {
            return null;
        }
        IPath loc = runtime.getLocation();
        String rtID = runtime.getRuntimeType().getId();
        IPath configPath = jbsrt == null ? null : jbsrt.getConfigurationFullPath();
        return new RuntimeKey(loc, configPath, rtID);
    }

    private static void logError(IRuntime runtime) {
        Status status = new Status(2, "org.jboss.ide.eclipse.as.classpath.core", MessageFormat.format(Messages.ClientAllRuntimeClasspathProvider_wrong_runtime_type, runtime == null ? null : runtime.getName()));
        ClasspathCorePlugin.getDefault().getLog().log((IStatus)status);
    }
}

