/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.as.management.itests;

import java.io.File;
import java.io.IOException;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Collection;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.jboss.ide.eclipse.as.management.core.IAS7ManagementDetails;
import org.jboss.ide.eclipse.as.management.core.IJBoss7ManagerService;
import org.jboss.ide.eclipse.as.management.core.JBoss7DeploymentState;
import org.jboss.ide.eclipse.as.management.core.JBoss7ManagerServiceProxy;
import org.jboss.ide.eclipse.as.management.core.JBoss7ManangerException;
import org.jboss.ide.eclipse.as.management.core.JBoss7ServerState;
import org.jboss.tools.as.management.itests.utils.AS7ManagerTestUtils;
import org.jboss.tools.as.management.itests.utils.AssertUtility;
import org.jboss.tools.as.management.itests.utils.ParameterUtils;
import org.jboss.tools.as.management.itests.utils.StartupUtility;
import org.jboss.tools.as.test.core.internal.utils.MatrixUtils;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.osgi.util.tracker.ServiceTracker;

@RunWith(value=Parameterized.class)
public class AS7ManagerIntegrationTest
extends AssertUtility {
    private static StartupUtility util;
    private String homeDir;
    IJBoss7ManagerService service;

    @Parameterized.Parameters
    public static Collection<Object[]> data() {
        ArrayList l = MatrixUtils.toMatrix((Object[][])new Object[][]{ParameterUtils.getAS7ServerHomes()});
        return l;
    }

    @BeforeClass
    public static void init() {
        util = new StartupUtility();
    }

    @AfterClass
    public static void cleanup() {
        util.dispose();
    }

    public AS7ManagerIntegrationTest(String home) {
        this.homeDir = home;
    }

    @Before
    public void before() throws IOException {
        AS7ManagerIntegrationTest.assertNotNull((Object)this.homeDir);
        AS7ManagerIntegrationTest.assertTrue((boolean)new Path(this.homeDir).toFile().exists());
        String rtType = ParameterUtils.serverHomeToRuntimeType.get(this.homeDir);
        AS7ManagerIntegrationTest.assertNotNull((Object)rtType);
        IJBoss7ManagerService service2 = AS7ManagerTestUtils.findService(rtType);
        AS7ManagerIntegrationTest.assertNotNull((String)("Management Service for runtime type " + rtType + " not found."), (Object)service2);
        AS7ManagerIntegrationTest.assertTrue((boolean)(service2 instanceof JBoss7ManagerServiceProxy));
        AS7ManagerIntegrationTest.assertTrue((boolean)(service2 instanceof ServiceTracker));
        Object o = ((ServiceTracker)service2).getService();
        AS7ManagerIntegrationTest.assertNotNull((Object)o);
        System.out.println("\n\nBeginning a new management test");
        System.out.println("homedir = " + this.homeDir);
        if (!this.homeDir.equals(util.getHomeDir())) {
            System.out.println("disposing previous util");
            util.dispose();
            util.setHomeDir(this.homeDir);
            System.out.println("launching server for homedir=" + this.homeDir);
            util.start(true);
        }
        AS7ManagerIntegrationTest.assertTrue((String)("There is no server at localhost that listens on port " + util.getPort()), (boolean)AS7ManagerTestUtils.isListening("localhost", util.getPort()));
        this.service = service2;
    }

    @After
    public void tearDown() {
    }

    @Test
    public void deployedWarIsResponding() throws Exception {
        File warFile = AS7ManagerTestUtils.getWarFile("minimalistic.war");
        try {
            this.service.deploySync(AS7ManagerIntegrationTest.createManagementDetails(), warFile.getName(), warFile, true, (IProgressMonitor)new NullProgressMonitor());
            String response = AS7ManagerTestUtils.waitForRespose("minimalistic", "localhost", 8080);
            AS7ManagerIntegrationTest.assertTrue((response != null && response.indexOf("minimalistic") >= 0 ? 1 : 0) != 0);
        }
        finally {
            AS7ManagerTestUtils.quietlyUndeploy(warFile.getName(), this.service, AS7ManagerIntegrationTest.createManagementDetails());
        }
    }

    @Test
    public void getEnabledStateIfDeploymentIsDeployed() throws URISyntaxException, IOException, JBoss7ManangerException {
        String deploymentName = "testDeployment";
        File warFile = AS7ManagerTestUtils.getWarFile("minimalistic.war");
        try {
            this.service.deploySync(AS7ManagerIntegrationTest.createManagementDetails(), deploymentName, warFile, true, (IProgressMonitor)new NullProgressMonitor());
            JBoss7DeploymentState state = this.service.getDeploymentState(AS7ManagerIntegrationTest.createManagementDetails(), deploymentName);
            AS7ManagerIntegrationTest.assertNotNull((Object)state);
            AS7ManagerIntegrationTest.assertTrue((boolean)AS7ManagerIntegrationTest.areEqual(state, JBoss7DeploymentState.STARTED));
        }
        finally {
            AS7ManagerTestUtils.quietlyUndeploy(deploymentName, this.service, AS7ManagerIntegrationTest.createManagementDetails());
        }
    }

    @Test
    public void getDisabledStateIfDeploymentIsOnlyAdded() throws URISyntaxException, IOException, JBoss7ManangerException {
        String deploymentName = "testDeployment";
        File warFile = AS7ManagerTestUtils.getWarFile("minimalistic.war");
        try {
            this.service.addDeployment(AS7ManagerIntegrationTest.createManagementDetails(), deploymentName, warFile, (IProgressMonitor)new NullProgressMonitor());
            JBoss7DeploymentState state = this.service.getDeploymentState(AS7ManagerIntegrationTest.createManagementDetails(), deploymentName);
            AS7ManagerIntegrationTest.assertNotNull((Object)state);
            AS7ManagerIntegrationTest.assertTrue((boolean)AS7ManagerIntegrationTest.areEqual(state, JBoss7DeploymentState.STOPPED));
        }
        finally {
            AS7ManagerTestUtils.quietlyRemove(deploymentName, this.service, AS7ManagerIntegrationTest.createManagementDetails());
        }
    }

    @Test
    public void getErrorIfDeploymentIsNotDeployed() throws URISyntaxException, IOException, JBoss7ManangerException {
        String deploymentName = "testDeployment";
        try {
            JBoss7DeploymentState state = this.service.getDeploymentState(AS7ManagerIntegrationTest.createManagementDetails(), deploymentName);
            AS7ManagerIntegrationTest.assertEquals((Object)state, (Object)JBoss7DeploymentState.NOT_FOUND);
        }
        finally {
            AS7ManagerTestUtils.quietlyUndeploy(deploymentName, this.service, AS7ManagerIntegrationTest.createManagementDetails());
        }
    }

    @Test
    public void canGetServerState() throws JBoss7ManangerException {
        AS7ManagerIntegrationTest.assertEquals((Object)JBoss7ServerState.RUNNING, (Object)this.service.getServerState(AS7ManagerIntegrationTest.createManagementDetails()));
    }

    public static IAS7ManagementDetails createManagementDetails() {
        return new AS7ManagerTestUtils.MockAS7ManagementDetails("localhost", util.getPort());
    }
}

