/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ide.eclipse.as.ui.views.as7.management.content;

import com.ibm.icu.text.MessageFormat;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.PlatformUI;
import org.jboss.ide.eclipse.as.ui.Messages;
import org.jboss.ide.eclipse.as.ui.views.as7.management.content.IAttributeNode;
import org.jboss.ide.eclipse.as.ui.views.as7.management.content.IContainerNode;
import org.jboss.ide.eclipse.as.ui.views.as7.management.content.IContentNode;
import org.jboss.ide.eclipse.as.ui.views.as7.management.content.IErrorNode;
import org.jboss.ide.eclipse.as.ui.views.as7.management.content.ServerContentTreeContentProvider;

public class ServerContentLabelProvider
extends LabelProvider {
    private static Map<String, String> LABELS = new HashMap<String, String>();

    static {
        LABELS.put("attributes", Messages.ServerContent_Type_attributes);
        LABELS.put("core-service", Messages.ServerContent_Type_core_service);
        LABELS.put("deployment", Messages.ServerContent_Type_deployment);
        LABELS.put("extension", Messages.ServerContent_Type_extension);
        LABELS.put("interface", Messages.ServerContent_Type_interface);
        LABELS.put("path", Messages.ServerContent_Type_path);
        LABELS.put("root", Messages.ServerContent_Type_root);
        LABELS.put("socket-binding-group", Messages.ServerContent_Type_socket_binding_group);
        LABELS.put("subsystem", Messages.ServerContent_Type_subsystem);
        LABELS.put("system-property", Messages.ServerContent_Type_system_property);
    }

    public String getText(Object element) {
        if (element instanceof IAttributeNode) {
            IAttributeNode attrNode = (IAttributeNode)element;
            String value = attrNode.getValue();
            if (value == null || "undefined".equals(value)) {
                value = Messages.ServerContent_Value_undefined;
            }
            return MessageFormat.format((String)Messages.ServerContent_Label_Attribute_Value, (Object[])new Object[]{attrNode.getName(), value});
        }
        if (element instanceof IErrorNode) {
            return ((IErrorNode)element).getText();
        }
        if (element instanceof IContentNode) {
            return this.getMappedName(((IContentNode)element).getName());
        }
        if (element == ServerContentTreeContentProvider.PENDING) {
            return Messages.ServerContent_Label_Loading;
        }
        return super.getText(element);
    }

    public Image getImage(Object element) {
        if (element instanceof IContainerNode) {
            return PlatformUI.getWorkbench().getSharedImages().getImage("IMG_OBJ_FOLDER");
        }
        if (element instanceof IErrorNode) {
            return PlatformUI.getWorkbench().getSharedImages().getImage("IMG_OBJS_ERROR_TSK");
        }
        if (element instanceof IContentNode) {
            return PlatformUI.getWorkbench().getSharedImages().getImage("IMG_OBJ_FILE");
        }
        return super.getImage(element);
    }

    private String getMappedName(String name) {
        if (name == null) {
            return Messages.ServerContent_Value_undefined;
        }
        if (LABELS.containsKey(name)) {
            return LABELS.get(name);
        }
        return name;
    }
}

