/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.tycho.discovery;

import de.pdark.decentxml.Document;
import de.pdark.decentxml.Element;
import de.pdark.decentxml.XMLParser;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.io.IOUtils;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.eclipse.tycho.p2.resolver.TargetDefinitionFile;
import org.eclipse.tycho.p2.target.facade.TargetDefinition;

@Mojo(name="update-listing", defaultPhase=LifecyclePhase.GENERATE_RESOURCES, requiresProject=false)
public class ExtendListingMojo
extends AbstractMojo {
    @Parameter(property="project")
    private MavenProject project;
    @Parameter(property="targetListingFile", defaultValue="earlyaccess.properties")
    private File targetListingFile;
    @Parameter(property="targetDefinitionFile", required=true)
    private File targetDefinitionFile;
    @Parameter(property="initialListing", required=false)
    private URL initialListingFile;

    public void execute() throws MojoExecutionException, MojoFailureException {
        File pluginFile = new File(this.project.getBasedir(), "plugin.xml");
        HashSet<String> earlyAccessIuIds = new HashSet<String>();
        Document pluginDOM = null;
        try {
            pluginDOM = XMLParser.parse((File)pluginFile);
        }
        catch (IOException ex) {
            throw new MojoFailureException(ex.getMessage(), (Throwable)ex);
        }
        for (Element extensionElement : pluginDOM.getChild("plugin").getChildren("extension")) {
            if (!"org.eclipse.mylyn.discovery.core.connectorDiscovery".equals(extensionElement.getAttributeValue("point"))) continue;
            for (Element connectorElement : extensionElement.getChildren("connectorDescriptor")) {
                if (!connectorElement.getAttributeValue("certificationId").toLowerCase().contains("earlyaccess")) continue;
                for (Element iuElement : connectorElement.getChildren("iu")) {
                    earlyAccessIuIds.add(iuElement.getAttributeValue("id") + ".feature.group");
                }
            }
        }
        HashMap<String, String> earlyAccessIUsToVersion = new HashMap<String, String>();
        TargetDefinitionFile file = TargetDefinitionFile.read((File)this.targetDefinitionFile);
        for (TargetDefinition.Location location : file.getLocations()) {
            if (!(location instanceof TargetDefinitionFile.IULocation)) {
                throw new MojoExecutionException("Only p2 IUs location are supported");
            }
            TargetDefinitionFile.IULocation iULocation = (TargetDefinitionFile.IULocation)location;
            for (TargetDefinition.Unit unit : iULocation.getUnits()) {
                if (!earlyAccessIuIds.contains(unit.getId())) continue;
                earlyAccessIUsToVersion.put(unit.getId(), unit.getVersion());
            }
        }
        Properties listing = new Properties();
        if (this.initialListingFile != null) {
            Object stream = null;
            try {
                stream = this.initialListingFile.openStream();
                listing.load((InputStream)stream);
            }
            catch (Exception exception) {
                try {
                    throw new MojoFailureException(exception.getMessage(), (Throwable)exception);
                }
                catch (Throwable throwable) {
                    IOUtils.closeQuietly(stream);
                    throw throwable;
                }
            }
            IOUtils.closeQuietly((InputStream)stream);
        }
        for (Map.Entry entry : earlyAccessIUsToVersion.entrySet()) {
            String version = (String)entry.getValue();
            String toVersionRange = "[" + version + "," + version + "]";
            String currentEntry = (String)listing.get(entry.getKey());
            if (currentEntry == null) {
                currentEntry = toVersionRange;
            } else if (!currentEntry.contains(toVersionRange)) {
                currentEntry = currentEntry + ";";
                currentEntry = currentEntry + toVersionRange;
            }
            listing.put(entry.getKey(), currentEntry);
        }
        try {
            FileOutputStream out = new FileOutputStream(this.targetListingFile);
            listing.store(out, null);
        }
        catch (Exception ex) {
            throw new MojoFailureException(ex.getMessage(), (Throwable)ex);
        }
    }
}

