/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.unit.tooling.ant;

import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.types.Environment;
import org.apache.tools.ant.types.Path;
import org.jboss.unit.tooling.ant.TestsType;
import org.jboss.unit.tooling.ant.configuration.ParameterType;
import org.jboss.unit.tooling.ant.configuration.ReportsType;

public class JBossUnitTask
extends Task {
    public static final String MAVEN_SKIP_TEST = "maven.test.skip";
    List<TestsType> testsTypes = new LinkedList<TestsType>();
    private ReportsType reports;
    private Path path;
    private boolean jpda;
    private String jpdaPort = "9000";
    private boolean jpdaSuspend = true;
    private boolean useJUL = true;
    private boolean assertions = true;
    private boolean failOnError = false;
    private Set<Environment.Variable> sysproperties = new HashSet<Environment.Variable>();
    private Set<ParameterType> parameters = new HashSet<ParameterType>();

    public void addConfiguredTests(TestsType tests) {
        tests.setProject(this.getProject());
        tests.setParent(this);
        this.testsTypes.add(tests);
    }

    public void addConfiguredClasspath(Path path) {
        System.out.println("Adding path: " + path.toString());
        this.path = path;
    }

    public void addConfiguredReports(ReportsType reports) {
        this.reports = reports;
    }

    public void addConfiguredParameter(ParameterType param) {
        this.parameters.add(param);
    }

    public void execute() throws BuildException {
        String testSkip = (String)this.getProject().getProperties().get(MAVEN_SKIP_TEST);
        if (testSkip != null && testSkip.equalsIgnoreCase("true")) {
            System.out.println("Skipping test execution: maven.test.skip set to true");
            return;
        }
        for (TestsType testsType : this.testsTypes) {
            if (testsType.getReports() == null && this.getReports() != null) {
                testsType.setReports(this.getReports());
            }
            if (testsType.getClasspath() == null && this.path != null) {
                testsType.addConfiguredClasspath(this.path);
            }
            HashSet<Environment.Variable> propCopy = new HashSet<Environment.Variable>();
            propCopy.addAll(this.sysproperties);
            propCopy.addAll(testsType.getSysproperties());
            testsType.setSysproperties(propCopy);
            HashSet<ParameterType> paramCopy = new HashSet<ParameterType>();
            paramCopy.addAll(this.parameters);
            paramCopy.addAll(testsType.getParameters());
            testsType.setParameters(paramCopy);
            testsType.execute();
        }
    }

    public void addConfiguredSysproperty(Environment.Variable variable) {
        this.sysproperties.add(variable);
    }

    public ReportsType getReports() {
        return this.reports;
    }

    public void setReports(ReportsType reports) {
        this.reports = reports;
    }

    public boolean isJpda() {
        return this.jpda;
    }

    public void setJpda(boolean jpda) {
        this.jpda = jpda;
    }

    public String getJpdaPort() {
        return this.jpdaPort;
    }

    public void setJpdaPort(String jpdaPort) {
        this.jpdaPort = jpdaPort;
    }

    public boolean isJpdaSuspend() {
        return this.jpdaSuspend;
    }

    public void setJpdaSuspend(boolean jpdaSuspend) {
        this.jpdaSuspend = jpdaSuspend;
    }

    public boolean isUseJUL() {
        return this.useJUL;
    }

    public void setUseJUL(boolean useJUL) {
        this.useJUL = useJUL;
    }

    public boolean isAssertions() {
        return this.assertions;
    }

    public void setAssertions(boolean assertions) {
        this.assertions = assertions;
    }

    public boolean isFailOnError() {
        return this.failOnError;
    }

    public void setFailOnError(boolean failOnError) {
        this.failOnError = failOnError;
    }
}

