/******************************************************************************
 * JBoss, a division of Red Hat                                               *
 * Copyright 2006, Red Hat Middleware, LLC, and individual                    *
 * contributors as indicated by the @authors tag. See the                     *
 * copyright.txt in the distribution for a full listing of                    *
 * individual contributors.                                                   *
 *                                                                            *
 * This is free software; you can redistribute it and/or modify it            *
 * under the terms of the GNU Lesser General Public License as                *
 * published by the Free Software Foundation; either version 2.1 of           *
 * the License, or (at your option) any later version.                        *
 *                                                                            *
 * This software is distributed in the hope that it will be useful,           *
 * but WITHOUT ANY WARRANTY; without even the implied warranty of             *
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU           *
 * Lesser General Public License for more details.                            *
 *                                                                            *
 * You should have received a copy of the GNU Lesser General Public           *
 * License along with this software; if not, write to the Free                *
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA         *
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.                   *
 ******************************************************************************/
package org.jboss.portal.test.framework.impl.generic.agent;

import org.jboss.portal.test.framework.agent.TestAgent;
import org.jboss.portal.test.framework.impl.generic.config.AuthenticationConfig;
import org.jboss.portal.test.framework.impl.generic.config.DeployerConfig;
import org.jboss.portal.test.framework.impl.generic.server.GenericServiceLookup;
import org.jboss.portal.test.framework.server.ServiceLookupFailedException;
import org.codehaus.cargo.container.deployer.Deployer;
import org.codehaus.cargo.container.deployable.Deployable;
import org.codehaus.cargo.container.deployable.WAR;
import org.codehaus.cargo.container.deployable.EAR;
import org.codehaus.cargo.container.configuration.Configuration;
import org.codehaus.cargo.container.property.RemotePropertySet;
import org.codehaus.cargo.container.Container;
import org.jboss.logging.Logger;

import java.net.URL;
import java.net.URISyntaxException;
import java.io.File;

/**
 * @author <a href="mailto:julien@jboss.org">Julien Viet</a>
 * @version $Revision: 1.1 $
 */
public class GenericTestAgent extends GenericServiceLookup implements TestAgent
{

   /** . */
   private static Logger log = org.jboss.logging.Logger.getLogger(GenericTestAgent.class);

   /** . */
   private Deployer cargoDeployer;

   /** . */
   private DeployerConfig deployerConfig;

   /** . */
   private AuthenticationConfig authenticationConfig;

   public DeployerConfig getDeployerConfig()
   {
      return deployerConfig;
   }

   public void setDeployerConfig(DeployerConfig deployerConfig)
   {
      this.deployerConfig = deployerConfig;
   }

   public AuthenticationConfig getAuthenticationConfig()
   {
      return authenticationConfig;
   }

   public void setAuthenticationConfig(AuthenticationConfig authenticationConfig)
   {
      this.authenticationConfig = authenticationConfig;
   }

   public void start()
   {
      Configuration cfg = deployerConfig.createConfiguration();

      //
      if (authenticationConfig != null)
      {
         cfg.setProperty(RemotePropertySet.USERNAME, authenticationConfig.getUsername());
         cfg.setProperty(RemotePropertySet.PASSWORD, authenticationConfig.getPassword());
      }

      //
      Container container = deployerConfig.createContainer(cfg);
      cargoDeployer = deployerConfig.createDeployer(container);
   }


//      String name = "jboss4x";
//      String protocol = "http";
//      String host = "localhost";
//      String port = "8080";
//   private ServerConfig createConfig()
//   {
//      AuthenticationConfig authentication = new AuthenticationConfig();
//      authentication.setUsername("admin");
//      authentication.setPassword("admin");
//
//      RemoteDeployerConfig cargo = new RemoteDeployerConfig();
//      cargo.setName("tomcat5x");
//      cargo.setHost("localhost");
//      cargo.setPort("8080");
//
//      ServerConfig ccfg = new ServerConfig("TomcatRemote");
//      ccfg.setAuthentication(authentication);
//      ccfg.setDeployer(cargo);
//      return ccfg;
//   }

   public void deploy(URL url) throws Exception
   {
      Deployable deployable = createDeployable(url);
      log.debug("Going to deploy " + url);
      cargoDeployer.deploy(deployable);
      log.debug("Deployed " + url);
   }

   public void undeploy(URL url) throws Exception
   {
      Deployable deployable = createDeployable(url);
      log.debug("Going to undeploy " + url);
      cargoDeployer.undeploy(deployable);
      log.debug("Undeployed " + url);
   }

   private Deployable createDeployable(URL url) throws URISyntaxException, IllegalArgumentException
   {
      if (url != null)
      {
         if ("file".equals(url.getProtocol()))
         {
            File f = new File(url.getFile());
            if (f.getName().endsWith(".war"))
            {
               return new WAR(f.getAbsolutePath());
            }
            else if(f.getName().endsWith(".ear"))
            {
               return new EAR(f.getAbsolutePath());
            }
         }
      }
      throw new IllegalArgumentException("Illegal URL " + url);
   }

   public Object lookupService() throws ServiceLookupFailedException
   {
      return this;
   }
}
