/******************************************************************************
 * JBoss, a division of Red Hat                                               *
 * Copyright 2006, Red Hat Middleware, LLC, and individual                    *
 * contributors as indicated by the @authors tag. See the                     *
 * copyright.txt in the distribution for a full listing of                    *
 * individual contributors.                                                   *
 *                                                                            *
 * This is free software; you can redistribute it and/or modify it            *
 * under the terms of the GNU Lesser General Public License as                *
 * published by the Free Software Foundation; either version 2.1 of           *
 * the License, or (at your option) any later version.                        *
 *                                                                            *
 * This software is distributed in the hope that it will be useful,           *
 * but WITHOUT ANY WARRANTY; without even the implied warranty of             *
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU           *
 * Lesser General Public License for more details.                            *
 *                                                                            *
 * You should have received a copy of the GNU Lesser General Public           *
 * License along with this software; if not, write to the Free                *
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA         *
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.                   *
 ******************************************************************************/

package org.jboss.portal.test.framework.embedded.opends;

import org.opends.server.core.DirectoryServer;

import java.security.AccessController;
import java.security.PrivilegedAction;
import java.net.URL;


/**
 * Class forked from JBoss Application Server testsuite: http://anonsvn.jboss.org/repos/jbossas/trunk/testsuite/src/main/org/jboss/test/security/test/opends/
 * <p/>
 * XMBean Service for OpenDS integration
 *
 * @author <a href="mailto:Anil.Saldhana@jboss.org">Anil Saldhana</a>
 * @author <a href="mailto:Boleslaw dot Dawidowicz at jboss dot com">Boleslaw Dawidowicz</a>
 * @version $Revision$
 * @since Sep 13, 2006
 */
public class OpenDSService implements OpenDSServiceMBean
{

   private static final org.jboss.logging.Logger log = org.jboss.logging.Logger.getLogger(OpenDSService.class);

   public static String objectName = "portal.test:service=OpenDSService";

   private String newline = (String)
            AccessController.doPrivileged(new GetSystemPropertyAction("line.separator"));

   /**
    * Print some information about the DS (eg: connections etc)
    * @return
    */
   public String printDiagnostics()
   {
     StringBuffer sb = new StringBuffer();
     sb.append("Maximum concurrent client connections allowed:");
     sb.append(DirectoryServer.getMaxAllowedConnections());
     sb.append(newline).append("# of client connections currently established:");
     sb.append(DirectoryServer.getCurrentConnections());
     return sb.toString();
   }

   /**
    * Restart the Directory Server
    */
   public void restart()
   {

    //TODO:
    DirectoryServer.restart(getClass().getName(), "DS restart");
   }

   public void create() throws Exception
   {
   }

   public void start() throws Exception
   {
      startService();
   }

   public void startService() throws Exception
   {

      //Get the location of the conf directory
      String confLoc = (String)AccessController.doPrivileged(
            new GetSystemPropertyAction("jboss.server.config.url"));


      ClassLoader tcl = Thread.currentThread().getContextClassLoader();
      URL ldif = tcl.getResource("opends/config/config.ldif");
      log.info("OpenDS config ldif = "+ldif.getPath());


      String[] strArr = new String[] {"--configClass",
                                    "org.opends.server.config.ConfigFileHandler",
                                    "--configFile",
                                    ldif.getPath()};
      //Start the OpenDS
      DirectoryServer.main(strArr);


   }

   public void stop() throws Exception
   {
      stopService();
   }

   public void stopService() throws Exception
   {
      //TODO:
      log.info("Asking DS to shutdown");
      DirectoryServer.shutDown(getClass().getName(), "Shut down DS");
   }

   public void destroy() throws Exception
   {
   }

   /**
    *
    * A GetSystemPropetyAction.
    *
    * @author <a href="anil.saldhana@jboss.com">Anil Saldhana</a>
    * @version $Revision: 1.1 $
    */
   public class GetSystemPropertyAction implements PrivilegedAction
   {
      private String property;

      public GetSystemPropertyAction(String prop)
      {
         this.property = prop;
      }

      public Object run()
      {
         return System.getProperty(property);
      }
   }

}