/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.portal.test.framework.common;

import java.io.IOException;
import java.io.Writer;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.Priority;

public class Log4JWriter
extends Writer {
    private boolean open;
    private Logger log;
    private Level level;

    public Log4JWriter(Logger log, Level level) throws IllegalArgumentException {
        if (log == null) {
            throw new IllegalArgumentException("No logger provided");
        }
        if (level == null) {
            throw new IllegalArgumentException("No level provided");
        }
        this.open = false;
        this.log = log;
        this.level = level;
    }

    public void write(char[] cbuf, int off, int len) throws IOException {
        if (!this.open) {
            throw new IOException("Stream closed");
        }
        this.log.log((Priority)this.level, (Object)new String(cbuf, off, len));
    }

    public void flush() throws IOException {
    }

    public void close() throws IOException {
        this.open = false;
    }
}

