/******************************************************************************
 * JBoss, a division of Red Hat                                               *
 * Copyright 2006, Red Hat Middleware, LLC, and individual                    *
 * contributors as indicated by the @authors tag. See the                     *
 * copyright.txt in the distribution for a full listing of                    *
 * individual contributors.                                                   *
 *                                                                            *
 * This is free software; you can redistribute it and/or modify it            *
 * under the terms of the GNU Lesser General Public License as                *
 * published by the Free Software Foundation; either version 2.1 of           *
 * the License, or (at your option) any later version.                        *
 *                                                                            *
 * This software is distributed in the hope that it will be useful,           *
 * but WITHOUT ANY WARRANTY; without even the implied warranty of             *
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU           *
 * Lesser General Public License for more details.                            *
 *                                                                            *
 * You should have received a copy of the GNU Lesser General Public           *
 * License along with this software; if not, write to the Free                *
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA         *
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.                   *
 ******************************************************************************/
package org.jboss.portal.test.framework.runner;

import org.jboss.portal.test.framework.server.NodeId;

import java.io.File;
import java.net.MalformedURLException;

import junit.framework.AssertionFailedError;

/**
 * @author <a href="mailto:julien@jboss.org">Julien Viet</a>
 * @version $Revision: 1.1 $
 */
public class HTTPTestRunner extends BaseRunner
{

   /** . */
   public static final String JBOSS_BEANS_LOCATION = "org/jboss/portal/test/framework/container/http-runner-beans.xml";

   /** . */
   private String archiveName;

   public HTTPTestRunner()
   {
      super(JBOSS_BEANS_LOCATION);
   }

   public HTTPTestRunner(NodeId[] nodeIds)
   {
      super(JBOSS_BEANS_LOCATION, nodeIds);
   }

   protected final void init(String archiveName)
   {
      this.archiveName = archiveName;
   }

   private String getArchiveName()
   {
//      if (archiveName == null)
//      {
//         TestParametrization parametrization = JUnitAdapter.getParametrization();
//         return (String)parametrization.getParameterValue("archive").get();
//      }
//      else
//      {
         return archiveName;
//      }
   }

   public void startRunner() throws Exception
   {
      File root = new File(getArchivePath());
      File f = new File(root, getArchiveName());
      deploy(f.toURL());
   }

   public void stopRunner()
   {
      try
      {
         File root = new File(getArchivePath());
         File f = new File(root, getArchiveName());
         undeploy(f.toURL());
      }
      catch (MalformedURLException e)
      {
         e.printStackTrace();
      }
   }

   public void testDummy()
   {
      throw new AssertionFailedError("Test dummy should not be called, it's a place holder so that running it from ant does not fail");
   }
}
