/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.portal.test.framework.deployment;

import java.io.IOException;
import java.net.URL;
import org.jboss.logging.Logger;
import org.jboss.portal.test.framework.agent.TestAgent;
import org.jboss.portal.test.framework.server.Node;

class Deployment {
    private static final Logger log = Logger.getLogger(Deployment.class);
    private final Node[] nodes;
    private URL url;
    private boolean deployed;

    public Deployment(Node[] nodes, URL url) {
        if (nodes == null) {
            throw new IllegalArgumentException("Does not accept null argument");
        }
        if (url == null) {
            throw new IllegalArgumentException("Does not accept null argument");
        }
        this.nodes = nodes;
        this.url = url;
        this.deployed = false;
    }

    void deploy() throws Exception, IllegalArgumentException, IllegalStateException, IOException {
        if (this.deployed) {
            throw new IllegalStateException("Cannot make 2 deployment at the same time");
        }
        for (int i = 0; i < this.nodes.length; ++i) {
            Node node = this.nodes[i];
            TestAgent agent = (TestAgent)node.lookupService("TestAgent");
            agent.deploy(this.url);
        }
        this.deployed = true;
    }

    void undeploy() {
        URL url = this.url;
        this.url = null;
        for (int i = 0; i < this.nodes.length; ++i) {
            try {
                Node node = this.nodes[i];
                TestAgent agent = (TestAgent)node.lookupService("TestAgent");
                agent.undeploy(url);
                continue;
            }
            catch (Exception e) {
                log.warn((Object)("Unexpected exception when undeploying " + e));
            }
        }
        this.deployed = false;
    }
}

