/******************************************************************************
 * JBoss, a division of Red Hat                                               *
 * Copyright 2006, Red Hat Middleware, LLC, and individual                    *
 * contributors as indicated by the @authors tag. See the                     *
 * copyright.txt in the distribution for a full listing of                    *
 * individual contributors.                                                   *
 *                                                                            *
 * This is free software; you can redistribute it and/or modify it            *
 * under the terms of the GNU Lesser General Public License as                *
 * published by the Free Software Foundation; either version 2.1 of           *
 * the License, or (at your option) any later version.                        *
 *                                                                            *
 * This software is distributed in the hope that it will be useful,           *
 * but WITHOUT ANY WARRANTY; without even the implied warranty of             *
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU           *
 * Lesser General Public License for more details.                            *
 *                                                                            *
 * You should have received a copy of the GNU Lesser General Public           *
 * License along with this software; if not, write to the Free                *
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA         *
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.                   *
 ******************************************************************************/
package org.jboss.portal.test.framework.impl.generic.config;

import org.codehaus.cargo.container.ContainerType;
import org.codehaus.cargo.container.Container;
import org.codehaus.cargo.container.property.GeneralPropertySet;
import org.codehaus.cargo.container.property.ServletPropertySet;
import org.codehaus.cargo.container.configuration.ConfigurationType;
import org.codehaus.cargo.container.configuration.Configuration;
import org.codehaus.cargo.container.deployer.DeployerType;
import org.codehaus.cargo.container.deployer.Deployer;
import org.codehaus.cargo.generic.configuration.ConfigurationFactory;
import org.codehaus.cargo.generic.configuration.DefaultConfigurationFactory;
import org.codehaus.cargo.generic.ContainerFactory;
import org.codehaus.cargo.generic.DefaultContainerFactory;
import org.codehaus.cargo.generic.deployer.DeployerFactory;
import org.codehaus.cargo.generic.deployer.DefaultDeployerFactory;

/**
 * @author <a href="mailto:julien@jboss.org">Julien Viet</a>
 * @version $Revision: 1.1 $
 */
public class RemoteDeployerConfig extends DeployerConfig
{

   /** . */
   private String name;

   /** . */
   private String host;

   /** . */
   private String port;

   public Configuration createConfiguration()
   {
      ConfigurationFactory cfgFactory = new DefaultConfigurationFactory();
      Configuration cfg = cfgFactory.createConfiguration(name, ContainerType.REMOTE, ConfigurationType.RUNTIME);
      cfg.setProperty(GeneralPropertySet.PROTOCOL, "http");
      cfg.setProperty(GeneralPropertySet.HOSTNAME, host);
      cfg.setProperty(ServletPropertySet.PORT, port);
      return cfg;
   }

   public Container createContainer(Configuration cfg)
   {
      ContainerFactory containerFactory = new DefaultContainerFactory();
      return containerFactory.createContainer(name, ContainerType.REMOTE, cfg);
   }

   public Deployer createDeployer(Container container)
   {
      DeployerFactory deployerFactory = new DefaultDeployerFactory();
      return deployerFactory.createDeployer(container, DeployerType.REMOTE);
   }

   public ContainerType getContainerType()
   {
      return ContainerType.REMOTE;
   }

   public DeployerType getDeployerType()
   {
      return DeployerType.REMOTE;
   }

   public ConfigurationType getConfigurationType()
   {
      return ConfigurationType.RUNTIME;
   }

   public String getName()
   {
      return name;
   }

   public void setName(String name)
   {
      this.name = name;
   }

   public String getHost()
   {
      return host;
   }

   public void setHost(String host)
   {
      this.host = host;
   }

   public String getPort()
   {
      return port;
   }

   public void setPort(String port)
   {
      this.port = port;
   }
}
