/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.core;

import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.management.ObjectName;
import javax.naming.NamingException;
import javax.servlet.DispatcherType;
import javax.servlet.Filter;
import javax.servlet.FilterConfig;
import javax.servlet.FilterRegistration;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import org.apache.catalina.Context;
import org.apache.catalina.Globals;
import org.apache.catalina.core.ApplicationFilterConfigFacade;
import org.apache.catalina.core.StandardContext;
import org.apache.catalina.deploy.FilterDef;
import org.apache.catalina.deploy.FilterMap;
import org.apache.catalina.security.SecurityUtil;
import org.apache.catalina.util.Enumerator;
import org.apache.tomcat.util.Constants;
import org.apache.tomcat.util.modeler.Registry;
import org.jboss.web.CatalinaLogger;
import org.jboss.web.CatalinaMessages;

public final class ApplicationFilterConfig
implements FilterConfig,
Serializable {
    protected ApplicationFilterConfigFacade facade = new ApplicationFilterConfigFacade(this);
    private transient Context context = null;
    protected boolean dynamic = false;
    private transient Filter filter = null;
    private transient Filter filterInstance = null;
    private FilterDef filterDef = null;
    private ObjectName oname;

    public ApplicationFilterConfig(Context context, FilterDef filterDef) {
        this.context = context;
        this.filterDef = filterDef;
    }

    public String getFilterName() {
        return this.filterDef.getFilterName();
    }

    public String getFilterClass() {
        return this.filterDef.getFilterClass();
    }

    public String getInitParameter(String name) {
        Map<String, String> map = this.filterDef.getParameterMap();
        if (map == null) {
            return null;
        }
        return map.get(name);
    }

    public Enumeration<String> getInitParameterNames() {
        Map<String, String> map = this.filterDef.getParameterMap();
        if (map == null) {
            return new Enumerator(new ArrayList());
        }
        return new Enumerator(map.keySet());
    }

    public ServletContext getServletContext() {
        return this.context.getServletContext();
    }

    public FilterRegistration getFacade() {
        return this.facade;
    }

    public boolean isDynamic() {
        return this.dynamic;
    }

    public void setDynamic(boolean dynamic) {
        this.dynamic = dynamic;
        if (dynamic) {
            this.facade = new ApplicationFilterConfigFacade.Dynamic(this);
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("ApplicationFilterConfig[");
        sb.append("name=");
        sb.append(this.filterDef.getFilterName());
        sb.append(", filterClass=");
        sb.append(this.filterDef.getFilterClass());
        sb.append("]");
        return sb.toString();
    }

    public boolean addMappingForServletNames(EnumSet<DispatcherType> dispatcherTypes, boolean isMatchAfter, String ... servletNames) {
        if (!this.context.isStarting()) {
            throw CatalinaMessages.MESSAGES.cannotAddFilterRegistrationAfterInit(this.context.getPath());
        }
        if (servletNames == null || servletNames.length == 0) {
            throw CatalinaMessages.MESSAGES.invalidFilterRegistrationArguments();
        }
        FilterMap filterMap = new FilterMap();
        for (String servletName : servletNames) {
            filterMap.addServletName(servletName);
        }
        filterMap.setFilterName(this.filterDef.getFilterName());
        if (dispatcherTypes != null) {
            for (DispatcherType dispatcherType : dispatcherTypes) {
                filterMap.setDispatcher(dispatcherType.name());
            }
        }
        if (isMatchAfter) {
            this.context.addFilterMap(filterMap);
        } else {
            this.context.addFilterMapBefore(filterMap);
        }
        return true;
    }

    public boolean addMappingForUrlPatterns(EnumSet<DispatcherType> dispatcherTypes, boolean isMatchAfter, String ... urlPatterns) {
        if (!this.context.isStarting()) {
            throw CatalinaMessages.MESSAGES.cannotAddFilterRegistrationAfterInit(this.context.getPath());
        }
        if (urlPatterns == null || urlPatterns.length == 0) {
            throw CatalinaMessages.MESSAGES.invalidFilterRegistrationArguments();
        }
        FilterMap filterMap = new FilterMap();
        for (String urlPattern : urlPatterns) {
            filterMap.addURLPattern(urlPattern);
        }
        filterMap.setFilterName(this.filterDef.getFilterName());
        if (dispatcherTypes != null) {
            for (DispatcherType dispatcherType : dispatcherTypes) {
                filterMap.setDispatcher(dispatcherType.name());
            }
        }
        if (isMatchAfter) {
            this.context.addFilterMap(filterMap);
        } else {
            this.context.addFilterMapBefore(filterMap);
        }
        return true;
    }

    public Collection<String> getServletNameMappings() {
        HashSet<String> result = new HashSet<String>();
        FilterMap[] filterMaps = this.context.findFilterMaps();
        for (int i = 0; i < filterMaps.length; ++i) {
            if (!this.filterDef.getFilterName().equals(filterMaps[i].getFilterName())) continue;
            FilterMap filterMap = filterMaps[i];
            String[] maps = filterMap.getServletNames();
            for (int j = 0; j < maps.length; ++j) {
                result.add(maps[j]);
            }
            if (!filterMap.getMatchAllServletNames()) continue;
            result.add("*");
        }
        return Collections.unmodifiableSet(result);
    }

    public Collection<String> getUrlPatternMappings() {
        HashSet<String> result = new HashSet<String>();
        FilterMap[] filterMaps = this.context.findFilterMaps();
        for (int i = 0; i < filterMaps.length; ++i) {
            if (!this.filterDef.getFilterName().equals(filterMaps[i].getFilterName())) continue;
            FilterMap filterMap = filterMaps[i];
            String[] maps = filterMap.getURLPatterns();
            for (int j = 0; j < maps.length; ++j) {
                result.add(maps[j]);
            }
            if (!filterMap.getMatchAllUrlPatterns()) continue;
            result.add("*");
        }
        return Collections.unmodifiableSet(result);
    }

    public void setAsyncSupported(boolean asyncSupported) {
        if (!this.context.isStarting()) {
            throw CatalinaMessages.MESSAGES.cannotAddFilterRegistrationAfterInit(this.context.getPath());
        }
        this.filterDef.setAsyncSupported(asyncSupported);
        this.context.addFilterDef(this.filterDef);
    }

    public void setDescription(String description) {
        this.filterDef.setDescription(description);
        this.context.addFilterDef(this.filterDef);
    }

    public boolean setInitParameter(String name, String value) {
        if (!this.context.isStarting()) {
            throw CatalinaMessages.MESSAGES.cannotAddFilterRegistrationAfterInit(this.context.getPath());
        }
        if (name == null || value == null) {
            throw CatalinaMessages.MESSAGES.invalidFilterRegistrationArguments();
        }
        if (this.filterDef.getInitParameter(name) != null) {
            return false;
        }
        this.filterDef.addInitParameter(name, value);
        this.context.addFilterDef(this.filterDef);
        return true;
    }

    public Set<String> setInitParameters(Map<String, String> initParameters) {
        if (!this.context.isStarting()) {
            throw CatalinaMessages.MESSAGES.cannotAddFilterRegistrationAfterInit(this.context.getPath());
        }
        if (initParameters == null) {
            throw CatalinaMessages.MESSAGES.invalidFilterRegistrationArguments();
        }
        HashSet<String> conflicts = new HashSet<String>();
        for (String parameterName : initParameters.keySet()) {
            if (this.filterDef.getInitParameter(parameterName) != null) {
                conflicts.add(parameterName);
                continue;
            }
            String value = initParameters.get(parameterName);
            if (value == null) {
                throw CatalinaMessages.MESSAGES.invalidFilterRegistrationArguments();
            }
            this.filterDef.addInitParameter(parameterName, value);
        }
        this.context.addFilterDef(this.filterDef);
        return conflicts;
    }

    public Map<String, String> getInitParameters() {
        return Collections.unmodifiableMap(this.filterDef.getParameterMap());
    }

    Filter getFilter() throws ClassCastException, ClassNotFoundException, IllegalAccessException, InstantiationException, ServletException, InvocationTargetException, NamingException {
        if (this.filter != null) {
            return this.filter;
        }
        if (this.filterInstance == null) {
            String filterClass = this.filterDef.getFilterClass();
            this.filter = (Filter)this.context.getInstanceManager().newInstance(filterClass);
        } else {
            this.filter = this.filterInstance;
            this.filterInstance = null;
        }
        this.filter.init((FilterConfig)this);
        if (Constants.ENABLE_MODELER) {
            this.registerJMX();
        }
        return this.filter;
    }

    public void setFilter(Filter filter) {
        this.filterInstance = filter;
    }

    public Filter getFilterInstance() {
        return this.filterInstance != null ? this.filterInstance : this.filter;
    }

    public FilterDef getFilterDef() {
        return this.filterDef;
    }

    void release() {
        if (Constants.ENABLE_MODELER) {
            this.unregsiterJMX();
        }
        if (this.filter != null) {
            if (Globals.IS_SECURITY_ENABLED) {
                try {
                    SecurityUtil.doAsPrivilege("destroy", this.filter);
                }
                catch (Exception ex) {
                    this.context.getLogger().error((Object)CatalinaMessages.MESSAGES.doAsPrivilegeException(), (Throwable)ex);
                }
                SecurityUtil.remove(this.filter);
            } else {
                this.filter.destroy();
            }
            try {
                ((StandardContext)this.context).getInstanceManager().destroyInstance(this.filter);
            }
            catch (Exception e) {
                this.context.getLogger().error((Object)CatalinaMessages.MESSAGES.preDestroyException(), (Throwable)e);
            }
        }
        this.filter = null;
    }

    private void registerJMX() {
        String parentName = this.context.getName();
        parentName = "".equals(parentName) ? "/" : parentName;
        String hostName = this.context.getParent().getName();
        hostName = hostName == null ? "DEFAULT" : hostName;
        String domain = this.context.getParent().getParent().getName();
        String webMod = "//" + hostName + parentName;
        String onameStr = null;
        if (this.context instanceof StandardContext) {
            StandardContext standardContext = (StandardContext)this.context;
            onameStr = domain + ":j2eeType=Filter,name=" + this.filterDef.getFilterName() + ",WebModule=" + webMod + ",J2EEApplication=" + standardContext.getJ2EEApplication() + ",J2EEServer=" + standardContext.getJ2EEServer();
        } else {
            onameStr = domain + ":j2eeType=Filter,name=" + this.filterDef.getFilterName() + ",WebModule=" + webMod;
        }
        try {
            this.oname = new ObjectName(onameStr);
            Registry.getRegistry(null, null).registerComponent((Object)this, this.oname, null);
        }
        catch (Exception ex) {
            CatalinaLogger.CORE_LOGGER.filterJmxRegistrationFailed(this.getFilterClass(), this.getFilterName(), ex);
        }
    }

    private void unregsiterJMX() {
        if (this.oname != null) {
            try {
                Registry.getRegistry(null, null).unregisterComponent(this.oname);
            }
            catch (Exception ex) {
                CatalinaLogger.CORE_LOGGER.filterJmxUnregistrationFailed(this.getFilterClass(), this.getFilterName(), ex);
            }
        }
    }
}

