/*
 * Decompiled with CFR 0.152.
 */
package org.apache.coyote.http11;

import java.io.IOException;
import java.util.StringTokenizer;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.apache.coyote.ActionHook;
import org.apache.coyote.Adapter;
import org.apache.coyote.Request;
import org.apache.coyote.Response;
import org.apache.tomcat.util.buf.Ascii;
import org.apache.tomcat.util.buf.ByteChunk;
import org.apache.tomcat.util.buf.MessageBytes;
import org.apache.tomcat.util.net.NioEndpoint;
import org.apache.tomcat.util.net.SSLSupport;
import org.apache.tomcat.util.net.SocketStatus;
import org.jboss.web.CoyoteLogger;

public abstract class Http11AbstractProcessor
implements ActionHook {
    protected static final boolean CHUNK_ON_CLOSE = Boolean.valueOf(System.getProperty("org.apache.coyote.http11.Http11Processor.CHUNK_ON_CLOSE", "false"));
    public static ThreadLocal<Boolean> containerThread = new ThreadLocal();
    protected Adapter adapter = null;
    protected Request request = null;
    protected Response response = null;
    protected boolean error = false;
    protected boolean keepAlive = true;
    protected boolean http11 = true;
    protected boolean http09 = false;
    protected boolean contentDelimitation = true;
    protected boolean expectation = false;
    protected Pattern[] restrictedUserAgents = null;
    protected int maxKeepAliveRequests = -1;
    protected int keepAliveTimeout = -1;
    protected SSLSupport sslSupport;
    protected String remoteAddr = null;
    protected String remoteHost = null;
    protected String localName = null;
    protected int localPort = -1;
    protected int remotePort = -1;
    protected String localAddr = null;
    protected boolean disableUploadTimeout = false;
    protected int compressionLevel = 0;
    protected int compressionMinSize = 2048;
    protected int maxSavePostSize = 4096;
    protected Pattern[] noCompressionUserAgents = null;
    protected String[] compressableMimeTypes = new String[]{"text/html", "text/xml", "text/plain"};
    protected char[] hostNameC = new char[0];
    protected String server = null;
    protected boolean sslEnabled;
    protected boolean event = false;
    protected boolean resumeNotification = false;
    protected boolean readNotifications = true;
    protected boolean writeNotification = false;
    protected boolean eventProcessing = true;
    protected int timeout = -1;

    public String getCompression() {
        switch (this.compressionLevel) {
            case 0: {
                return "off";
            }
            case 1: {
                return "on";
            }
            case 2: {
                return "force";
            }
        }
        return "off";
    }

    public void setCompression(String compression) {
        if (compression.equals("on")) {
            this.compressionLevel = 1;
        } else if (compression.equals("force")) {
            this.compressionLevel = 2;
        } else if (compression.equals("off")) {
            this.compressionLevel = 0;
        } else {
            try {
                this.compressionMinSize = Integer.parseInt(compression);
                this.compressionLevel = 1;
            }
            catch (Exception e) {
                this.compressionLevel = 0;
            }
        }
    }

    public void addNoCompressionUserAgent(String userAgent) {
        try {
            Pattern nRule = Pattern.compile(userAgent);
            this.noCompressionUserAgents = this.addREArray(this.noCompressionUserAgents, nRule);
        }
        catch (PatternSyntaxException pse) {
            CoyoteLogger.HTTP_LOGGER.errorParsingRegexp(userAgent, pse);
        }
    }

    public void setNoCompressionUserAgents(String noCompressionUserAgents) {
        if (noCompressionUserAgents != null) {
            StringTokenizer st = new StringTokenizer(noCompressionUserAgents, ",");
            while (st.hasMoreTokens()) {
                this.addNoCompressionUserAgent(st.nextToken().trim());
            }
        }
    }

    public void addCompressableMimeType(String mimeType) {
        this.compressableMimeTypes = this.addStringArray(this.compressableMimeTypes, mimeType);
    }

    public void setCompressableMimeTypes(String[] compressableMimeTypes) {
        this.compressableMimeTypes = compressableMimeTypes;
    }

    public void setCompressableMimeTypes(String compressableMimeTypes) {
        if (compressableMimeTypes != null) {
            this.compressableMimeTypes = null;
            StringTokenizer st = new StringTokenizer(compressableMimeTypes, ",");
            while (st.hasMoreTokens()) {
                this.addCompressableMimeType(st.nextToken().trim());
            }
        }
    }

    public String[] findCompressableMimeTypes() {
        return this.compressableMimeTypes;
    }

    protected abstract void addFilter(String var1);

    protected String[] addStringArray(String[] sArray, String value) {
        String[] result = null;
        if (sArray == null) {
            result = new String[]{value};
        } else {
            result = new String[sArray.length + 1];
            for (int i = 0; i < sArray.length; ++i) {
                result[i] = sArray[i];
            }
            result[sArray.length] = value;
        }
        return result;
    }

    protected Pattern[] addREArray(Pattern[] rArray, Pattern value) {
        Pattern[] result = null;
        if (rArray == null) {
            result = new Pattern[]{value};
        } else {
            result = new Pattern[rArray.length + 1];
            for (int i = 0; i < rArray.length; ++i) {
                result[i] = rArray[i];
            }
            result[rArray.length] = value;
        }
        return result;
    }

    protected boolean startsWithStringArray(String[] sArray, String value) {
        if (value == null) {
            return false;
        }
        for (int i = 0; i < sArray.length; ++i) {
            if (!value.startsWith(sArray[i])) continue;
            return true;
        }
        return false;
    }

    public void addRestrictedUserAgent(String userAgent) {
        try {
            Pattern nRule = Pattern.compile(userAgent);
            this.restrictedUserAgents = this.addREArray(this.restrictedUserAgents, nRule);
        }
        catch (PatternSyntaxException pse) {
            CoyoteLogger.HTTP_LOGGER.errorParsingRegexp(userAgent, pse);
        }
    }

    public void setRestrictedUserAgents(String restrictedUserAgents) {
        if (restrictedUserAgents != null) {
            StringTokenizer st = new StringTokenizer(restrictedUserAgents, ",");
            while (st.hasMoreTokens()) {
                this.addRestrictedUserAgent(st.nextToken().trim());
            }
        }
    }

    public String[] findRestrictedUserAgents() {
        String[] sarr = new String[this.restrictedUserAgents.length];
        for (int i = 0; i < this.restrictedUserAgents.length; ++i) {
            sarr[i] = this.restrictedUserAgents[i].toString();
        }
        return sarr;
    }

    public void setServer(String server) {
        this.server = server == null || server.equals("") ? null : server;
    }

    public abstract void endRequest();

    public void recycle() {
        this.timeout = -1;
        this.readNotifications = true;
        this.writeNotification = false;
        this.resumeNotification = false;
        this.eventProcessing = true;
    }

    protected boolean isCompressable() {
        long contentLength;
        MessageBytes userAgentValueMB;
        MessageBytes acceptEncodingMB = this.request.getMimeHeaders().getValue("accept-encoding");
        if (acceptEncodingMB == null || acceptEncodingMB.indexOf("gzip") == -1) {
            return false;
        }
        MessageBytes contentEncodingMB = this.response.getMimeHeaders().getValue("Content-Encoding");
        if (contentEncodingMB != null && contentEncodingMB.indexOf("gzip") != -1) {
            return false;
        }
        if (this.compressionLevel == 2) {
            return true;
        }
        if (this.noCompressionUserAgents != null && (userAgentValueMB = this.request.getMimeHeaders().getValue("user-agent")) != null) {
            String userAgentValue = userAgentValueMB.toString();
            for (int i = 0; i < this.noCompressionUserAgents.length; ++i) {
                if (!this.noCompressionUserAgents[i].matcher(userAgentValue).matches()) continue;
                return false;
            }
        }
        if (((contentLength = this.response.getContentLengthLong()) == -1L || contentLength > (long)this.compressionMinSize) && this.compressableMimeTypes != null) {
            return this.startsWithStringArray(this.compressableMimeTypes, this.response.getContentType());
        }
        return false;
    }

    protected abstract void prepareRequest();

    protected abstract void prepareResponse();

    protected abstract void initializeFilters();

    public abstract NioEndpoint.Handler.SocketState event(SocketStatus var1) throws IOException;

    protected void reset() {
        this.remoteAddr = null;
        this.remoteHost = null;
        this.localAddr = null;
        this.localName = null;
        this.remotePort = -1;
        this.localPort = -1;
        this.error = false;
        this.event = false;
        this.keepAlive = true;
    }

    protected boolean statusDropsConnection(int status) {
        return status == 400 || status == 408 || status == 411 || status == 413 || status == 414 || status == 500 || status == 503 || status == 501;
    }

    protected int findBytes(ByteChunk bc, byte[] b) {
        byte first = b[0];
        byte[] buff = bc.getBuffer();
        int start = bc.getStart();
        int end = bc.getEnd();
        int srcEnd = b.length;
        for (int i = start; i <= end - srcEnd; ++i) {
            if (Ascii.toLower(buff[i]) != first) continue;
            int myPos = i + 1;
            int srcPos = 1;
            while (srcPos < srcEnd && Ascii.toLower(buff[myPos++]) == b[srcPos++]) {
                if (srcPos != srcEnd) continue;
                return i - start;
            }
        }
        return -1;
    }

    public Adapter getAdapter() {
        return this.adapter;
    }

    public void setAdapter(Adapter adapter) {
        this.adapter = adapter;
    }

    public Request getRequest() {
        return this.request;
    }

    public void setRequest(Request request) {
        this.request = request;
    }

    public Response getResponse() {
        return this.response;
    }

    public void setResponse(Response response) {
        this.response = response;
    }

    public boolean isError() {
        return this.error;
    }

    public void setError(boolean error) {
        this.error = error;
    }

    public boolean isKeepAlive() {
        return this.keepAlive;
    }

    public void setKeepAlive(boolean keepAlive) {
        this.keepAlive = keepAlive;
    }

    public boolean isHttp11() {
        return this.http11;
    }

    public void setHttp11(boolean http11) {
        this.http11 = http11;
    }

    public boolean isHttp09() {
        return this.http09;
    }

    public void setHttp09(boolean http09) {
        this.http09 = http09;
    }

    public boolean isContentDelimitation() {
        return this.contentDelimitation;
    }

    public void setContentDelimitation(boolean contentDelimitation) {
        this.contentDelimitation = contentDelimitation;
    }

    public boolean isExpectation() {
        return this.expectation;
    }

    public void setExpectation(boolean expectation) {
        this.expectation = expectation;
    }

    public Pattern[] getRestrictedUserAgents() {
        return this.restrictedUserAgents;
    }

    public void setRestrictedUserAgents(Pattern[] restrictedUserAgents) {
        this.restrictedUserAgents = restrictedUserAgents;
    }

    public int getMaxKeepAliveRequests() {
        return this.maxKeepAliveRequests;
    }

    public void setMaxKeepAliveRequests(int maxKeepAliveRequests) {
        this.maxKeepAliveRequests = maxKeepAliveRequests;
    }

    public int getKeepAliveTimeout() {
        return this.keepAliveTimeout;
    }

    public void setKeepAliveTimeout(int keepAliveTimeout) {
        this.keepAliveTimeout = keepAliveTimeout;
    }

    public SSLSupport getSSLSupport() {
        return this.sslSupport;
    }

    public void setSSLSupport(SSLSupport sslSupport) {
        this.sslSupport = sslSupport;
    }

    public String getRemoteAddr() {
        return this.remoteAddr;
    }

    public void setRemoteAddr(String remoteAddr) {
        this.remoteAddr = remoteAddr;
    }

    public String getRemoteHost() {
        return this.remoteHost;
    }

    public void setRemoteHost(String remoteHost) {
        this.remoteHost = remoteHost;
    }

    public String getLocalName() {
        return this.localName;
    }

    public void setLocalName(String localName) {
        this.localName = localName;
    }

    public int getLocalPort() {
        return this.localPort;
    }

    public void setLocalPort(int localPort) {
        this.localPort = localPort;
    }

    public int getRemotePort() {
        return this.remotePort;
    }

    public void setRemotePort(int remotePort) {
        this.remotePort = remotePort;
    }

    public String getLocalAddr() {
        return this.localAddr;
    }

    public void setLocalAddr(String localAddr) {
        this.localAddr = localAddr;
    }

    public boolean getDisableUploadTimeout() {
        return this.disableUploadTimeout;
    }

    public void setDisableUploadTimeout(boolean disableUploadTimeout) {
        this.disableUploadTimeout = disableUploadTimeout;
    }

    public int getCompressionLevel() {
        return this.compressionLevel;
    }

    public void setCompressionLevel(int compressionLevel) {
        this.compressionLevel = compressionLevel;
    }

    public int getCompressionMinSize() {
        return this.compressionMinSize;
    }

    public void setCompressionMinSize(int compressionMinSize) {
        this.compressionMinSize = compressionMinSize;
    }

    public int getMaxSavePostSize() {
        return this.maxSavePostSize;
    }

    public void setMaxSavePostSize(int maxSavePostSize) {
        this.maxSavePostSize = maxSavePostSize;
    }

    public Pattern[] getNoCompressionUserAgents() {
        return this.noCompressionUserAgents;
    }

    public void setNoCompressionUserAgents(Pattern[] noCompressionUserAgents) {
        this.noCompressionUserAgents = noCompressionUserAgents;
    }

    public char[] getHostNameC() {
        return this.hostNameC;
    }

    public void setHostNameC(char[] hostNameC) {
        this.hostNameC = hostNameC;
    }

    public boolean isEvent() {
        return this.event;
    }

    public void setEvent(boolean event) {
        this.event = event;
    }

    public boolean getResumeNotification() {
        return this.resumeNotification;
    }

    public void setResumeNotification(boolean resumeNotification) {
        this.resumeNotification = resumeNotification;
    }

    public boolean getEventProcessing() {
        return this.eventProcessing;
    }

    public void setEventProcessing(boolean eventProcessing) {
        this.eventProcessing = eventProcessing;
    }

    public int getTimeout() {
        return this.timeout;
    }

    public void setTimeout(int timeout) {
        this.timeout = timeout;
    }

    public String[] getCompressableMimeTypes() {
        return this.compressableMimeTypes;
    }

    public String getServer() {
        return this.server;
    }

    public boolean getReadNotifications() {
        return this.readNotifications;
    }

    public void setReadNotifications(boolean readNotifications) {
        this.readNotifications = readNotifications;
    }

    public boolean getWriteNotification() {
        return this.writeNotification;
    }

    public void setWriteNotification(boolean writeNotification) {
        this.writeNotification = writeNotification;
    }

    public boolean getSSLEnabled() {
        return this.sslEnabled;
    }

    public void setSSLEnabled(boolean sslEnabled) {
        this.sslEnabled = sslEnabled;
    }
}

