/*
 * Decompiled with CFR 0.152.
 */
package org.apache.coyote.http11;

import java.io.EOFException;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.concurrent.TimeUnit;
import org.apache.coyote.InputBuffer;
import org.apache.coyote.Request;
import org.apache.coyote.http11.Constants;
import org.apache.coyote.http11.InputFilter;
import org.apache.tomcat.util.buf.MessageBytes;
import org.apache.tomcat.util.http.MimeHeaders;
import org.jboss.web.CoyoteMessages;

public abstract class AbstractInternalInputBuffer
implements InputBuffer {
    protected Request request;
    protected MimeHeaders headers;
    protected boolean parsingHeader;
    protected boolean swallowInput;
    protected byte[] buf;
    protected ByteBuffer bbuf;
    protected int lastValid;
    protected int pos;
    protected int end;
    protected InputFilter[] filterLibrary;
    protected InputFilter[] activeFilters;
    protected int lastActiveFilter;
    protected InputBuffer inputBuffer;
    protected int readTimeout = -1;
    protected static final TimeUnit unit = TimeUnit.MILLISECONDS;

    public AbstractInternalInputBuffer(Request request) {
        this(request, Constants.DEFAULT_HTTP_HEADER_BUFFER_SIZE);
    }

    public AbstractInternalInputBuffer(Request request, int headerBufferSize) {
        this.request = request;
        this.headers = request.getMimeHeaders();
        this.buf = new byte[headerBufferSize];
        this.filterLibrary = new InputFilter[0];
        this.activeFilters = new InputFilter[0];
        this.lastActiveFilter = -1;
        this.parsingHeader = true;
        this.swallowInput = true;
        this.bbuf = headerBufferSize < 8192 ? ByteBuffer.allocateDirect(9000) : ByteBuffer.allocateDirect((headerBufferSize / 1500 + 1) * 1500);
    }

    public InputFilter[] getFilters() {
        return this.filterLibrary;
    }

    public void setSwallowInput(boolean swallowInput) {
        this.swallowInput = swallowInput;
    }

    public void addFilter(InputFilter filter) {
        if (filter == null) {
            return;
        }
        InputFilter[] newFilterLibrary = new InputFilter[this.filterLibrary.length + 1];
        for (int i = 0; i < this.filterLibrary.length; ++i) {
            newFilterLibrary[i] = this.filterLibrary[i];
        }
        newFilterLibrary[this.filterLibrary.length] = filter;
        this.filterLibrary = newFilterLibrary;
        this.activeFilters = new InputFilter[this.filterLibrary.length];
    }

    public void clearFilters() {
        this.filterLibrary = new InputFilter[0];
        this.lastActiveFilter = -1;
    }

    public void addActiveFilter(InputFilter filter) {
        if (this.lastActiveFilter == -1) {
            filter.setBuffer(this.inputBuffer);
        } else {
            for (int i = 0; i <= this.lastActiveFilter; ++i) {
                if (this.activeFilters[i] != filter) continue;
                return;
            }
            filter.setBuffer(this.activeFilters[this.lastActiveFilter]);
        }
        this.activeFilters[++this.lastActiveFilter] = filter;
        filter.setRequest(this.request);
    }

    public void removeActiveFilters() {
        for (int i = 0; i <= this.lastActiveFilter; ++i) {
            this.activeFilters[i].recycle();
        }
        this.lastActiveFilter = -1;
    }

    public void recycle() {
        this.request.recycle();
        this.lastValid = 0;
        this.reset();
    }

    protected void reset() {
        this.pos = 0;
        this.lastActiveFilter = -1;
        this.parsingHeader = true;
        this.swallowInput = true;
    }

    public boolean nextRequest() {
        this.request.recycle();
        if (this.lastValid - this.pos > 0) {
            int npos = 0;
            int opos = this.pos;
            while (this.lastValid - opos > opos - npos) {
                System.arraycopy(this.buf, opos, this.buf, npos, opos - npos);
                npos += this.pos;
                opos += this.pos;
            }
            System.arraycopy(this.buf, opos, this.buf, npos, this.lastValid - opos);
        }
        for (int i = 0; i <= this.lastActiveFilter; ++i) {
            this.activeFilters[i].recycle();
        }
        this.lastValid -= this.pos;
        this.reset();
        return this.lastValid > 0;
    }

    public void endRequest() throws IOException {
        if (this.swallowInput && this.lastActiveFilter != -1) {
            int extraBytes = (int)this.activeFilters[this.lastActiveFilter].end();
            this.pos -= extraBytes;
        }
    }

    public void parseRequestLine() throws IOException {
        int start = 0;
        byte chr = 0;
        do {
            if (this.pos < this.lastValid || this.fill()) continue;
            throw new EOFException(CoyoteMessages.MESSAGES.eofError());
        } while ((chr = this.buf[this.pos++]) == 13 || chr == 10);
        --this.pos;
        start = this.pos;
        boolean space = false;
        while (!space) {
            if (this.pos >= this.lastValid && !this.fill()) {
                throw new EOFException(CoyoteMessages.MESSAGES.eofError());
            }
            if (this.buf[this.pos] == 32 || this.buf[this.pos] == 9) {
                space = true;
                this.request.method().setBytes(this.buf, start, this.pos - start);
            }
            ++this.pos;
        }
        while (space) {
            if (this.pos >= this.lastValid && !this.fill()) {
                throw new EOFException(CoyoteMessages.MESSAGES.eofError());
            }
            if (this.buf[this.pos] == 32 || this.buf[this.pos] == 9) {
                ++this.pos;
                continue;
            }
            space = false;
        }
        start = this.pos;
        int end = 0;
        int questionPos = -1;
        boolean eol = false;
        while (!space) {
            if (this.pos >= this.lastValid && !this.fill()) {
                throw new EOFException(CoyoteMessages.MESSAGES.eofError());
            }
            if (this.buf[this.pos] == 32 || this.buf[this.pos] == 9) {
                space = true;
                end = this.pos;
            } else if (this.buf[this.pos] == 13 || this.buf[this.pos] == 10) {
                eol = true;
                space = true;
                end = this.pos;
            } else if (this.buf[this.pos] == 63 && questionPos == -1) {
                questionPos = this.pos;
            }
            ++this.pos;
        }
        this.request.unparsedURI().setBytes(this.buf, start, end - start);
        if (questionPos >= 0) {
            this.request.queryString().setBytes(this.buf, questionPos + 1, end - questionPos - 1);
            this.request.requestURI().setBytes(this.buf, start, questionPos - start);
        } else {
            this.request.requestURI().setBytes(this.buf, start, end - start);
        }
        while (space) {
            if (this.pos >= this.lastValid && !this.fill()) {
                throw new EOFException(CoyoteMessages.MESSAGES.eofError());
            }
            if (this.buf[this.pos] == 32 || this.buf[this.pos] == 9) {
                ++this.pos;
                continue;
            }
            space = false;
        }
        start = this.pos;
        end = 0;
        while (!eol) {
            if (this.pos >= this.lastValid && !this.fill()) {
                throw new EOFException(CoyoteMessages.MESSAGES.eofError());
            }
            if (this.buf[this.pos] == 13) {
                end = this.pos;
            } else if (this.buf[this.pos] == 10) {
                if (end == 0) {
                    end = this.pos;
                }
                eol = true;
            }
            ++this.pos;
        }
        if (end - start > 0) {
            this.request.protocol().setBytes(this.buf, start, end - start);
        } else {
            this.request.protocol().setString("");
        }
    }

    public void parseHeaders() throws IOException {
        while (this.parseHeader()) {
        }
        this.parsingHeader = false;
        this.end = this.pos;
    }

    public boolean parseHeader() throws IOException {
        byte chr = 0;
        while (true) {
            if (this.pos >= this.lastValid && !this.fill()) {
                throw new EOFException(CoyoteMessages.MESSAGES.eofError());
            }
            chr = this.buf[this.pos];
            if (chr != 13 && chr != 10) break;
            if (chr == 10) {
                ++this.pos;
                return false;
            }
            ++this.pos;
        }
        int start = this.pos;
        boolean colon = false;
        MessageBytes headerValue = null;
        while (!colon) {
            if (this.pos >= this.lastValid && !this.fill()) {
                throw new EOFException(CoyoteMessages.MESSAGES.eofError());
            }
            if (this.buf[this.pos] == 58) {
                colon = true;
                headerValue = this.headers.addValue(this.buf, start, this.pos - start);
            }
            if ((chr = this.buf[this.pos]) >= 65 && chr <= 90) {
                this.buf[this.pos] = (byte)(chr - -32);
            }
            ++this.pos;
        }
        start = this.pos;
        int realPos = this.pos;
        boolean eol = false;
        boolean validLine = true;
        while (validLine) {
            boolean space = true;
            while (space) {
                if (this.pos >= this.lastValid && !this.fill()) {
                    throw new EOFException(CoyoteMessages.MESSAGES.eofError());
                }
                if (this.buf[this.pos] == 32 || this.buf[this.pos] == 9) {
                    ++this.pos;
                    continue;
                }
                space = false;
            }
            int lastSignificantChar = realPos;
            while (!eol) {
                if (this.pos >= this.lastValid && !this.fill()) {
                    throw new EOFException(CoyoteMessages.MESSAGES.eofError());
                }
                if (this.buf[this.pos] != 13) {
                    if (this.buf[this.pos] == 10) {
                        eol = true;
                    } else if (this.buf[this.pos] == 32) {
                        this.buf[realPos] = this.buf[this.pos];
                        ++realPos;
                    } else {
                        this.buf[realPos] = this.buf[this.pos];
                        lastSignificantChar = ++realPos;
                    }
                }
                ++this.pos;
            }
            realPos = lastSignificantChar;
            if (this.pos >= this.lastValid && !this.fill()) {
                throw new EOFException(CoyoteMessages.MESSAGES.eofError());
            }
            chr = this.buf[this.pos];
            if (chr != 32 && chr != 9) {
                validLine = false;
                continue;
            }
            eol = false;
            this.buf[realPos] = chr;
            ++realPos;
        }
        headerValue.setBytes(this.buf, start, realPos - start);
        return true;
    }

    protected abstract boolean fill() throws IOException;
}

