/*
 * Decompiled with CFR 0.152.
 */
package org.apache.coyote.http11;

import java.io.IOException;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.CompletionHandler;
import java.nio.channels.WritePendingException;
import java.util.concurrent.TimeUnit;
import org.apache.coyote.ActionCode;
import org.apache.coyote.Response;
import org.apache.coyote.http11.AbstractInternalOutputBuffer;
import org.apache.coyote.http11.Constants;
import org.apache.coyote.http11.Http11NioProcessor;
import org.apache.tomcat.util.buf.ByteChunk;
import org.apache.tomcat.util.net.NioChannel;
import org.apache.tomcat.util.net.NioEndpoint;
import org.jboss.web.CoyoteLogger;
import org.jboss.web.CoyoteMessages;

public class InternalNioOutputBuffer
extends AbstractInternalOutputBuffer {
    protected NioChannel channel;
    protected NioEndpoint endpoint;
    private CompletionHandler<Integer, NioChannel> completionHandler;

    public InternalNioOutputBuffer(Response response, int headerBufferSize, NioEndpoint endpoint) {
        super(response, headerBufferSize);
        this.endpoint = endpoint;
        this.init();
    }

    @Override
    protected void init() {
        this.writeTimeout = this.endpoint.getSoTimeout() > 0 ? this.endpoint.getSoTimeout() : Integer.MAX_VALUE;
        this.completionHandler = new CompletionHandler<Integer, NioChannel>(){

            @Override
            public void completed(Integer nBytes, NioChannel attachment) {
                if (nBytes < 0) {
                    this.failed((Throwable)new ClosedChannelException(), attachment);
                    return;
                }
                InternalNioOutputBuffer.this.response.setLastWrite(nBytes);
                if (InternalNioOutputBuffer.this.bbuf.hasRemaining()) {
                    try {
                        attachment.write(InternalNioOutputBuffer.this.bbuf, InternalNioOutputBuffer.this.writeTimeout, TimeUnit.MILLISECONDS, attachment, this);
                    }
                    catch (WritePendingException e) {
                        InternalNioOutputBuffer.this.response.setLastWrite(0);
                    }
                } else {
                    InternalNioOutputBuffer.this.clearBuffer();
                }
            }

            @Override
            public void failed(Throwable exc, NioChannel attachment) {
                InternalNioOutputBuffer.this.endpoint.removeEventChannel(attachment);
            }
        };
    }

    public void setChannel(NioChannel channel) {
        this.channel = channel;
    }

    public NioChannel getChannel() {
        return this.channel;
    }

    @Override
    public void recycle() {
        super.recycle();
        this.channel = null;
    }

    private void close(NioChannel channel) {
        this.endpoint.closeChannel(channel);
    }

    private int blockingWrite(long timeout, TimeUnit unit) {
        int nw;
        block3: {
            nw = 0;
            try {
                nw = this.channel.writeBytes(this.bbuf, timeout, unit);
                if (nw < 0) {
                    this.close(this.channel);
                }
            }
            catch (Throwable t) {
                if (!CoyoteLogger.HTTP_LOGGER.isDebugEnabled()) break block3;
                CoyoteLogger.HTTP_LOGGER.errorWithBlockingWrite(t);
            }
        }
        return nw;
    }

    private void nonBlockingWrite(long timeout, TimeUnit unit) {
        block2: {
            try {
                this.channel.write(this.bbuf, timeout, unit, this.channel, this.completionHandler);
            }
            catch (Throwable t) {
                if (!CoyoteLogger.HTTP_LOGGER.isDebugEnabled()) break block2;
                CoyoteLogger.HTTP_LOGGER.errorWithNonBlockingWrite(t);
            }
        }
    }

    @Override
    protected int write(long timeout, TimeUnit unit) {
        if (this.nonBlocking) {
            this.nonBlockingWrite(timeout, unit);
            return 0;
        }
        return this.blockingWrite(timeout, unit);
    }

    @Override
    public void sendAck() throws Exception {
        if (!this.committed) {
            this.bbuf.clear();
            this.bbuf.put(Constants.ACK_BYTES).flip();
            if (this.write(this.writeTimeout, TimeUnit.MILLISECONDS) < 0) {
                throw new IOException(CoyoteMessages.MESSAGES.failedWrite());
            }
        }
    }

    @Override
    public int doWrite(ByteChunk chunk, Response res) throws IOException {
        if (!this.committed) {
            this.response.action(ActionCode.ACTION_COMMIT, null);
        }
        if (this.leftover.getLength() > 0 && Http11NioProcessor.containerThread.get() != Boolean.TRUE) {
            throw new IOException(CoyoteMessages.MESSAGES.invalidBacklog());
        }
        if (this.lastActiveFilter == -1) {
            return this.outputBuffer.doWrite(chunk, res);
        }
        return this.activeFilters[this.lastActiveFilter].doWrite(chunk, res);
    }

    @Override
    protected void flushBuffer() throws IOException {
        int res = 0;
        if (this.leftover.getLength() > 0) {
            if (Http11NioProcessor.containerThread.get() == Boolean.TRUE) {
                while (this.leftover.getLength() > 0) {
                    int n = Math.min(this.bbuf.capacity() - this.bbuf.position(), this.leftover.getLength());
                    int off = this.leftover.getOffset();
                    this.bbuf.put(this.leftover.getBuffer(), off, n).flip();
                    this.leftover.setOffset(off + n);
                    while (this.bbuf.hasRemaining() && (res = this.blockingWrite(this.writeTimeout, TimeUnit.MILLISECONDS)) >= 0) {
                    }
                    this.bbuf.clear();
                    if (res >= 0) continue;
                    throw new IOException(CoyoteMessages.MESSAGES.failedWrite());
                }
                this.leftover.recycle();
            } else {
                throw new IOException(CoyoteMessages.MESSAGES.invalidBacklog());
            }
        }
        if (this.bbuf.position() > 0) {
            this.bbuf.flip();
            if (this.nonBlocking) {
                this.nonBlockingWrite(this.writeTimeout, TimeUnit.MILLISECONDS);
            } else {
                while (this.bbuf.hasRemaining() && (res = this.blockingWrite(this.writeTimeout, TimeUnit.MILLISECONDS)) > 0) {
                }
                this.response.setLastWrite(res);
                this.clearBuffer();
            }
            if (res < 0) {
                throw new IOException(CoyoteMessages.MESSAGES.failedWrite());
            }
        }
    }

    @Override
    public boolean flushLeftover() throws IOException {
        int n = Math.min(this.leftover.getLength(), this.bbuf.capacity() - this.bbuf.position());
        this.bbuf.put(this.leftover.getBuffer(), this.leftover.getOffset(), n).flip();
        this.leftover.setOffset(this.leftover.getOffset() + n);
        final NioChannel ch = this.channel;
        ch.write(this.bbuf, this.writeTimeout, TimeUnit.MILLISECONDS, null, new CompletionHandler<Integer, Void>(){

            @Override
            public void completed(Integer result, Void attachment) {
                if (result < 0) {
                    this.failed((Throwable)new IOException(CoyoteMessages.MESSAGES.failedWrite()), attachment);
                    return;
                }
                InternalNioOutputBuffer.this.response.setLastWrite(result);
                if (!InternalNioOutputBuffer.this.bbuf.hasRemaining()) {
                    InternalNioOutputBuffer.this.bbuf.clear();
                    if (InternalNioOutputBuffer.this.leftover.getLength() > 0) {
                        int n = Math.min(InternalNioOutputBuffer.this.leftover.getLength(), InternalNioOutputBuffer.this.bbuf.remaining());
                        InternalNioOutputBuffer.this.bbuf.put(InternalNioOutputBuffer.this.leftover.getBuffer(), InternalNioOutputBuffer.this.leftover.getOffset(), n).flip();
                        InternalNioOutputBuffer.this.leftover.setOffset(InternalNioOutputBuffer.this.leftover.getOffset() + n);
                    } else {
                        InternalNioOutputBuffer.this.leftover.recycle();
                        return;
                    }
                }
                ch.write(InternalNioOutputBuffer.this.bbuf, InternalNioOutputBuffer.this.writeTimeout, TimeUnit.MILLISECONDS, null, this);
            }

            @Override
            public void failed(Throwable exc, Void attachment) {
                InternalNioOutputBuffer.this.close(ch);
            }
        });
        return true;
    }
}

