/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.util.net;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.net.SocketOption;
import java.nio.ByteBuffer;
import java.nio.channels.AsynchronousByteChannel;
import java.nio.channels.AsynchronousChannelGroup;
import java.nio.channels.AsynchronousSocketChannel;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.CompletionHandler;
import java.nio.channels.NetworkChannel;
import java.nio.channels.spi.AsynchronousChannelProvider;
import java.util.Set;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicLong;

public class NioChannel
implements AsynchronousByteChannel,
NetworkChannel {
    public static final int OP_STATUS_NORMAL = 0;
    public static final int OP_STATUS_CLOSED = -1;
    public static final int OP_STATUS_READ_TIMEOUT = -2;
    public static final int OP_STATUS_WRITE_TIMEOUT = -3;
    public static final int OP_STATUS_READ_KILLED = -4;
    public static final int OP_STATUS_WRITE_KILLED = -5;
    public static final int OP_STATUS_ERROR = -17;
    private static final AtomicLong counter = new AtomicLong(0L);
    protected AsynchronousSocketChannel channel;
    private long id;
    private ByteBuffer buffer;

    protected NioChannel(AsynchronousSocketChannel channel) {
        if (channel == null) {
            throw new NullPointerException("null channel parameter");
        }
        this.channel = channel;
        this.id = counter.getAndIncrement();
        this.buffer = ByteBuffer.allocateDirect(1);
    }

    public static NioChannel open(AsynchronousChannelGroup group) throws IOException {
        AsynchronousSocketChannel channel = AsynchronousSocketChannel.open(group);
        return new NioChannel(channel);
    }

    public static NioChannel open() throws IOException {
        return NioChannel.open(null);
    }

    @Override
    public NioChannel bind(SocketAddress local) throws IOException {
        this.channel.bind(local);
        return this;
    }

    public NioChannel bind(String hostname, int port) throws IOException {
        return this.bind(new InetSocketAddress(hostname, port));
    }

    public <A> void connect(SocketAddress remote, A attachment, CompletionHandler<Void, ? super A> handler) {
        this.channel.connect(remote, attachment, handler);
    }

    public Future<Void> connect(SocketAddress remote) {
        return this.channel.connect(remote);
    }

    protected void reset() {
        this.buffer.clear();
    }

    protected int reset(ByteBuffer dst) {
        this.buffer.flip();
        int x = this.buffer.remaining();
        dst.put(this.buffer);
        this.buffer.clear();
        return x;
    }

    public boolean isSecure() {
        return false;
    }

    protected ByteBuffer getBuffer() {
        return this.buffer;
    }

    public long getId() {
        return this.id;
    }

    public String getName() {
        return this.getClass().getName() + "[" + this.getId() + "]";
    }

    public final AsynchronousChannelProvider provider() {
        return this.channel.provider();
    }

    @Override
    public boolean isOpen() {
        return this.channel.isOpen();
    }

    public boolean isClosed() {
        return !this.isOpen();
    }

    @Override
    public synchronized void close() throws IOException {
        if (this.isClosed()) {
            return;
        }
        this.channel.close();
    }

    public void close(boolean force) throws IOException {
        if (this.isOpen() && force) {
            this.close();
        }
    }

    @Override
    @Deprecated
    public Future<Integer> read(ByteBuffer dst) {
        this.reset(dst);
        return this.channel.read(dst);
    }

    public int readBytes(ByteBuffer dst) throws Exception {
        return this.readBytes(dst, Integer.MAX_VALUE, TimeUnit.MILLISECONDS);
    }

    public int readBytes(ByteBuffer dst, long timeout, TimeUnit unit) throws Exception {
        try {
            int x = this.reset(dst);
            return x + this.channel.read(dst).get(timeout, unit);
        }
        catch (Exception exp) {
            if (exp instanceof ClosedChannelException) {
                return -1;
            }
            if (exp instanceof TimeoutException) {
                return -2;
            }
            throw exp;
        }
    }

    @Override
    public <A> void read(ByteBuffer dst, A attachment, CompletionHandler<Integer, ? super A> handler) {
        this.read(dst, 0L, TimeUnit.MILLISECONDS, attachment, handler);
    }

    public <A> void read(ByteBuffer dst, long timeout, TimeUnit unit, A attachment, final CompletionHandler<Integer, ? super A> handler) {
        final int x = this.reset(dst);
        this.channel.read(dst, timeout, unit, attachment, new CompletionHandler<Integer, A>(){

            @Override
            public void completed(Integer result, A attach) {
                handler.completed(result + x, attach);
            }

            @Override
            public void failed(Throwable exc, A attach) {
                handler.failed(exc, attach);
            }
        });
    }

    public <A> void read(ByteBuffer[] dsts, int offset, int length, long timeout, TimeUnit unit, A attachment, final CompletionHandler<Long, ? super A> handler) {
        final int x = this.reset(dsts[0]);
        this.channel.read(dsts, offset, length, timeout, unit, attachment, new CompletionHandler<Long, A>(){

            @Override
            public void completed(Long result, A attach) {
                handler.completed(result + (long)x, attach);
            }

            @Override
            public void failed(Throwable exc, A attach) {
                handler.failed(exc, attach);
            }
        });
    }

    public <A> void awaitRead(long timeout, TimeUnit unit, A attachment, CompletionHandler<Integer, ? super A> handler) {
        this.buffer.clear();
        this.channel.read(this.buffer, timeout, unit, attachment, handler);
    }

    public <A> void awaitRead(A attachment, CompletionHandler<Integer, ? super A> handler) {
        this.awaitRead(0L, TimeUnit.MILLISECONDS, attachment, handler);
    }

    @Override
    @Deprecated
    public Future<Integer> write(ByteBuffer src) {
        return this.channel.write(src);
    }

    public int writeBytes(ByteBuffer src) throws Exception {
        return this.writeBytes(src, Integer.MAX_VALUE, TimeUnit.MILLISECONDS);
    }

    public int writeBytes(ByteBuffer src, long timeout, TimeUnit unit) throws Exception {
        return this.channel.write(src).get(timeout, unit);
    }

    @Override
    public <A> void write(ByteBuffer src, A attachment, CompletionHandler<Integer, ? super A> handler) {
        this.write(src, 0L, TimeUnit.MILLISECONDS, attachment, handler);
    }

    public <A> void write(ByteBuffer src, long timeout, TimeUnit unit, A attachment, CompletionHandler<Integer, ? super A> handler) {
        this.channel.write(src, timeout, unit, attachment, handler);
    }

    public <A> void write(ByteBuffer[] srcs, int offset, int length, long timeout, TimeUnit unit, A attachment, CompletionHandler<Long, ? super A> handler) {
        this.channel.write(srcs, offset, length, timeout, unit, attachment, handler);
    }

    @Override
    public SocketAddress getLocalAddress() throws IOException {
        return this.channel.getLocalAddress();
    }

    public SocketAddress getRemoteAddress() throws IOException {
        return this.channel.getRemoteAddress();
    }

    public final NioChannel shutdownInput() throws IOException {
        this.channel.shutdownInput();
        return this;
    }

    public final NioChannel shutdownOutput() throws IOException {
        this.channel.shutdownOutput();
        return this;
    }

    @Override
    public <T> NioChannel setOption(SocketOption<T> name, T value) throws IOException {
        this.channel.setOption((SocketOption)name, (Object)value);
        return this;
    }

    @Override
    public <T> T getOption(SocketOption<T> name) throws IOException {
        return this.channel.getOption(name);
    }

    @Override
    public Set<SocketOption<?>> supportedOptions() {
        return this.channel.supportedOptions();
    }

    public String toString() {
        return this.getName();
    }
}

