/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.util.http;

import java.io.Serializable;
import java.text.DateFormat;
import java.text.FieldPosition;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import java.util.TimeZone;
import org.apache.tomcat.util.buf.MessageBytes;
import org.apache.tomcat.util.http.CookieSupport;
import org.jboss.web.CoyoteMessages;

public class ServerCookie
implements Serializable {
    private static final long serialVersionUID = 1L;
    private MessageBytes name = MessageBytes.newInstance();
    private MessageBytes value = MessageBytes.newInstance();
    private MessageBytes path = MessageBytes.newInstance();
    private MessageBytes domain = MessageBytes.newInstance();
    private boolean secure;
    private MessageBytes comment = MessageBytes.newInstance();
    private int maxAge = -1;
    private int version = 0;
    private static final String OLD_COOKIE_PATTERN = "EEE, dd-MMM-yyyy HH:mm:ss z";
    private static final ThreadLocal<DateFormat> OLD_COOKIE_FORMAT = new ThreadLocal<DateFormat>(){

        @Override
        protected DateFormat initialValue() {
            SimpleDateFormat df = new SimpleDateFormat(ServerCookie.OLD_COOKIE_PATTERN, Locale.US);
            df.setTimeZone(TimeZone.getTimeZone("GMT"));
            return df;
        }
    };
    private static final String ancientDate = OLD_COOKIE_FORMAT.get().format(new Date(10000L));

    public void recycle() {
        this.path.recycle();
        this.name.recycle();
        this.value.recycle();
        this.comment.recycle();
        this.maxAge = -1;
        this.path.recycle();
        this.domain.recycle();
        this.version = 0;
        this.secure = false;
    }

    public MessageBytes getComment() {
        return this.comment;
    }

    public MessageBytes getDomain() {
        return this.domain;
    }

    public void setMaxAge(int expiry) {
        this.maxAge = expiry;
    }

    public int getMaxAge() {
        return this.maxAge;
    }

    public MessageBytes getPath() {
        return this.path;
    }

    public void setSecure(boolean flag) {
        this.secure = flag;
    }

    public boolean getSecure() {
        return this.secure;
    }

    public MessageBytes getName() {
        return this.name;
    }

    public MessageBytes getValue() {
        return this.value;
    }

    public int getVersion() {
        return this.version;
    }

    public void setVersion(int v) {
        this.version = v;
    }

    public String toString() {
        return "Cookie " + this.getName() + "=" + this.getValue() + " ; " + this.getVersion() + " " + this.getPath() + " " + this.getDomain();
    }

    public static void appendCookieValue(StringBuffer headerBuf, int version, String name, String value, String path, String domain, String comment, int maxAge, boolean isSecure, boolean isHttpOnly) {
        StringBuffer buf = new StringBuffer();
        buf.append(name);
        buf.append("=");
        int newVersion = version;
        if (newVersion == 0 && (!CookieSupport.ALLOW_HTTP_SEPARATORS_IN_V0 && CookieSupport.isHttpToken(value) || CookieSupport.ALLOW_HTTP_SEPARATORS_IN_V0 && CookieSupport.isV0Token(value))) {
            newVersion = 1;
        }
        if (newVersion == 0 && comment != null) {
            newVersion = 1;
        }
        if (newVersion == 0 && (!CookieSupport.ALLOW_HTTP_SEPARATORS_IN_V0 && CookieSupport.isHttpToken(path) || CookieSupport.ALLOW_HTTP_SEPARATORS_IN_V0 && CookieSupport.isV0Token(path))) {
            newVersion = 1;
        }
        if (newVersion == 0 && (!CookieSupport.ALLOW_HTTP_SEPARATORS_IN_V0 && CookieSupport.isHttpToken(domain) || CookieSupport.ALLOW_HTTP_SEPARATORS_IN_V0 && CookieSupport.isV0Token(domain))) {
            newVersion = 1;
        }
        ServerCookie.maybeQuote(buf, value);
        if (newVersion == 1) {
            buf.append("; Version=1");
            if (comment != null) {
                buf.append("; Comment=");
                ServerCookie.maybeQuote(buf, comment);
            }
        }
        if (domain != null) {
            buf.append("; Domain=");
            ServerCookie.maybeQuote(buf, domain);
        }
        if (maxAge >= 0) {
            if (newVersion > 0) {
                buf.append("; Max-Age=");
                buf.append(maxAge);
            }
            if (newVersion == 0 || CookieSupport.ALWAYS_ADD_EXPIRES) {
                buf.append("; Expires=");
                if (maxAge == 0) {
                    buf.append(ancientDate);
                } else {
                    OLD_COOKIE_FORMAT.get().format(new Date(System.currentTimeMillis() + (long)maxAge * 1000L), buf, new FieldPosition(0));
                }
            }
        }
        if (path != null) {
            buf.append("; Path=");
            ServerCookie.maybeQuote(buf, path);
        }
        if (isSecure) {
            buf.append("; Secure");
        }
        if (isHttpOnly) {
            buf.append("; HttpOnly");
        }
        headerBuf.append(buf);
    }

    private static void maybeQuote(StringBuffer buf, String value) {
        if (value == null || value.length() == 0) {
            buf.append("\"\"");
        } else if (CookieSupport.alreadyQuoted(value)) {
            buf.append('\"');
            buf.append(ServerCookie.escapeDoubleQuotes(value, 1, value.length() - 1));
            buf.append('\"');
        } else if (CookieSupport.isHttpToken(value) && !CookieSupport.ALLOW_HTTP_SEPARATORS_IN_V0 || CookieSupport.isV0Token(value) && CookieSupport.ALLOW_HTTP_SEPARATORS_IN_V0) {
            buf.append('\"');
            buf.append(ServerCookie.escapeDoubleQuotes(value, 0, value.length()));
            buf.append('\"');
        } else {
            buf.append(value);
        }
    }

    private static String escapeDoubleQuotes(String s, int beginIndex, int endIndex) {
        if (s == null || s.length() == 0 || s.indexOf(34) == -1) {
            return s;
        }
        StringBuffer b = new StringBuffer();
        for (int i = beginIndex; i < endIndex; ++i) {
            char c = s.charAt(i);
            if (c == '\\') {
                b.append(c);
                if (++i >= endIndex) {
                    throw CoyoteMessages.MESSAGES.invalidEscapeCharacter();
                }
                b.append(s.charAt(i));
                continue;
            }
            if (c == '\"') {
                b.append('\\').append('\"');
                continue;
            }
            b.append(c);
        }
        return b.toString();
    }
}

