/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.websocket;

import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import javax.websocket.SendHandler;
import javax.websocket.SendResult;
import org.apache.coyote.http11.Http11AbstractProcessor;
import org.apache.tomcat.websocket.WsSession;

class FutureToSendHandler
implements Future<Void>,
SendHandler {
    private final CountDownLatch latch = new CountDownLatch(1);
    private final WsSession wsSession;
    private volatile SendResult result = null;

    public FutureToSendHandler(WsSession wsSession) {
        this.wsSession = wsSession;
    }

    @Override
    public void onResult(SendResult result) {
        this.result = result;
        this.latch.countDown();
    }

    @Override
    public boolean cancel(boolean mayInterruptIfRunning) {
        return false;
    }

    @Override
    public boolean isCancelled() {
        return false;
    }

    @Override
    public boolean isDone() {
        return this.latch.getCount() == 0L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Void get() throws InterruptedException, ExecutionException {
        try {
            this.wsSession.registerFuture(this);
            if (this.latch.getCount() > 0L && Http11AbstractProcessor.containerThread.get() == Boolean.TRUE) {
                this.wsSession.writeBlock();
            }
            this.latch.await();
        }
        finally {
            this.wsSession.unregisterFuture(this);
        }
        if (this.result.getException() != null) {
            throw new ExecutionException(this.result.getException());
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Void get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
        boolean retval = false;
        try {
            this.wsSession.registerFuture(this);
            if (this.latch.getCount() > 0L && Http11AbstractProcessor.containerThread.get() == Boolean.TRUE) {
                long nanoTime = System.nanoTime();
                this.wsSession.writeBlock();
                timeout = TimeUnit.NANOSECONDS.convert(timeout, unit) - (System.nanoTime() - nanoTime);
                unit = TimeUnit.NANOSECONDS;
            }
            retval = this.latch.await(timeout, unit);
        }
        finally {
            this.wsSession.unregisterFuture(this);
        }
        if (!retval) {
            throw new TimeoutException();
        }
        if (this.result.getException() != null) {
            throw new ExecutionException(this.result.getException());
        }
        return null;
    }
}

