/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.util.http;

import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Locale;
import java.util.StringTokenizer;
import java.util.Vector;

public class AcceptLanguage {
    public static Locale getLocale(String acceptLanguage) {
        if (acceptLanguage == null) {
            return Locale.getDefault();
        }
        Hashtable languages = new Hashtable();
        Vector quality = new Vector();
        AcceptLanguage.processAcceptLanguage(acceptLanguage, languages, quality);
        if (languages.size() == 0) {
            return Locale.getDefault();
        }
        Vector l = new Vector();
        AcceptLanguage.extractLocales(languages, quality, l);
        return (Locale)l.elementAt(0);
    }

    public static Enumeration getLocales(String acceptLanguage) {
        if (acceptLanguage == null) {
            Vector<Locale> v = new Vector<Locale>();
            v.addElement(Locale.getDefault());
            return v.elements();
        }
        Hashtable languages = new Hashtable();
        Vector quality = new Vector();
        AcceptLanguage.processAcceptLanguage(acceptLanguage, languages, quality);
        if (languages.size() == 0) {
            Vector<Locale> v = new Vector<Locale>();
            v.addElement(Locale.getDefault());
            return v.elements();
        }
        Vector l = new Vector();
        AcceptLanguage.extractLocales(languages, quality, l);
        return l.elements();
    }

    private static void processAcceptLanguage(String acceptLanguage, Hashtable languages, Vector q) {
        StringTokenizer languageTokenizer = new StringTokenizer(acceptLanguage, ",");
        while (languageTokenizer.hasMoreTokens()) {
            Vector v;
            String language = languageTokenizer.nextToken().trim();
            int qValueIndex = language.indexOf(59);
            int qIndex = language.indexOf(113);
            int equalIndex = language.indexOf(61);
            Double qValue = new Double(1.0);
            if (qValueIndex > -1 && qValueIndex < qIndex && qIndex < equalIndex) {
                String qValueStr = language.substring(qValueIndex + 1);
                language = language.substring(0, qValueIndex);
                qValueStr = qValueStr.trim().toLowerCase(Locale.ENGLISH);
                qValueIndex = qValueStr.indexOf(61);
                qValue = new Double(0.0);
                if (qValueStr.startsWith("q") && qValueIndex > -1) {
                    qValueStr = qValueStr.substring(qValueIndex + 1);
                    try {
                        qValue = new Double(qValueStr.trim());
                    }
                    catch (NumberFormatException nfe) {
                        // empty catch block
                    }
                }
            }
            if (language.equals("*")) continue;
            String key = qValue.toString();
            if (languages.containsKey(key)) {
                v = (Vector)languages.get(key);
            } else {
                v = new Vector();
                q.addElement(qValue);
            }
            v.addElement(language);
            languages.put(key, v);
        }
    }

    private static void extractLocales(Hashtable languages, Vector q, Vector l) {
        Enumeration e = q.elements();
        while (e.hasMoreElements()) {
            Vector v = (Vector)languages.get(((Double)e.nextElement()).toString());
            Enumeration le = v.elements();
            while (le.hasMoreElements()) {
                String language = (String)le.nextElement();
                String country = "";
                int countryIndex = language.indexOf("-");
                if (countryIndex > -1) {
                    country = language.substring(countryIndex + 1).trim();
                    language = language.substring(0, countryIndex).trim();
                }
                l.addElement(new Locale(language, country));
            }
        }
    }
}

