/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.connector;

import java.io.IOException;
import javax.servlet.AsyncContext;
import javax.servlet.AsyncEvent;
import javax.servlet.AsyncListener;
import javax.servlet.SessionTrackingMode;
import org.apache.catalina.Context;
import org.apache.catalina.Host;
import org.apache.catalina.Manager;
import org.apache.catalina.Session;
import org.apache.catalina.Wrapper;
import org.apache.catalina.connector.Connector;
import org.apache.catalina.connector.CoyotePrincipal;
import org.apache.catalina.connector.Request;
import org.apache.catalina.connector.Response;
import org.apache.catalina.util.URLEncoder;
import org.apache.coyote.ActionCode;
import org.apache.coyote.Adapter;
import org.apache.tomcat.util.buf.B2CConverter;
import org.apache.tomcat.util.buf.ByteChunk;
import org.apache.tomcat.util.buf.CharChunk;
import org.apache.tomcat.util.buf.MessageBytes;
import org.apache.tomcat.util.http.Cookies;
import org.apache.tomcat.util.http.ServerCookie;
import org.apache.tomcat.util.net.SocketStatus;
import org.jboss.servlet.http.HttpEvent;
import org.jboss.web.CatalinaLogger;

public class CoyoteAdapter
implements Adapter {
    public static final int ADAPTER_NOTES = 1;
    protected static final boolean ALLOW_BACKSLASH = Boolean.valueOf(System.getProperty("org.apache.catalina.connector.CoyoteAdapter.ALLOW_BACKSLASH", "false"));
    protected static final String X_POWERED_BY = System.getProperty("org.apache.catalina.connector.CoyoteAdapter.X_POWERED_BY", "Servlet/3.0; JBossWeb-3");
    private Connector connector = null;
    protected static URLEncoder urlEncoder = new URLEncoder();

    public CoyoteAdapter(Connector connector) {
        this.connector = connector;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean event(org.apache.coyote.Request req, org.apache.coyote.Response res, SocketStatus status) {
        Request request = (Request)req.getNote(1);
        Response response = (Response)res.getNote(1);
        if (request.getWrapper() != null) {
            boolean error = false;
            boolean read = false;
            boolean eof = false;
            boolean close = false;
            try {
                if (response.isClosed()) {
                    request.getEvent().setType(HttpEvent.EventType.END);
                    request.setEventMode(false);
                    close = true;
                }
                switch (status) {
                    case OPEN_READ: {
                        if (!request.isEventMode()) {
                            request.getEvent().setType(HttpEvent.EventType.END);
                            close = true;
                            break;
                        }
                        try {
                            int n = request.read();
                            if (n > 0) {
                                read = true;
                            } else if (n < 0) {
                                eof = true;
                            }
                        }
                        catch (IOException e) {
                            error = true;
                        }
                        if (read) {
                            request.getEvent().setType(HttpEvent.EventType.READ);
                            break;
                        }
                        if (error) {
                            request.getEvent().setType(HttpEvent.EventType.ERROR);
                            break;
                        }
                        if (eof) {
                            request.getEvent().setType(HttpEvent.EventType.EOF);
                            break;
                        }
                        boolean e = true;
                        return e;
                    }
                    case OPEN_WRITE: {
                        if (!request.isEventMode()) {
                            request.getEvent().setType(HttpEvent.EventType.END);
                            close = true;
                            break;
                        }
                        request.getEvent().setType(HttpEvent.EventType.WRITE);
                        break;
                    }
                    case OPEN_CALLBACK: {
                        if (!request.isEventMode()) {
                            request.getEvent().setType(HttpEvent.EventType.END);
                            close = true;
                            break;
                        }
                        request.getEvent().setType(HttpEvent.EventType.EVENT);
                        break;
                    }
                    case DISCONNECT: 
                    case ERROR: {
                        request.getEvent().setType(HttpEvent.EventType.ERROR);
                        error = true;
                        break;
                    }
                    case STOP: {
                        request.getEvent().setType(HttpEvent.EventType.END);
                        close = true;
                        break;
                    }
                    case TIMEOUT: {
                        if (!request.isEventMode()) {
                            request.getEvent().setType(HttpEvent.EventType.END);
                            close = true;
                            break;
                        }
                        request.getEvent().setType(HttpEvent.EventType.TIMEOUT);
                    }
                }
                req.getRequestProcessor().setWorkerThreadName(Thread.currentThread().getName());
                this.connector.getContainer().getPipeline().getFirst().event(request, response, request.getEvent());
                Request.AsyncContextImpl asyncContext = (Request.AsyncContextImpl)request.getAsyncContext();
                if (!error && (request.getAttribute("javax.servlet.error.exception") != null || asyncContext != null && asyncContext.getError() != null)) {
                    request.getEvent().setType(HttpEvent.EventType.ERROR);
                    error = true;
                    this.connector.getContainer().getPipeline().getFirst().event(request, response, request.getEvent());
                }
                if (!error && read && request.ready()) {
                    CatalinaLogger.CONNECTOR_LOGGER.servletDidNotReadAvailableData();
                    request.getEvent().setType(HttpEvent.EventType.ERROR);
                    error = true;
                    this.connector.getContainer().getPipeline().getFirst().event(request, response, request.getEvent());
                }
                if (!error && !eof && status == SocketStatus.OPEN_READ && request.isEof()) {
                    request.getEvent().setType(HttpEvent.EventType.EOF);
                    eof = true;
                    this.connector.getContainer().getPipeline().getFirst().event(request, response, request.getEvent());
                }
                if (!error && request.isEof()) {
                    request.suspend();
                }
                if (error || close) {
                    response.finishResponse();
                    if (request.getUpgradeHandler() != null) {
                        error = true;
                    }
                }
                boolean bl = !error;
                return bl;
            }
            catch (Throwable t) {
                if (!(t instanceof IOException)) {
                    CatalinaLogger.CONNECTOR_LOGGER.exceptionDuringService(t);
                }
                error = true;
                boolean bl = false;
                return bl;
            }
            finally {
                req.getRequestProcessor().setWorkerThreadName(null);
                if (error || close || response.isClosed()) {
                    if (request.getUpgradeHandler() != null) {
                        request.clearInputStream();
                        response.clearOutputStream();
                    }
                    request.recycle();
                    response.recycle();
                    res.action(ActionCode.ACTION_EVENT_END, null);
                }
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void service(org.apache.coyote.Request req, org.apache.coyote.Response res) throws Exception {
        Request request = (Request)req.getNote(1);
        Response response = (Response)res.getNote(1);
        if (request == null) {
            request = this.connector.createRequest();
            request.setCoyoteRequest(req);
            response = this.connector.createResponse();
            response.setCoyoteResponse(res);
            request.setResponse(response);
            response.setRequest(request);
            req.setNote(1, request);
            res.setNote(1, response);
            req.getParameters().setQueryStringEncoding(this.connector.getURIEncoding());
            Thread.currentThread().setContextClassLoader(CoyoteAdapter.class.getClassLoader());
        }
        if (this.connector.getService() == null) {
            res.setStatus(500);
            return;
        }
        if (this.connector.getXpoweredBy()) {
            response.addHeader("X-Powered-By", X_POWERED_BY);
        }
        boolean event = false;
        try {
            req.getRequestProcessor().setWorkerThreadName(Thread.currentThread().getName());
            if (this.postParseRequest(req, request, res, response)) {
                this.connector.getContainer().getPipeline().getFirst().invoke(request, response);
                if (request.isEventMode()) {
                    if (!response.isClosed() && !response.isError()) {
                        res.action(ActionCode.ACTION_EVENT_BEGIN, request.getAsyncContext() == null ? Boolean.TRUE : Boolean.FALSE);
                        event = true;
                    }
                    if (request.getUpgradeHandler() != null) {
                        request.getUpgradeHandler().init(request.getEvent());
                    }
                } else if (request.getAsyncContext() != null) {
                    Request.AsyncContextImpl asyncContext = (Request.AsyncContextImpl)request.getAsyncContext();
                    for (Request.AsyncListenerRegistration asyncListenerRegistration : asyncContext.getAsyncListeners().values()) {
                        AsyncListener asyncListener = asyncListenerRegistration.getListener();
                        AsyncEvent asyncEvent = new AsyncEvent((AsyncContext)asyncContext, asyncListenerRegistration.getRequest(), asyncListenerRegistration.getResponse());
                        try {
                            asyncListener.onComplete(asyncEvent);
                        }
                        catch (Throwable t) {
                            CatalinaLogger.CONNECTOR_LOGGER.exceptionDuringComplete(asyncListener.getClass().getName(), t);
                        }
                    }
                }
            }
            if (!event) {
                response.finishResponse();
                req.action(ActionCode.ACTION_POST_REQUEST, null);
            }
        }
        catch (IOException e) {
        }
        catch (Throwable t) {
            CatalinaLogger.CONNECTOR_LOGGER.exceptionDuringService(t);
        }
        finally {
            req.getRequestProcessor().setWorkerThreadName(null);
            if (!event) {
                request.recycle();
                response.recycle();
            } else {
                request.clearEncoders();
                response.clearEncoders();
            }
        }
    }

    protected boolean postParseRequest(org.apache.coyote.Request req, Request request, org.apache.coyote.Response res, Response response) throws Exception {
        MessageBytes serverName;
        String authtype;
        String principal;
        int semicolon;
        if (!req.scheme().isNull()) {
            request.setSecure(req.scheme().equals("https"));
        } else {
            req.scheme().setString(this.connector.getScheme());
            request.setSecure(this.connector.getSecure());
        }
        String proxyName = this.connector.getProxyName();
        int proxyPort = this.connector.getProxyPort();
        if (proxyPort != 0) {
            req.setServerPort(proxyPort);
        }
        if (proxyName != null) {
            req.serverName().setString(proxyName);
        }
        MessageBytes decodedURI = req.decodedURI();
        decodedURI.duplicate(req.requestURI());
        if (decodedURI.getType() == 2) {
            ByteChunk uriBB = decodedURI.getByteChunk();
            semicolon = uriBB.indexOf(';', 0);
            if (semicolon > 0) {
                decodedURI.setBytes(uriBB.getBuffer(), uriBB.getStart(), semicolon);
            }
            try {
                req.getURLDecoder().convert(decodedURI, false);
            }
            catch (IOException ioe) {
                res.setStatus(400);
                res.setMessage("Invalid URI: " + ioe.getMessage());
                return false;
            }
            if (!CoyoteAdapter.normalize(req.decodedURI())) {
                res.setStatus(400);
                res.setMessage("Invalid URI");
                return false;
            }
            this.convertURI(decodedURI, request);
            if (!CoyoteAdapter.checkNormalize(req.decodedURI())) {
                res.setStatus(400);
                res.setMessage("Invalid URI character encoding");
                return false;
            }
        } else {
            decodedURI.toChars();
            CharChunk uriCC = decodedURI.getCharChunk();
            semicolon = uriCC.indexOf(';');
            if (semicolon > 0) {
                decodedURI.setChars(uriCC.getBuffer(), uriCC.getStart(), semicolon);
            }
        }
        if ((principal = req.getRemoteUser().toString()) != null) {
            request.setUserPrincipal(new CoyotePrincipal(principal));
        }
        if ((authtype = req.getAuthType().toString()) != null) {
            request.setAuthType(authtype);
        }
        if (this.connector.getUseIPVHosts()) {
            serverName = req.localName();
            if (serverName.isNull()) {
                res.action(ActionCode.ACTION_REQ_LOCAL_NAME_ATTRIBUTE, null);
            }
            if (this.connector.getAllowedHosts() != null && this.connector.getAllowedHosts().size() == 1) {
                serverName = serverName.newInstance();
                serverName.setString(req.localName() + ":" + req.getServerPort());
            }
        } else {
            serverName = req.serverName();
        }
        this.connector.getService().getMapper().map(serverName, decodedURI, request.getMappingData());
        request.setContext((Context)request.getMappingData().context);
        request.setWrapper((Wrapper)request.getMappingData().wrapper);
        if (request.getMappingData().host == null) {
            res.setStatus(400);
            res.setMessage("Host not mapped");
            return false;
        }
        if (request.getMappingData().context == null) {
            res.setStatus(404);
            res.setMessage("Context not mapped");
            return false;
        }
        if (this.connector.getAllowedHosts() != null) {
            Host host = (Host)request.getMappingData().host;
            if (!this.connector.getAllowedHosts().contains(host.getName())) {
                res.setStatus(403);
                res.setMessage("Host access is forbidden through this connector");
                return false;
            }
        }
        if (!this.connector.getAllowTrace() && req.method().equalsIgnoreCase("TRACE")) {
            String[] methods;
            Wrapper wrapper = request.getWrapper();
            String header = null;
            if (wrapper != null && (methods = wrapper.getServletMethods()) != null) {
                for (int i = 0; i < methods.length; ++i) {
                    if ("TRACE".equals(methods[i])) continue;
                    header = header == null ? methods[i] : header + ", " + methods[i];
                }
            }
            res.setStatus(405);
            res.addHeader("Allow", header);
            res.setMessage("TRACE method is not allowed");
            return false;
        }
        if (request.getServletContext().getEffectiveSessionTrackingModes().contains(SessionTrackingMode.URL)) {
            this.parseSessionId(req, request);
        } else {
            request.setRequestedSessionId(null);
            request.setRequestedSessionURL(false);
        }
        MessageBytes redirectPathMB = request.getMappingData().redirectPath;
        if (!redirectPathMB.isNull()) {
            String redirectPath = urlEncoder.encode(redirectPathMB.toString());
            String query = request.getQueryString();
            if (request.isRequestedSessionIdFromURL()) {
                redirectPath = redirectPath + request.getContext().getSessionCookie().getPathParameterName() + request.getRequestedSessionId();
            }
            if (query != null) {
                redirectPath = redirectPath + "?" + query;
            }
            response.sendRedirect(redirectPath);
            return false;
        }
        if (request.getServletContext().getEffectiveSessionTrackingModes().contains(SessionTrackingMode.COOKIE)) {
            this.parseSessionCookiesId(req, request);
        }
        return true;
    }

    protected void parseSessionId(org.apache.coyote.Request req, Request request) {
        String pathParameterName;
        ByteChunk uriBC = req.requestURI().getByteChunk();
        int semicolon = uriBC.indexOf(pathParameterName = request.getContext().getSessionCookie().getPathParameterName(), 0, pathParameterName.length(), 0);
        if (semicolon > 0) {
            int start = uriBC.getStart();
            int end = uriBC.getEnd();
            int sessionIdStart = semicolon + pathParameterName.length();
            int semicolon2 = uriBC.indexOf(';', sessionIdStart);
            if (semicolon2 >= 0) {
                request.setRequestedSessionId(new String(uriBC.getBuffer(), start + sessionIdStart, semicolon2 - sessionIdStart));
                byte[] buf = uriBC.getBuffer();
                for (int i = 0; i < end - start - semicolon2; ++i) {
                    buf[start + semicolon + i] = buf[start + i + semicolon2];
                }
                uriBC.setBytes(buf, start, end - start - semicolon2 + semicolon);
            } else {
                request.setRequestedSessionId(new String(uriBC.getBuffer(), start + sessionIdStart, end - start - sessionIdStart));
                uriBC.setEnd(start + semicolon);
            }
            request.setRequestedSessionURL(true);
        } else {
            request.setRequestedSessionId(null);
            request.setRequestedSessionURL(false);
        }
    }

    protected void parseSessionCookiesId(org.apache.coyote.Request req, Request request) {
        Cookies serverCookies = req.getCookies();
        int count = serverCookies.getCookieCount();
        if (count <= 0) {
            return;
        }
        String cookieName = request.getContext().getSessionCookie().getName();
        for (int i = 0; i < count; ++i) {
            ServerCookie scookie = serverCookies.getCookie(i);
            if (!scookie.getName().equals(cookieName)) continue;
            if (!request.isRequestedSessionIdFromCookie()) {
                this.convertMB(scookie.getValue());
                request.setRequestedSessionId(scookie.getValue().toString());
                request.setRequestedSessionCookie(true);
                request.setRequestedSessionURL(false);
                continue;
            }
            if (this.isSessionIdValid(request, request.getRequestedSessionId())) continue;
            this.convertMB(scookie.getValue());
            request.setRequestedSessionId(scookie.getValue().toString());
        }
    }

    public boolean isSessionIdValid(Request request, String id) {
        if (id == null) {
            return false;
        }
        Context context = request.getContext();
        if (context == null) {
            return false;
        }
        Manager manager = context.getManager();
        if (manager == null) {
            return false;
        }
        Session session = null;
        try {
            session = manager.findSession(id);
        }
        catch (IOException e) {
            session = null;
        }
        return session != null && session.isValidInternal();
    }

    protected void convertURI(MessageBytes uri, Request request) throws Exception {
        ByteChunk bc = uri.getByteChunk();
        int length = bc.getLength();
        CharChunk cc = uri.getCharChunk();
        cc.allocate(length, -1);
        String enc = this.connector.getURIEncoding();
        if (enc != null) {
            B2CConverter conv = request.getURIConverter();
            try {
                if (conv == null) {
                    conv = new B2CConverter(enc);
                    request.setURIConverter(conv);
                } else {
                    conv.recycle();
                }
            }
            catch (Exception e) {
                CatalinaLogger.CONNECTOR_LOGGER.invalidEncodingUseHttpDefault(e);
                this.connector.setURIEncoding(null);
            }
            if (conv != null) {
                try {
                    conv.convert(bc, cc);
                    uri.setChars(cc.getBuffer(), cc.getStart(), cc.getLength());
                    return;
                }
                catch (IOException e) {
                    CatalinaLogger.CONNECTOR_LOGGER.invalidEncoding(e);
                    cc.recycle();
                }
            }
        }
        byte[] bbuf = bc.getBuffer();
        char[] cbuf = cc.getBuffer();
        int start = bc.getStart();
        for (int i = 0; i < length; ++i) {
            cbuf[i] = (char)(bbuf[i + start] & 0xFF);
        }
        uri.setChars(cbuf, 0, length);
    }

    protected void convertMB(MessageBytes mb) {
        if (mb.getType() != 2) {
            return;
        }
        ByteChunk bc = mb.getByteChunk();
        CharChunk cc = mb.getCharChunk();
        int length = bc.getLength();
        cc.allocate(length, -1);
        byte[] bbuf = bc.getBuffer();
        char[] cbuf = cc.getBuffer();
        int start = bc.getStart();
        for (int i = 0; i < length; ++i) {
            cbuf[i] = (char)(bbuf[i + start] & 0xFF);
        }
        mb.setChars(cbuf, 0, length);
    }

    public static boolean normalize(MessageBytes uriMB) {
        int end;
        ByteChunk uriBC = uriMB.getByteChunk();
        byte[] b = uriBC.getBytes();
        int start = uriBC.getStart();
        if (start == (end = uriBC.getEnd())) {
            return false;
        }
        if (end - start == 1 && b[start] == 42) {
            return true;
        }
        int pos = 0;
        int index = 0;
        for (pos = start; pos < end; ++pos) {
            if (b[pos] == 92) {
                if (ALLOW_BACKSLASH) {
                    b[pos] = 47;
                } else {
                    return false;
                }
            }
            if (b[pos] != 0) continue;
            return false;
        }
        if (b[start] != 47) {
            return false;
        }
        for (pos = start; pos < end - 1; ++pos) {
            if (b[pos] != 47) continue;
            while (pos + 1 < end && b[pos + 1] == 47) {
                CoyoteAdapter.copyBytes(b, pos, pos + 1, end - pos - 1);
                --end;
            }
        }
        if (end - start >= 2 && b[end - 1] == 46 && (b[end - 2] == 47 || b[end - 2] == 46 && b[end - 3] == 47)) {
            b[end] = 47;
            ++end;
        }
        uriBC.setEnd(end);
        index = 0;
        while ((index = uriBC.indexOf("/./", 0, 3, index)) >= 0) {
            CoyoteAdapter.copyBytes(b, start + index, start + index + 2, end - start - index - 2);
            uriBC.setEnd(end -= 2);
        }
        index = 0;
        while ((index = uriBC.indexOf("/../", 0, 4, index)) >= 0) {
            if (index == 0) {
                return false;
            }
            int index2 = -1;
            for (pos = start + index - 1; pos >= 0 && index2 < 0; --pos) {
                if (b[pos] != 47) continue;
                index2 = pos;
            }
            CoyoteAdapter.copyBytes(b, start + index2, start + index + 3, end - start - index - 3);
            end = end + index2 - index - 3;
            uriBC.setEnd(end);
            index = index2;
        }
        uriBC.setBytes(b, start, end);
        return true;
    }

    public static boolean checkNormalize(MessageBytes uriMB) {
        CharChunk uriCC = uriMB.getCharChunk();
        char[] c = uriCC.getChars();
        int start = uriCC.getStart();
        int end = uriCC.getEnd();
        int pos = 0;
        for (pos = start; pos < end; ++pos) {
            if (c[pos] == '\\') {
                return false;
            }
            if (c[pos] != '\u0000') continue;
            return false;
        }
        for (pos = start; pos < end - 1; ++pos) {
            if (c[pos] != '/' || c[pos + 1] != '/') continue;
            return false;
        }
        if (end - start >= 2 && c[end - 1] == '.' && (c[end - 2] == '/' || c[end - 2] == '.' && c[end - 3] == '/')) {
            return false;
        }
        if (uriCC.indexOf("/./", 0, 3, 0) >= 0) {
            return false;
        }
        return uriCC.indexOf("/../", 0, 4, 0) < 0;
    }

    protected static void copyBytes(byte[] b, int dest, int src, int len) {
        for (int pos = 0; pos < len; ++pos) {
            b[pos + dest] = b[pos + src];
        }
    }

    static {
        urlEncoder.addSafeCharacter('-');
        urlEncoder.addSafeCharacter('_');
        urlEncoder.addSafeCharacter('.');
        urlEncoder.addSafeCharacter('*');
        urlEncoder.addSafeCharacter('/');
    }
}

