/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.ssi;

import java.io.IOException;
import java.io.PrintWriter;
import org.apache.catalina.ssi.SSICommand;
import org.apache.catalina.ssi.SSIMediator;
import org.jboss.web.CatalinaMessages;

public final class SSIInclude
implements SSICommand {
    @Override
    public long process(SSIMediator ssiMediator, String commandName, String[] paramNames, String[] paramValues, PrintWriter writer) {
        long lastModified = 0L;
        String configErrMsg = ssiMediator.getConfigErrMsg();
        for (int i = 0; i < paramNames.length; ++i) {
            String paramName = paramNames[i];
            String paramValue = paramValues[i];
            String substitutedValue = ssiMediator.substituteVariables(paramValue);
            try {
                if (paramName.equalsIgnoreCase("file") || paramName.equalsIgnoreCase("virtual")) {
                    boolean virtual = paramName.equalsIgnoreCase("virtual");
                    lastModified = ssiMediator.getFileLastModified(substitutedValue, virtual);
                    String text = ssiMediator.getFileText(substitutedValue, virtual);
                    writer.write(text);
                    continue;
                }
                ssiMediator.log(CatalinaMessages.MESSAGES.ssiInvalidAttribute("include", paramName));
                writer.write(configErrMsg);
                continue;
            }
            catch (IOException e) {
                ssiMediator.log(CatalinaMessages.MESSAGES.ssiIncludeFailed(substitutedValue), e);
                writer.write(configErrMsg);
            }
        }
        return lastModified;
    }
}

