/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.valves;

import java.io.IOException;
import java.io.StringReader;
import java.net.InetAddress;
import java.net.URLEncoder;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.TimeZone;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpSession;
import org.apache.catalina.Lifecycle;
import org.apache.catalina.connector.Request;
import org.apache.catalina.connector.Response;
import org.apache.catalina.util.ServerInfo;
import org.apache.catalina.valves.AccessLogValve;
import org.jboss.web.CatalinaLogger;

public class ExtendedAccessLogValve
extends AccessLogValve
implements Lifecycle {
    protected static final String extendedAccessLogInfo = "org.apache.catalina.valves.ExtendedAccessLogValve/2.1";

    @Override
    public String getInfo() {
        return extendedAccessLogInfo;
    }

    private String wrap(Object value) {
        String svalue;
        if (value == null || "-".equals(value)) {
            return "-";
        }
        try {
            svalue = value.toString();
            if ("".equals(svalue)) {
                return "-";
            }
        }
        catch (Throwable e) {
            return "-";
        }
        StringBuilder buffer = new StringBuilder(svalue.length() + 2);
        buffer.append('\'');
        int i = 0;
        while (i < svalue.length()) {
            int j = svalue.indexOf(39, i);
            if (j == -1) {
                buffer.append(svalue.substring(i));
                i = svalue.length();
                continue;
            }
            buffer.append(svalue.substring(i, j + 1));
            buffer.append('\"');
            i = j + 2;
        }
        buffer.append('\'');
        return buffer.toString();
    }

    @Override
    protected synchronized void open() {
        super.open();
        if (this.currentLogFile.length() == 0L) {
            this.writer.println("#Fields: " + this.pattern);
            this.writer.println("#Version: 2.0");
            this.writer.println("#Software: " + ServerInfo.getServerInfo());
        }
    }

    @Override
    protected AccessLogValve.AccessLogElement[] createLogElements() {
        if (CatalinaLogger.VALVES_LOGGER.isDebugEnabled()) {
            CatalinaLogger.VALVES_LOGGER.debug("decodePattern, pattern =" + this.pattern);
        }
        ArrayList<AccessLogValve.AccessLogElement> list = new ArrayList<AccessLogValve.AccessLogElement>();
        PatternTokenizer tokenizer = new PatternTokenizer(this.pattern);
        try {
            tokenizer.getWhiteSpaces();
            if (tokenizer.isEnded()) {
                CatalinaLogger.VALVES_LOGGER.extendedAccessLogEmptyPattern();
                return null;
            }
            String token = tokenizer.getToken();
            while (token != null) {
                AccessLogValve.AccessLogElement element;
                if (CatalinaLogger.VALVES_LOGGER.isDebugEnabled()) {
                    CatalinaLogger.VALVES_LOGGER.debug("token = " + token);
                }
                if ((element = this.getLogElement(token, tokenizer)) == null) break;
                list.add(element);
                String whiteSpaces = tokenizer.getWhiteSpaces();
                if (whiteSpaces.length() > 0) {
                    list.add(new AccessLogValve.StringElement(this, whiteSpaces));
                }
                if (tokenizer.isEnded()) break;
                token = tokenizer.getToken();
            }
            if (CatalinaLogger.VALVES_LOGGER.isDebugEnabled()) {
                CatalinaLogger.VALVES_LOGGER.debug("finished decoding with element size of: " + list.size());
            }
            return list.toArray(new AccessLogValve.AccessLogElement[0]);
        }
        catch (IOException e) {
            CatalinaLogger.VALVES_LOGGER.extendedAccessLogPatternParseError(e);
            return null;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected AccessLogValve.AccessLogElement getLogElement(String token, PatternTokenizer tokenizer) throws IOException {
        if ("date".equals(token)) {
            return new DateElement();
        }
        if ("time".equals(token)) {
            if (!tokenizer.hasSubToken()) return new TimeElement();
            String nextToken = tokenizer.getToken();
            if ("taken".equals(nextToken)) {
                return new AccessLogValve.ElapsedTimeElement(this, false);
            }
        } else {
            if ("bytes".equals(token)) {
                return new AccessLogValve.ByteSentElement(this, true);
            }
            if ("cached".equals(token)) {
                return new AccessLogValve.StringElement(this, "-");
            }
            if ("c".equals(token)) {
                String nextToken = tokenizer.getToken();
                if ("ip".equals(nextToken)) {
                    return new AccessLogValve.RemoteAddrElement(this);
                }
                if ("dns".equals(nextToken)) {
                    return new AccessLogValve.HostElement(this);
                }
            } else if ("s".equals(token)) {
                String nextToken = tokenizer.getToken();
                if ("ip".equals(nextToken)) {
                    return new AccessLogValve.LocalAddrElement(this);
                }
                if ("dns".equals(nextToken)) {
                    return new AccessLogValve.AccessLogElement(){

                        @Override
                        public void addElement(StringBuilder buf, Date date, Request request, Response response, long time) {
                            String value;
                            try {
                                value = InetAddress.getLocalHost().getHostName();
                            }
                            catch (Throwable e) {
                                value = "localhost";
                            }
                            buf.append(value);
                        }
                    };
                }
            } else {
                if ("cs".equals(token)) {
                    return this.getClientToServerElement(tokenizer);
                }
                if ("sc".equals(token)) {
                    return this.getServerToClientElement(tokenizer);
                }
                if ("sr".equals(token) || "rs".equals(token)) {
                    return this.getProxyElement(tokenizer);
                }
                if ("x".equals(token)) {
                    return this.getXParameterElement(tokenizer);
                }
            }
        }
        CatalinaLogger.VALVES_LOGGER.extendedAccessLogUnknownToken(token);
        return null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected AccessLogValve.AccessLogElement getClientToServerElement(PatternTokenizer tokenizer) throws IOException {
        if (tokenizer.hasSubToken()) {
            String token = tokenizer.getToken();
            if ("method".equals(token)) {
                return new AccessLogValve.MethodElement(this);
            }
            if ("uri".equals(token)) {
                if (!tokenizer.hasSubToken()) return new AccessLogValve.AccessLogElement(){

                    @Override
                    public void addElement(StringBuilder buf, Date date, Request request, Response response, long time) {
                        String query = request.getQueryString();
                        if (query == null) {
                            buf.append(request.getRequestURI());
                        } else {
                            buf.append(request.getRequestURI());
                            buf.append('?');
                            buf.append(request.getQueryString());
                        }
                    }
                };
                token = tokenizer.getToken();
                if ("stem".equals(token)) {
                    return new AccessLogValve.RequestURIElement(this);
                }
                if ("query".equals(token)) {
                    return new AccessLogValve.AccessLogElement(){

                        @Override
                        public void addElement(StringBuilder buf, Date date, Request request, Response response, long time) {
                            String query = request.getQueryString();
                            if (query != null) {
                                buf.append(query);
                            } else {
                                buf.append('-');
                            }
                        }
                    };
                }
            }
        } else if (tokenizer.hasParameter()) {
            String parameter = tokenizer.getParameter();
            if (parameter != null) return new RequestHeaderElement(parameter);
            CatalinaLogger.VALVES_LOGGER.extendedAccessLogMissingClosing();
            return null;
        }
        CatalinaLogger.VALVES_LOGGER.extendedAccessLogCannotDecode(tokenizer.getRemains());
        return null;
    }

    protected AccessLogValve.AccessLogElement getServerToClientElement(PatternTokenizer tokenizer) throws IOException {
        if (tokenizer.hasSubToken()) {
            String token = tokenizer.getToken();
            if ("status".equals(token)) {
                return new AccessLogValve.HttpStatusCodeElement(this);
            }
            if ("comment".equals(token)) {
                return new AccessLogValve.StringElement(this, "?");
            }
        } else if (tokenizer.hasParameter()) {
            String parameter = tokenizer.getParameter();
            if (parameter == null) {
                CatalinaLogger.VALVES_LOGGER.extendedAccessLogMissingClosing();
                return null;
            }
            return new ResponseHeaderElement(parameter);
        }
        CatalinaLogger.VALVES_LOGGER.extendedAccessLogCannotDecode(tokenizer.getRemains());
        return null;
    }

    protected AccessLogValve.AccessLogElement getProxyElement(PatternTokenizer tokenizer) throws IOException {
        String token = null;
        if (tokenizer.hasSubToken()) {
            token = tokenizer.getToken();
            return new AccessLogValve.StringElement(this, "-");
        }
        if (tokenizer.hasParameter()) {
            tokenizer.getParameter();
            return new AccessLogValve.StringElement(this, "-");
        }
        CatalinaLogger.VALVES_LOGGER.extendedAccessLogCannotDecode(token);
        return null;
    }

    protected AccessLogValve.AccessLogElement getXParameterElement(PatternTokenizer tokenizer) throws IOException {
        if (!tokenizer.hasSubToken()) {
            CatalinaLogger.VALVES_LOGGER.extendedAccessLogBadXParam();
            return null;
        }
        String token = tokenizer.getToken();
        if (!tokenizer.hasParameter()) {
            CatalinaLogger.VALVES_LOGGER.extendedAccessLogBadXParam();
            return null;
        }
        String parameter = tokenizer.getParameter();
        if (parameter == null) {
            CatalinaLogger.VALVES_LOGGER.extendedAccessLogMissingClosing();
            return null;
        }
        if ("A".equals(token)) {
            return new ServletContextElement(parameter);
        }
        if ("C".equals(token)) {
            return new CookieElement(parameter);
        }
        if ("R".equals(token)) {
            return new RequestAttributeElement(parameter);
        }
        if ("S".equals(token)) {
            return new SessionAttributeElement(parameter);
        }
        if ("H".equals(token)) {
            return this.getServletRequestElement(parameter);
        }
        if ("P".equals(token)) {
            return new RequestParameterElement(parameter);
        }
        if ("O".equals(token)) {
            return new ResponseAllHeaderElement(parameter);
        }
        CatalinaLogger.VALVES_LOGGER.extendedAccessLogCannotDecodeXParamValue(token);
        return null;
    }

    protected AccessLogValve.AccessLogElement getServletRequestElement(String parameter) {
        if ("authType".equals(parameter)) {
            return new AccessLogValve.AccessLogElement(){

                @Override
                public void addElement(StringBuilder buf, Date date, Request request, Response response, long time) {
                    buf.append(ExtendedAccessLogValve.this.wrap(request.getAuthType()));
                }
            };
        }
        if ("remoteUser".equals(parameter)) {
            return new AccessLogValve.AccessLogElement(){

                @Override
                public void addElement(StringBuilder buf, Date date, Request request, Response response, long time) {
                    buf.append(ExtendedAccessLogValve.this.wrap(request.getRemoteUser()));
                }
            };
        }
        if ("requestedSessionId".equals(parameter)) {
            return new AccessLogValve.AccessLogElement(){

                @Override
                public void addElement(StringBuilder buf, Date date, Request request, Response response, long time) {
                    buf.append(ExtendedAccessLogValve.this.wrap(request.getRequestedSessionId()));
                }
            };
        }
        if ("requestedSessionIdFromCookie".equals(parameter)) {
            return new AccessLogValve.AccessLogElement(){

                @Override
                public void addElement(StringBuilder buf, Date date, Request request, Response response, long time) {
                    buf.append(ExtendedAccessLogValve.this.wrap("" + request.isRequestedSessionIdFromCookie()));
                }
            };
        }
        if ("requestedSessionIdValid".equals(parameter)) {
            return new AccessLogValve.AccessLogElement(){

                @Override
                public void addElement(StringBuilder buf, Date date, Request request, Response response, long time) {
                    buf.append(ExtendedAccessLogValve.this.wrap("" + request.isRequestedSessionIdValid()));
                }
            };
        }
        if ("contentLength".equals(parameter)) {
            return new AccessLogValve.AccessLogElement(){

                @Override
                public void addElement(StringBuilder buf, Date date, Request request, Response response, long time) {
                    buf.append(ExtendedAccessLogValve.this.wrap("" + request.getContentLength()));
                }
            };
        }
        if ("characterEncoding".equals(parameter)) {
            return new AccessLogValve.AccessLogElement(){

                @Override
                public void addElement(StringBuilder buf, Date date, Request request, Response response, long time) {
                    buf.append(ExtendedAccessLogValve.this.wrap(request.getCharacterEncoding()));
                }
            };
        }
        if ("locale".equals(parameter)) {
            return new AccessLogValve.AccessLogElement(){

                @Override
                public void addElement(StringBuilder buf, Date date, Request request, Response response, long time) {
                    buf.append(ExtendedAccessLogValve.this.wrap(request.getLocale()));
                }
            };
        }
        if ("protocol".equals(parameter)) {
            return new AccessLogValve.AccessLogElement(){

                @Override
                public void addElement(StringBuilder buf, Date date, Request request, Response response, long time) {
                    buf.append(ExtendedAccessLogValve.this.wrap(request.getProtocol()));
                }
            };
        }
        if ("scheme".equals(parameter)) {
            return new AccessLogValve.AccessLogElement(){

                @Override
                public void addElement(StringBuilder buf, Date date, Request request, Response response, long time) {
                    buf.append(request.getScheme());
                }
            };
        }
        if ("secure".equals(parameter)) {
            return new AccessLogValve.AccessLogElement(){

                @Override
                public void addElement(StringBuilder buf, Date date, Request request, Response response, long time) {
                    buf.append(ExtendedAccessLogValve.this.wrap("" + request.isSecure()));
                }
            };
        }
        CatalinaLogger.VALVES_LOGGER.extendedAccessLogCannotDecodeXParamValue(parameter);
        return null;
    }

    protected class PatternTokenizer {
        private StringReader sr = null;
        private StringBuilder buf = new StringBuilder();
        private boolean ended = false;
        private boolean subToken;
        private boolean parameter;

        public PatternTokenizer(String str) {
            this.sr = new StringReader(str);
        }

        public boolean hasSubToken() {
            return this.subToken;
        }

        public boolean hasParameter() {
            return this.parameter;
        }

        public String getToken() throws IOException {
            if (this.ended) {
                return null;
            }
            String result = null;
            this.subToken = false;
            this.parameter = false;
            int c = this.sr.read();
            while (c != -1) {
                switch (c) {
                    case 32: {
                        result = this.buf.toString();
                        this.buf = new StringBuilder();
                        this.buf.append((char)c);
                        return result;
                    }
                    case 45: {
                        result = this.buf.toString();
                        this.buf = new StringBuilder();
                        this.subToken = true;
                        return result;
                    }
                    case 40: {
                        result = this.buf.toString();
                        this.buf = new StringBuilder();
                        this.parameter = true;
                        return result;
                    }
                    case 41: {
                        result = this.buf.toString();
                        this.buf = new StringBuilder();
                        break;
                    }
                    default: {
                        this.buf.append((char)c);
                    }
                }
                c = this.sr.read();
            }
            this.ended = true;
            if (this.buf.length() != 0) {
                return this.buf.toString();
            }
            return null;
        }

        public String getParameter() throws IOException {
            if (!this.parameter) {
                return null;
            }
            this.parameter = false;
            int c = this.sr.read();
            while (c != -1) {
                if (c == 41) {
                    String result = this.buf.toString();
                    this.buf = new StringBuilder();
                    return result;
                }
                this.buf.append((char)c);
                c = this.sr.read();
            }
            return null;
        }

        public String getWhiteSpaces() throws IOException {
            if (this.isEnded()) {
                return "";
            }
            StringBuilder whiteSpaces = new StringBuilder();
            if (this.buf.length() > 0) {
                whiteSpaces.append((CharSequence)this.buf);
                this.buf = new StringBuilder();
            }
            int c = this.sr.read();
            while (Character.isWhitespace((char)c)) {
                whiteSpaces.append((char)c);
                c = this.sr.read();
            }
            if (c == -1) {
                this.ended = true;
            } else {
                this.buf.append((char)c);
            }
            return whiteSpaces.toString();
        }

        public boolean isEnded() {
            return this.ended;
        }

        public String getRemains() throws IOException {
            StringBuilder remains = new StringBuilder();
            int c = this.sr.read();
            while (c != -1) {
                remains.append((char)c);
                c = this.sr.read();
            }
            return remains.toString();
        }
    }

    protected class RequestParameterElement
    implements AccessLogValve.AccessLogElement {
        private String parameter;

        public RequestParameterElement(String parameter) {
            this.parameter = parameter;
        }

        private String urlEncode(String value) {
            if (null == value || value.length() == 0) {
                return null;
            }
            return URLEncoder.encode(value);
        }

        @Override
        public void addElement(StringBuilder buf, Date date, Request request, Response response, long time) {
            buf.append(ExtendedAccessLogValve.this.wrap(this.urlEncode(request.getParameter(this.parameter))));
        }
    }

    protected class SessionAttributeElement
    implements AccessLogValve.AccessLogElement {
        private String attribute;

        public SessionAttributeElement(String attribute) {
            this.attribute = attribute;
        }

        @Override
        public void addElement(StringBuilder buf, Date date, Request request, Response response, long time) {
            HttpSession session = null;
            if (request != null && (session = request.getSession(false)) != null) {
                buf.append(ExtendedAccessLogValve.this.wrap(session.getAttribute(this.attribute)));
            }
        }
    }

    protected class RequestAttributeElement
    implements AccessLogValve.AccessLogElement {
        private String attribute;

        public RequestAttributeElement(String attribute) {
            this.attribute = attribute;
        }

        @Override
        public void addElement(StringBuilder buf, Date date, Request request, Response response, long time) {
            buf.append(ExtendedAccessLogValve.this.wrap(request.getAttribute(this.attribute)));
        }
    }

    protected class ResponseAllHeaderElement
    implements AccessLogValve.AccessLogElement {
        private String header;

        public ResponseAllHeaderElement(String header) {
            this.header = header;
        }

        @Override
        public void addElement(StringBuilder buf, Date date, Request request, Response response, long time) {
            String[] values;
            if (null != response && (values = response.getHeaderValues(this.header)).length > 0) {
                StringBuilder buffer = new StringBuilder();
                for (int i = 0; i < values.length; ++i) {
                    String string = values[i];
                    buffer.append(string);
                    if (i + 1 >= values.length) continue;
                    buffer.append(",");
                }
                buf.append(ExtendedAccessLogValve.this.wrap(buffer.toString()));
                return;
            }
            buf.append("-");
        }
    }

    protected class CookieElement
    implements AccessLogValve.AccessLogElement {
        private String name;

        public CookieElement(String name) {
            this.name = name;
        }

        @Override
        public void addElement(StringBuilder buf, Date date, Request request, Response response, long time) {
            Cookie[] c = request.getCookies();
            for (int i = 0; c != null && i < c.length; ++i) {
                if (!this.name.equals(c[i].getName())) continue;
                buf.append(ExtendedAccessLogValve.this.wrap(c[i].getValue()));
            }
        }
    }

    protected class ServletContextElement
    implements AccessLogValve.AccessLogElement {
        private String attribute;

        public ServletContextElement(String attribute) {
            this.attribute = attribute;
        }

        @Override
        public void addElement(StringBuilder buf, Date date, Request request, Response response, long time) {
            buf.append(ExtendedAccessLogValve.this.wrap(request.getContext().getServletContext().getAttribute(this.attribute)));
        }
    }

    protected class ResponseHeaderElement
    implements AccessLogValve.AccessLogElement {
        private String header;

        public ResponseHeaderElement(String header) {
            this.header = header;
        }

        @Override
        public void addElement(StringBuilder buf, Date date, Request request, Response response, long time) {
            buf.append(ExtendedAccessLogValve.this.wrap(response.getHeader(this.header)));
        }
    }

    protected class RequestHeaderElement
    implements AccessLogValve.AccessLogElement {
        private String header;

        public RequestHeaderElement(String header) {
            this.header = header;
        }

        @Override
        public void addElement(StringBuilder buf, Date date, Request request, Response response, long time) {
            buf.append(ExtendedAccessLogValve.this.wrap(request.getHeader(this.header)));
        }
    }

    protected class TimeElement
    implements AccessLogValve.AccessLogElement {
        private Date currentDate = new Date(0L);
        private String currentTimeString = null;
        private SimpleDateFormat timeFormatter = new SimpleDateFormat("HH:mm:ss");

        public TimeElement() {
            this.timeFormatter.setTimeZone(TimeZone.getTimeZone("GMT"));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void addElement(StringBuilder buf, Date date, Request request, Response response, long time) {
            if (this.currentDate != date) {
                TimeElement timeElement = this;
                synchronized (timeElement) {
                    if (this.currentDate != date) {
                        this.currentTimeString = this.timeFormatter.format(date);
                        this.currentDate = date;
                    }
                }
            }
            buf.append(this.currentTimeString);
        }
    }

    protected class DateElement
    implements AccessLogValve.AccessLogElement {
        private Date currentDate = new Date(0L);
        private String currentDateString = null;
        private SimpleDateFormat dateFormatter = new SimpleDateFormat("yyyy-MM-dd");

        public DateElement() {
            this.dateFormatter.setTimeZone(TimeZone.getTimeZone("GMT"));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void addElement(StringBuilder buf, Date date, Request request, Response response, long time) {
            if (this.currentDate != date) {
                DateElement dateElement = this;
                synchronized (dateElement) {
                    if (this.currentDate != date) {
                        this.currentDateString = this.dateFormatter.format(date);
                        this.currentDate = date;
                    }
                }
            }
            buf.append(this.currentDateString);
        }
    }
}

