/*
 * Decompiled with CFR 0.152.
 */
package org.apache.coyote.http11.filters;

import java.io.IOException;
import org.apache.coyote.InputBuffer;
import org.apache.coyote.Request;
import org.apache.coyote.http11.InputFilter;
import org.apache.tomcat.util.buf.ByteChunk;
import org.apache.tomcat.util.buf.HexUtils;
import org.jboss.web.CoyoteMessages;

public class ChunkedInputFilter
implements InputFilter {
    protected static final String ENCODING_NAME = "chunked";
    protected static final ByteChunk ENCODING = new ByteChunk();
    protected InputBuffer buffer;
    protected int remaining = 0;
    protected int pos = 0;
    protected int lastValid = 0;
    protected byte[] buf = null;
    protected ByteChunk readChunk = new ByteChunk();
    protected boolean endChunk = false;
    protected boolean needCRLFParse = false;
    private boolean error;

    @Override
    public int doRead(ByteChunk chunk, Request req) throws IOException {
        if (this.endChunk) {
            return -1;
        }
        this.checkError();
        if (this.needCRLFParse) {
            this.needCRLFParse = false;
            this.parseCRLF();
        }
        if (this.remaining <= 0) {
            if (!this.parseChunkHeader()) {
                return 0;
            }
            if (this.endChunk) {
                this.parseEndChunk();
                return -1;
            }
        }
        int result = 0;
        if (this.pos >= this.lastValid) {
            this.readBytes();
        }
        if (this.remaining > this.lastValid - this.pos) {
            result = this.lastValid - this.pos;
            this.remaining -= result;
            chunk.setBytes(this.buf, this.pos, result);
            this.pos = this.lastValid;
        } else {
            result = this.remaining;
            chunk.setBytes(this.buf, this.pos, this.remaining);
            this.pos += this.remaining;
            this.remaining = 0;
            if (this.pos + 1 >= this.lastValid) {
                this.needCRLFParse = true;
            } else {
                this.parseCRLF();
            }
        }
        return result;
    }

    @Override
    public void setRequest(Request request) {
    }

    @Override
    public long end() throws IOException {
        while (this.doRead(this.readChunk, null) > 0) {
        }
        return this.lastValid - this.pos;
    }

    @Override
    public int available() {
        return this.lastValid - this.pos;
    }

    @Override
    public void setBuffer(InputBuffer buffer) {
        this.buffer = buffer;
    }

    @Override
    public void recycle() {
        this.remaining = 0;
        this.pos = 0;
        this.lastValid = 0;
        this.endChunk = false;
        this.needCRLFParse = false;
        this.error = false;
    }

    @Override
    public ByteChunk getEncodingName() {
        return ENCODING;
    }

    protected int readBytes() throws IOException {
        int nRead = this.buffer.doRead(this.readChunk, null);
        this.pos = this.readChunk.getStart();
        this.lastValid = this.pos + nRead;
        this.buf = this.readChunk.getBytes();
        return nRead;
    }

    protected boolean parseChunkHeader() throws IOException {
        int result = 0;
        boolean eol = false;
        boolean crfound = false;
        int readDigit = 0;
        boolean trailer = false;
        while (!eol) {
            if (this.pos >= this.lastValid) {
                int n = this.readBytes();
                if (n < 0) {
                    this.error = true;
                    throw CoyoteMessages.MESSAGES.invalidChunkHeader();
                }
                if (n == 0) {
                    return false;
                }
            }
            if (this.buf[this.pos] == 13) {
                if (crfound) {
                    throw CoyoteMessages.MESSAGES.invalidCrlfTwoCr();
                }
                crfound = true;
            } else if (this.buf[this.pos] == 10) {
                if (!crfound) {
                    throw CoyoteMessages.MESSAGES.invalidCrlfNoCr();
                }
                eol = true;
            } else if (this.buf[this.pos] == 59) {
                trailer = true;
            } else {
                if (this.buf[this.pos] < 0) {
                    this.error = true;
                    throw CoyoteMessages.MESSAGES.invalidChunkHeader();
                }
                if (!trailer) {
                    int charValue = HexUtils.DEC[this.buf[this.pos] & 0xFF];
                    if (charValue != -1 && readDigit < 8) {
                        ++readDigit;
                        result = result << 4 | charValue;
                    } else {
                        this.error = true;
                        throw CoyoteMessages.MESSAGES.invalidChunkHeader();
                    }
                }
            }
            ++this.pos;
        }
        if (readDigit == 0 || result < 0) {
            this.error = true;
            throw CoyoteMessages.MESSAGES.invalidChunkHeader();
        }
        if (result == 0) {
            this.endChunk = true;
        }
        this.remaining = result;
        return true;
    }

    protected boolean parseCRLF() throws IOException {
        boolean eol = false;
        boolean crfound = false;
        while (!eol) {
            if (this.pos >= this.lastValid && this.readBytes() <= 0) {
                this.error = true;
                throw CoyoteMessages.MESSAGES.invalidCrlf();
            }
            if (this.buf[this.pos] == 13) {
                if (crfound) {
                    this.error = true;
                    throw CoyoteMessages.MESSAGES.invalidCrlfTwoCr();
                }
                crfound = true;
            } else if (this.buf[this.pos] == 10) {
                if (!crfound) {
                    this.error = true;
                    throw CoyoteMessages.MESSAGES.invalidCrlfNoCr();
                }
                eol = true;
            } else {
                this.error = true;
                throw CoyoteMessages.MESSAGES.invalidCrlf();
            }
            ++this.pos;
        }
        return true;
    }

    protected boolean parseEndChunk() throws IOException {
        return this.parseCRLF();
    }

    private void checkError() throws IOException {
        if (this.error) {
            throw new IOException(CoyoteMessages.MESSAGES.chunkedFilterError());
        }
    }

    static {
        ENCODING.setBytes(ENCODING_NAME.getBytes(), 0, ENCODING_NAME.length());
    }
}

