/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.session;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.IOException;
import org.apache.catalina.Lifecycle;
import org.apache.catalina.LifecycleException;
import org.apache.catalina.LifecycleListener;
import org.apache.catalina.Manager;
import org.apache.catalina.Store;
import org.apache.catalina.session.PersistentManagerBase;
import org.apache.catalina.session.StandardSession;
import org.apache.catalina.util.LifecycleSupport;
import org.jboss.web.CatalinaMessages;

public abstract class StoreBase
implements Lifecycle,
Store {
    protected static String info = "StoreBase/1.0";
    protected static String storeName = "StoreBase";
    protected boolean started = false;
    protected LifecycleSupport lifecycle = new LifecycleSupport(this);
    protected PropertyChangeSupport support = new PropertyChangeSupport(this);
    protected Manager manager;

    @Override
    public String getInfo() {
        return info;
    }

    public String getStoreName() {
        return storeName;
    }

    @Override
    public void setManager(Manager manager) {
        Manager oldManager = this.manager;
        this.manager = manager;
        this.support.firePropertyChange("manager", oldManager, this.manager);
    }

    @Override
    public Manager getManager() {
        return this.manager;
    }

    @Override
    public void addLifecycleListener(LifecycleListener listener) {
        this.lifecycle.addLifecycleListener(listener);
    }

    @Override
    public LifecycleListener[] findLifecycleListeners() {
        return this.lifecycle.findLifecycleListeners();
    }

    @Override
    public void removeLifecycleListener(LifecycleListener listener) {
        this.lifecycle.removeLifecycleListener(listener);
    }

    @Override
    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.support.addPropertyChangeListener(listener);
    }

    @Override
    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.support.removePropertyChangeListener(listener);
    }

    public void processExpires() {
        String[] keys = null;
        if (!this.started) {
            return;
        }
        try {
            keys = this.keys();
        }
        catch (IOException e) {
            this.manager.getContainer().getLogger().error((Object)CatalinaMessages.MESSAGES.errorGettingKeys(), (Throwable)e);
            return;
        }
        if (this.manager.getContainer().getLogger().isDebugEnabled()) {
            this.manager.getContainer().getLogger().debug((Object)(this.getStoreName() + ": processExpires check number of " + keys.length + " sessions"));
        }
        long timeNow = System.currentTimeMillis();
        for (int i = 0; i < keys.length; ++i) {
            try {
                int timeIdle;
                StandardSession session = (StandardSession)this.load(keys[i]);
                if (session == null || (timeIdle = (int)((timeNow - session.getLastAccessedTime()) / 1000L)) < session.getMaxInactiveInterval()) continue;
                if (this.manager.getContainer().getLogger().isDebugEnabled()) {
                    this.manager.getContainer().getLogger().debug((Object)(this.getStoreName() + ": processExpires expire store session " + keys[i]));
                }
                if (((PersistentManagerBase)this.manager).isLoaded(keys[i])) {
                    session.recycle();
                } else {
                    session.expire();
                }
                this.remove(keys[i]);
                continue;
            }
            catch (Exception e) {
                this.manager.getContainer().getLogger().error((Object)CatalinaMessages.MESSAGES.errorProcessingSessionExpires(keys[i]), (Throwable)e);
                try {
                    this.remove(keys[i]);
                    continue;
                }
                catch (IOException e2) {
                    this.manager.getContainer().getLogger().error((Object)CatalinaMessages.MESSAGES.errorRemovingKey(keys[i]), (Throwable)e2);
                }
            }
        }
    }

    @Override
    public void start() throws LifecycleException {
        if (this.started) {
            throw new LifecycleException(CatalinaMessages.MESSAGES.storeAlreadyStarted());
        }
        this.lifecycle.fireLifecycleEvent("start", null);
        this.started = true;
    }

    @Override
    public void stop() throws LifecycleException {
        if (!this.started) {
            throw new LifecycleException(CatalinaMessages.MESSAGES.storeNotStarted());
        }
        this.lifecycle.fireLifecycleEvent("stop", null);
        this.started = false;
    }
}

