/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.valves;

import java.io.IOException;
import javax.management.MBeanRegistration;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import javax.servlet.ServletException;
import org.apache.catalina.Contained;
import org.apache.catalina.Container;
import org.apache.catalina.Context;
import org.apache.catalina.Engine;
import org.apache.catalina.Host;
import org.apache.catalina.Pipeline;
import org.apache.catalina.Valve;
import org.apache.catalina.Wrapper;
import org.apache.catalina.connector.Request;
import org.apache.catalina.connector.Response;
import org.apache.catalina.core.ContainerBase;
import org.jboss.servlet.http.HttpEvent;

public abstract class ValveBase
implements Contained,
Valve,
MBeanRegistration {
    protected Container container = null;
    protected static String info = "org.apache.catalina.core.ValveBase/1.0";
    protected Valve next = null;
    protected String domain;
    protected ObjectName oname;
    protected MBeanServer mserver;
    protected ObjectName controller;

    @Override
    public Container getContainer() {
        return this.container;
    }

    @Override
    public void setContainer(Container container) {
        this.container = container;
    }

    @Override
    public String getInfo() {
        return info;
    }

    @Override
    public Valve getNext() {
        return this.next;
    }

    @Override
    public void setNext(Valve valve) {
        this.next = valve;
    }

    @Override
    public void backgroundProcess() {
    }

    @Override
    public abstract void invoke(Request var1, Response var2) throws IOException, ServletException;

    @Override
    public void event(Request request, Response response, HttpEvent event) throws IOException, ServletException {
        this.getNext().event(request, response, event);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(this.getClass().getName());
        sb.append("[");
        if (this.container != null) {
            sb.append(this.container.getName());
        }
        sb.append("]");
        return sb.toString();
    }

    public ObjectName getObjectName() {
        return this.oname;
    }

    public void setObjectName(ObjectName oname) {
        this.oname = oname;
    }

    public String getDomain() {
        return this.domain;
    }

    @Override
    public ObjectName preRegister(MBeanServer server, ObjectName name) throws Exception {
        this.oname = name;
        this.mserver = server;
        this.domain = name.getDomain();
        return name;
    }

    @Override
    public void postRegister(Boolean registrationDone) {
    }

    @Override
    public void preDeregister() throws Exception {
    }

    @Override
    public void postDeregister() {
    }

    public ObjectName getController() {
        return this.controller;
    }

    public void setController(ObjectName controller) {
        this.controller = controller;
    }

    public ObjectName getParentName(ObjectName valveName) {
        return null;
    }

    public ObjectName createObjectName(String domain, ObjectName parent) throws MalformedObjectNameException {
        String className;
        int period;
        Container container = this.getContainer();
        if (container == null || !(container instanceof ContainerBase)) {
            return null;
        }
        ContainerBase containerBase = (ContainerBase)container;
        Pipeline pipe = containerBase.getPipeline();
        Valve[] valves = pipe.getValves();
        String parentName = "";
        if (!(container instanceof Engine)) {
            if (container instanceof Host) {
                parentName = ",host=" + container.getName();
            } else if (container instanceof Context) {
                String path = ((Context)container).getPath();
                if (path.length() < 1) {
                    path = "/";
                }
                Host host = (Host)container.getParent();
                parentName = ",path=" + path + ",host=" + host.getName();
            } else if (container instanceof Wrapper) {
                Context ctx = (Context)container.getParent();
                String path = ctx.getPath();
                if (path.length() < 1) {
                    path = "/";
                }
                Host host = (Host)ctx.getParent();
                parentName = ",servlet=" + container.getName() + ",path=" + path + ",host=" + host.getName();
            }
        }
        if ((period = (className = this.getClass().getName()).lastIndexOf(46)) >= 0) {
            className = className.substring(period + 1);
        }
        int seq = 0;
        for (int i = 0; i < valves.length && valves[i] != this; ++i) {
            if (valves[i] == null || valves[i].getClass() != this.getClass()) continue;
            ++seq;
        }
        String ext = "";
        if (seq > 0) {
            ext = ",seq=" + seq;
        }
        return new ObjectName(domain + ":type=Valve,name=" + className + ext + parentName);
    }

    public ObjectName getContainerName() {
        if (this.container == null) {
            return null;
        }
        return ((ContainerBase)this.container).getJmxName();
    }
}

