/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.core;

import java.io.IOException;
import java.io.PrintWriter;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import javax.servlet.RequestDispatcher;
import javax.servlet.Servlet;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.ServletRequest;
import javax.servlet.ServletRequestEvent;
import javax.servlet.ServletRequestListener;
import javax.servlet.ServletRequestWrapper;
import javax.servlet.ServletResponse;
import javax.servlet.ServletResponseWrapper;
import javax.servlet.UnavailableException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.catalina.Context;
import org.apache.catalina.Globals;
import org.apache.catalina.Wrapper;
import org.apache.catalina.connector.ClientAbortException;
import org.apache.catalina.connector.Request;
import org.apache.catalina.connector.RequestFacade;
import org.apache.catalina.connector.Response;
import org.apache.catalina.connector.ResponseFacade;
import org.apache.catalina.core.ApplicationFilterChain;
import org.apache.catalina.core.ApplicationFilterFactory;
import org.apache.catalina.core.ApplicationHttpRequest;
import org.apache.catalina.core.ApplicationHttpResponse;
import org.apache.catalina.core.ApplicationRequest;
import org.apache.catalina.core.ApplicationResponse;
import org.apache.catalina.core.StandardWrapper;
import org.apache.catalina.util.InstanceSupport;
import org.jboss.web.CatalinaMessages;

public final class ApplicationDispatcher
implements RequestDispatcher {
    private Context context = null;
    private static final String info = "org.apache.catalina.core.ApplicationDispatcher/1.0";
    private String name = null;
    private String pathInfo = null;
    private String queryString = null;
    private String requestPath = null;
    private String requestURI = null;
    private String servletPath = null;
    private InstanceSupport support = null;
    private Wrapper wrapper = null;

    public ApplicationDispatcher(Wrapper wrapper, String requestURI, String requestPath, String servletPath, String pathInfo, String queryString, String name) {
        this.wrapper = wrapper;
        this.context = (Context)wrapper.getParent();
        this.requestURI = requestURI;
        this.requestPath = requestPath;
        this.servletPath = servletPath;
        this.pathInfo = pathInfo;
        this.queryString = queryString;
        this.name = name;
        this.support = wrapper.getInstanceSupport();
    }

    public String getInfo() {
        return info;
    }

    public void invoke(ServletRequest request, ServletResponse response) throws ServletException, IOException {
        if (Globals.IS_SECURITY_ENABLED) {
            try {
                AccessController.doPrivileged(new PrivilegedInvoke(request, response));
            }
            catch (PrivilegedActionException pe) {
                Exception e = pe.getException();
                if (e instanceof ServletException) {
                    throw (ServletException)((Object)e);
                }
                throw (IOException)e;
            }
        } else {
            this.doInvoke(request, response);
        }
    }

    private void doInvoke(ServletRequest request, ServletResponse response) throws ServletException, IOException {
        State state = new State(request, response, false);
        if (Globals.STRICT_SERVLET_COMPLIANCE) {
            this.checkSameObjects(request, response);
        }
        this.wrapResponse(state);
        ApplicationHttpRequest wrequest = (ApplicationHttpRequest)this.wrapRequest(state);
        String contextPath = this.context.getPath();
        wrequest.setContextPath(contextPath);
        wrequest.setRequestURI(this.requestURI);
        wrequest.setServletPath(this.servletPath);
        wrequest.setPathInfo(this.pathInfo);
        if (this.queryString != null) {
            wrequest.setQueryString(this.queryString);
            wrequest.setQueryParams(this.queryString);
        }
        state.outerRequest.setAttribute("org.apache.catalina.core.DISPATCHER_REQUEST_PATH", (Object)this.requestPath);
        state.outerRequest.setAttribute("org.apache.catalina.core.DISPATCHER_TYPE", (Object)ApplicationFilterFactory.REQUEST_INTEGER);
        this.invoke(state.outerRequest, response, state);
    }

    public void async(ServletRequest request, ServletResponse response, boolean attributes) throws ServletException, IOException {
        if (Globals.IS_SECURITY_ENABLED) {
            try {
                AccessController.doPrivileged(new PrivilegedAsync(request, response, attributes));
            }
            catch (PrivilegedActionException pe) {
                Exception e = pe.getException();
                if (e instanceof ServletException) {
                    throw (ServletException)((Object)e);
                }
                throw (IOException)e;
            }
        } else {
            this.doAsync(request, response, attributes);
        }
    }

    private void doAsync(ServletRequest request, ServletResponse response, boolean attributes) throws ServletException, IOException {
        State state = new State(request, response, false);
        if (Globals.STRICT_SERVLET_COMPLIANCE) {
            this.checkSameObjects(request, response);
        }
        if (attributes) {
            this.wrapResponse(state);
            ApplicationHttpRequest wrequest = (ApplicationHttpRequest)this.wrapRequest(state);
            String contextPath = this.context.getPath();
            HttpServletRequest hrequest = state.hrequest;
            if (hrequest.getAttribute("javax.servlet.async.request_uri") == null) {
                wrequest.setAttribute("javax.servlet.async.request_uri", hrequest.getRequestURI());
                wrequest.setAttribute("javax.servlet.async.context_path", hrequest.getContextPath());
                wrequest.setAttribute("javax.servlet.async.servlet_path", hrequest.getServletPath());
                wrequest.setAttribute("javax.servlet.async.path_info", hrequest.getPathInfo());
                wrequest.setAttribute("javax.servlet.async.query_string", hrequest.getQueryString());
            }
            wrequest.setContextPath(contextPath);
            wrequest.setRequestURI(this.requestURI);
            wrequest.setServletPath(this.servletPath);
            wrequest.setPathInfo(this.pathInfo);
            if (this.queryString != null) {
                wrequest.setQueryString(this.queryString);
                wrequest.setQueryParams(this.queryString);
            }
        }
        state.outerRequest.setAttribute("org.apache.catalina.core.DISPATCHER_REQUEST_PATH", (Object)this.requestPath);
        state.outerRequest.setAttribute("org.apache.catalina.core.DISPATCHER_TYPE", (Object)ApplicationFilterFactory.ASYNC_INTEGER);
        this.invoke(state.outerRequest, response, state);
    }

    public void forward(ServletRequest request, ServletResponse response) throws ServletException, IOException {
        if (Globals.IS_SECURITY_ENABLED) {
            try {
                PrivilegedForward dp = new PrivilegedForward(request, response);
                AccessController.doPrivileged(dp);
            }
            catch (PrivilegedActionException pe) {
                Exception e = pe.getException();
                if (e instanceof ServletException) {
                    throw (ServletException)((Object)e);
                }
                throw (IOException)e;
            }
        } else {
            this.doForward(request, response);
        }
    }

    private void doForward(ServletRequest request, ServletResponse response) throws ServletException, IOException {
        ApplicationHttpRequest wrequest;
        if (response.isCommitted()) {
            throw CatalinaMessages.MESSAGES.cannotForwardAfterCommit();
        }
        response.resetBuffer();
        State state = new State(request, response, false);
        if (Globals.STRICT_SERVLET_COMPLIANCE) {
            this.checkSameObjects(request, response);
        }
        this.wrapResponse(state);
        if (this.servletPath == null && this.pathInfo == null) {
            wrequest = (ApplicationHttpRequest)this.wrapRequest(state);
            HttpServletRequest hrequest = state.hrequest;
            wrequest.setRequestURI(hrequest.getRequestURI());
            wrequest.setContextPath(hrequest.getContextPath());
            wrequest.setServletPath(hrequest.getServletPath());
            wrequest.setPathInfo(hrequest.getPathInfo());
            wrequest.setQueryString(hrequest.getQueryString());
            this.processRequest(request, response, state);
        } else {
            wrequest = (ApplicationHttpRequest)this.wrapRequest(state);
            String contextPath = this.context.getPath();
            HttpServletRequest hrequest = state.hrequest;
            if (hrequest.getAttribute("javax.servlet.forward.request_uri") == null) {
                wrequest.setAttribute("javax.servlet.forward.request_uri", hrequest.getRequestURI());
                wrequest.setAttribute("javax.servlet.forward.context_path", hrequest.getContextPath());
                wrequest.setAttribute("javax.servlet.forward.servlet_path", hrequest.getServletPath());
                wrequest.setAttribute("javax.servlet.forward.path_info", hrequest.getPathInfo());
                wrequest.setAttribute("javax.servlet.forward.query_string", hrequest.getQueryString());
            }
            wrequest.setContextPath(contextPath);
            wrequest.setRequestURI(this.requestURI);
            wrequest.setServletPath(this.servletPath);
            wrequest.setPathInfo(this.pathInfo);
            if (this.queryString != null) {
                wrequest.setQueryString(this.queryString);
                wrequest.setQueryParams(this.queryString);
            }
            this.processRequest(request, response, state);
        }
        if (request.getAsyncContext() != null) {
            return;
        }
        if (this.wrapper.getLogger().isDebugEnabled()) {
            this.wrapper.getLogger().debug((Object)" Disabling the response for futher output");
        }
        if (response instanceof ResponseFacade) {
            ((ResponseFacade)response).finish();
        } else {
            if (this.wrapper.getLogger().isDebugEnabled()) {
                this.wrapper.getLogger().debug((Object)(" The Response is vehiculed using a wrapper: " + response.getClass().getName()));
            }
            try {
                PrintWriter writer = response.getWriter();
                writer.close();
            }
            catch (IllegalStateException e) {
                try {
                    ServletOutputStream stream = response.getOutputStream();
                    stream.close();
                }
                catch (IllegalStateException f) {
                }
                catch (IOException f) {}
            }
            catch (IOException e) {
                // empty catch block
            }
        }
    }

    private void processRequest(ServletRequest request, ServletResponse response, State state) throws IOException, ServletException {
        Integer disInt = (Integer)request.getAttribute("org.apache.catalina.core.DISPATCHER_TYPE");
        if (disInt != null) {
            if (disInt != ApplicationFilterFactory.ERROR_INTEGER) {
                state.outerRequest.setAttribute("org.apache.catalina.core.DISPATCHER_REQUEST_PATH", (Object)this.requestPath);
                state.outerRequest.setAttribute("org.apache.catalina.core.DISPATCHER_TYPE", (Object)ApplicationFilterFactory.FORWARD_INTEGER);
                this.invoke(state.outerRequest, response, state);
            } else {
                this.invoke(state.outerRequest, response, state);
            }
        }
    }

    public void include(ServletRequest request, ServletResponse response) throws ServletException, IOException {
        if (Globals.IS_SECURITY_ENABLED) {
            try {
                PrivilegedInclude dp = new PrivilegedInclude(request, response);
                AccessController.doPrivileged(dp);
            }
            catch (PrivilegedActionException pe) {
                Exception e = pe.getException();
                if (e instanceof ServletException) {
                    throw (ServletException)((Object)e);
                }
                throw (IOException)e;
            }
        } else {
            this.doInclude(request, response);
        }
    }

    private void doInclude(ServletRequest request, ServletResponse response) throws ServletException, IOException {
        State state = new State(request, response, true);
        if (Globals.STRICT_SERVLET_COMPLIANCE) {
            this.checkSameObjects(request, response);
        }
        this.wrapResponse(state);
        if (this.name != null) {
            ApplicationHttpRequest wrequest = (ApplicationHttpRequest)this.wrapRequest(state);
            wrequest.setAttribute("org.apache.catalina.NAMED", this.name);
            if (this.servletPath != null) {
                wrequest.setServletPath(this.servletPath);
            }
            wrequest.setAttribute("org.apache.catalina.core.DISPATCHER_TYPE", ApplicationFilterFactory.INCLUDE_INTEGER);
            wrequest.setAttribute("org.apache.catalina.core.DISPATCHER_REQUEST_PATH", this.requestPath);
            this.invoke(state.outerRequest, state.outerResponse, state);
        } else {
            ApplicationHttpRequest wrequest = (ApplicationHttpRequest)this.wrapRequest(state);
            String contextPath = this.context.getPath();
            if (this.requestURI != null) {
                wrequest.setAttribute("javax.servlet.include.request_uri", this.requestURI);
            }
            if (contextPath != null) {
                wrequest.setAttribute("javax.servlet.include.context_path", contextPath);
            }
            if (this.servletPath != null) {
                wrequest.setAttribute("javax.servlet.include.servlet_path", this.servletPath);
            }
            if (this.pathInfo != null) {
                wrequest.setAttribute("javax.servlet.include.path_info", this.pathInfo);
            }
            if (this.queryString != null) {
                wrequest.setAttribute("javax.servlet.include.query_string", this.queryString);
                wrequest.setQueryParams(this.queryString);
            }
            wrequest.setAttribute("org.apache.catalina.core.DISPATCHER_TYPE", ApplicationFilterFactory.INCLUDE_INTEGER);
            wrequest.setAttribute("org.apache.catalina.core.DISPATCHER_REQUEST_PATH", this.requestPath);
            this.invoke(state.outerRequest, state.outerResponse, state);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void invoke(ServletRequest request, ServletResponse response, State state) throws IOException, ServletException {
        HttpServletResponse hresponse = state.hresponse;
        Servlet servlet = null;
        IOException ioException = null;
        Throwable servletException = null;
        RuntimeException runtimeException = null;
        boolean unavailable = false;
        ClassLoader oldCCL = Thread.currentThread().getContextClassLoader();
        ClassLoader contextClassLoader = this.context.getLoader().getClassLoader();
        ServletRequestEvent event = null;
        Object[] instances = this.context.getApplicationEventListeners();
        if (oldCCL != contextClassLoader) {
            Thread.currentThread().setContextClassLoader(contextClassLoader);
            this.context.getThreadBindingListener().bind();
            if (instances != null && instances.length > 0) {
                event = new ServletRequestEvent(this.context.getServletContext(), request);
                for (int i = 0; i < instances.length; ++i) {
                    if (instances[i] == null || !(instances[i] instanceof ServletRequestListener)) continue;
                    ServletRequestListener listener = (ServletRequestListener)instances[i];
                    try {
                        listener.requestInitialized(event);
                        continue;
                    }
                    catch (Throwable t) {
                        this.context.getLogger().error((Object)CatalinaMessages.MESSAGES.requestListenerInitException(instances[i].getClass().getName()), t);
                        request.setAttribute("javax.servlet.error.exception", (Object)t);
                        servletException = new ServletException(CatalinaMessages.MESSAGES.requestListenerInitException(instances[i].getClass().getName()), t);
                    }
                }
            }
        } else {
            oldCCL = null;
        }
        if (this.wrapper.isUnavailable()) {
            this.wrapper.getLogger().warn((Object)CatalinaMessages.MESSAGES.servletIsUnavailable(this.wrapper.getName()));
            long available = this.wrapper.getAvailable();
            if (available > 0L && available < Long.MAX_VALUE) {
                hresponse.setDateHeader("Retry-After", available);
            }
            hresponse.sendError(503, CatalinaMessages.MESSAGES.servletIsUnavailable(this.wrapper.getName()));
            unavailable = true;
        }
        try {
            if (!unavailable) {
                servlet = this.wrapper.allocate();
            }
        }
        catch (ServletException e) {
            this.wrapper.getLogger().error((Object)CatalinaMessages.MESSAGES.servletAllocateException(this.wrapper.getName()), StandardWrapper.getRootCause(e));
            servletException = e;
            servlet = null;
        }
        catch (Throwable e) {
            this.wrapper.getLogger().error((Object)CatalinaMessages.MESSAGES.servletAllocateException(this.wrapper.getName()), e);
            servletException = new ServletException(CatalinaMessages.MESSAGES.servletAllocateException(this.wrapper.getName()), e);
            servlet = null;
        }
        ApplicationFilterFactory factory = ApplicationFilterFactory.getInstance();
        ApplicationFilterChain filterChain = factory.createFilterChain(request, this.wrapper, servlet);
        String jspFile = this.wrapper.getJspFile();
        try {
            if (jspFile != null) {
                request.setAttribute("org.apache.catalina.jsp_file", (Object)jspFile);
            } else {
                request.removeAttribute("org.apache.catalina.jsp_file");
            }
            this.support.fireInstanceEvent("beforeDispatch", servlet, request, response);
            if (servlet != null && filterChain != null) {
                filterChain.doFilter(request, response);
            }
        }
        catch (ClientAbortException e) {
            ioException = e;
        }
        catch (IOException e) {
            this.wrapper.getLogger().error((Object)CatalinaMessages.MESSAGES.servletServiceException(this.wrapper.getName()), (Throwable)e);
            ioException = e;
        }
        catch (UnavailableException e) {
            this.wrapper.getLogger().error((Object)CatalinaMessages.MESSAGES.servletServiceException(this.wrapper.getName()), (Throwable)e);
            servletException = e;
            this.wrapper.unavailable(e);
        }
        catch (ServletException e) {
            Throwable rootCause = StandardWrapper.getRootCause(e);
            if (!(rootCause instanceof ClientAbortException)) {
                this.wrapper.getLogger().error((Object)CatalinaMessages.MESSAGES.servletServiceException(this.wrapper.getName()), rootCause);
            }
            servletException = e;
        }
        catch (RuntimeException e) {
            this.wrapper.getLogger().error((Object)CatalinaMessages.MESSAGES.servletServiceException(this.wrapper.getName()), (Throwable)e);
            runtimeException = e;
        }
        finally {
            if (jspFile != null) {
                request.removeAttribute("org.apache.catalina.jsp_file");
            }
            this.support.fireInstanceEvent("afterDispatch", servlet, request, response);
        }
        if (filterChain != null) {
            filterChain.release();
        }
        try {
            if (servlet != null) {
                this.wrapper.deallocate(servlet);
            }
        }
        catch (ServletException e) {
            this.wrapper.getLogger().error((Object)CatalinaMessages.MESSAGES.servletDeallocateException(this.wrapper.getName()), (Throwable)e);
            servletException = e;
        }
        catch (Throwable e) {
            this.wrapper.getLogger().error((Object)CatalinaMessages.MESSAGES.servletDeallocateException(this.wrapper.getName()), e);
            servletException = new ServletException(CatalinaMessages.MESSAGES.servletDeallocateException(this.wrapper.getName()), e);
        }
        if (oldCCL != null) {
            if (instances != null && instances.length > 0) {
                for (int i = instances.length - 1; i >= 0; --i) {
                    if (instances[i] == null || !(instances[i] instanceof ServletRequestListener)) continue;
                    ServletRequestListener listener = (ServletRequestListener)instances[i];
                    try {
                        listener.requestDestroyed(event);
                        continue;
                    }
                    catch (Throwable t) {
                        this.context.getLogger().error((Object)CatalinaMessages.MESSAGES.requestListenerDestroyException(instances[i].getClass().getName()), t);
                        request.setAttribute("javax.servlet.error.exception", (Object)t);
                        servletException = new ServletException(CatalinaMessages.MESSAGES.requestListenerDestroyException(instances[i].getClass().getName()), t);
                    }
                }
            }
            this.context.getThreadBindingListener().unbind();
            Thread.currentThread().setContextClassLoader(oldCCL);
        }
        this.unwrapRequest(state);
        this.unwrapResponse(state);
        this.recycleRequestWrapper(state);
        if (ioException != null) {
            throw ioException;
        }
        if (servletException != null) {
            throw servletException;
        }
        if (runtimeException != null) {
            throw runtimeException;
        }
    }

    private void unwrapRequest(State state) {
        if (state.wrapRequest == null) {
            return;
        }
        ServletRequest previous = null;
        ServletRequest current = state.outerRequest;
        while (current != null && !(current instanceof Request) && !(current instanceof RequestFacade)) {
            if (current == state.wrapRequest) {
                ServletRequest next = ((ServletRequestWrapper)current).getRequest();
                if (previous == null) {
                    state.outerRequest = next;
                    break;
                }
                ((ServletRequestWrapper)previous).setRequest(next);
                break;
            }
            previous = current;
            current = ((ServletRequestWrapper)current).getRequest();
        }
    }

    private void unwrapResponse(State state) {
        if (state.wrapResponse == null) {
            return;
        }
        ServletResponse previous = null;
        ServletResponse current = state.outerResponse;
        while (current != null && !(current instanceof Response) && !(current instanceof ResponseFacade)) {
            if (current == state.wrapResponse) {
                ServletResponse next = ((ServletResponseWrapper)current).getResponse();
                if (previous == null) {
                    state.outerResponse = next;
                    break;
                }
                ((ServletResponseWrapper)previous).setResponse(next);
                break;
            }
            previous = current;
            current = ((ServletResponseWrapper)current).getResponse();
        }
    }

    private ServletRequest wrapRequest(State state) {
        ServletRequest previous = null;
        ServletRequest current = state.outerRequest;
        while (current != null) {
            if (state.hrequest == null && current instanceof HttpServletRequest) {
                state.hrequest = (HttpServletRequest)current;
            }
            if (!(current instanceof ServletRequestWrapper) || current instanceof ApplicationHttpRequest || current instanceof ApplicationRequest) break;
            previous = current;
            current = ((ServletRequestWrapper)current).getRequest();
        }
        Object wrapper = null;
        if (current instanceof ApplicationHttpRequest || current instanceof HttpServletRequest) {
            HttpServletRequest hcurrent = (HttpServletRequest)current;
            boolean crossContext = false;
            if (state.outerRequest instanceof HttpServletRequest) {
                HttpServletRequest houterRequest = (HttpServletRequest)state.outerRequest;
                Object contextPath = houterRequest.getAttribute("javax.servlet.include.context_path");
                if (contextPath == null) {
                    contextPath = houterRequest.getContextPath();
                }
                crossContext = !this.context.getPath().equals(contextPath);
            }
            wrapper = new ApplicationHttpRequest(hcurrent, this.context, crossContext);
        } else {
            wrapper = new ApplicationRequest(current);
        }
        if (previous == null) {
            state.outerRequest = wrapper;
        } else {
            ((ServletRequestWrapper)previous).setRequest((ServletRequest)wrapper);
        }
        state.wrapRequest = wrapper;
        return wrapper;
    }

    private ServletResponse wrapResponse(State state) {
        ServletResponse previous = null;
        ServletResponse current = state.outerResponse;
        while (current != null) {
            if (state.hresponse == null && current instanceof HttpServletResponse) {
                state.hresponse = (HttpServletResponse)current;
                if (!state.including) {
                    return null;
                }
            }
            if (!(current instanceof ServletResponseWrapper) || current instanceof ApplicationHttpResponse || current instanceof ApplicationResponse) break;
            previous = current;
            current = ((ServletResponseWrapper)current).getResponse();
        }
        Object wrapper = null;
        wrapper = current instanceof HttpServletResponse ? new ApplicationHttpResponse((HttpServletResponse)current, state.including) : new ApplicationResponse(current, state.including);
        if (previous == null) {
            state.outerResponse = wrapper;
        } else {
            ((ServletResponseWrapper)previous).setResponse((ServletResponse)wrapper);
        }
        state.wrapResponse = wrapper;
        return wrapper;
    }

    private void checkSameObjects(ServletRequest appRequest, ServletResponse appResponse) throws ServletException {
        ServletRequest originalRequest = ApplicationFilterChain.getLastServicedRequest();
        ServletResponse originalResponse = ApplicationFilterChain.getLastServicedResponse();
        if (originalRequest == null || originalResponse == null) {
            return;
        }
        boolean same = false;
        ServletRequest dispatchedRequest = appRequest;
        while (originalRequest instanceof ServletRequestWrapper && ((ServletRequestWrapper)originalRequest).getRequest() != null) {
            originalRequest = ((ServletRequestWrapper)originalRequest).getRequest();
        }
        while (!same) {
            if (originalRequest.equals(dispatchedRequest)) {
                same = true;
            }
            if (same || !(dispatchedRequest instanceof ServletRequestWrapper)) break;
            dispatchedRequest = ((ServletRequestWrapper)dispatchedRequest).getRequest();
        }
        if (!same) {
            throw new ServletException(CatalinaMessages.MESSAGES.notOriginalRequestInDispatcher());
        }
        same = false;
        ServletResponse dispatchedResponse = appResponse;
        while (originalResponse instanceof ServletResponseWrapper && ((ServletResponseWrapper)originalResponse).getResponse() != null) {
            originalResponse = ((ServletResponseWrapper)originalResponse).getResponse();
        }
        while (!same) {
            if (originalResponse.equals(dispatchedResponse)) {
                same = true;
            }
            if (same || !(dispatchedResponse instanceof ServletResponseWrapper)) break;
            dispatchedResponse = ((ServletResponseWrapper)dispatchedResponse).getResponse();
        }
        if (!same) {
            throw new ServletException(CatalinaMessages.MESSAGES.notOriginalResponseInDispatcher());
        }
    }

    private void recycleRequestWrapper(State state) {
        if (state.wrapRequest instanceof ApplicationHttpRequest) {
            ((ApplicationHttpRequest)state.wrapRequest).recycle();
        }
    }

    private static class State {
        ServletRequest outerRequest = null;
        ServletResponse outerResponse = null;
        ServletRequest wrapRequest = null;
        ServletResponse wrapResponse = null;
        boolean including = false;
        HttpServletRequest hrequest = null;
        HttpServletResponse hresponse = null;

        State(ServletRequest request, ServletResponse response, boolean including) {
            this.outerRequest = request;
            this.outerResponse = response;
            this.including = including;
        }
    }

    protected class PrivilegedAsync
    implements PrivilegedExceptionAction {
        private ServletRequest request;
        private ServletResponse response;
        private boolean attributes;

        PrivilegedAsync(ServletRequest request, ServletResponse response, boolean attributes) {
            this.request = request;
            this.response = response;
            this.attributes = attributes;
        }

        public Object run() throws ServletException, IOException {
            ApplicationDispatcher.this.doAsync(this.request, this.response, this.attributes);
            return null;
        }
    }

    protected class PrivilegedInvoke
    implements PrivilegedExceptionAction {
        private ServletRequest request;
        private ServletResponse response;

        PrivilegedInvoke(ServletRequest request, ServletResponse response) {
            this.request = request;
            this.response = response;
        }

        public Object run() throws ServletException, IOException {
            ApplicationDispatcher.this.doInvoke(this.request, this.response);
            return null;
        }
    }

    protected class PrivilegedInclude
    implements PrivilegedExceptionAction {
        private ServletRequest request;
        private ServletResponse response;

        PrivilegedInclude(ServletRequest request, ServletResponse response) {
            this.request = request;
            this.response = response;
        }

        public Object run() throws ServletException, IOException {
            ApplicationDispatcher.this.doInclude(this.request, this.response);
            return null;
        }
    }

    protected class PrivilegedForward
    implements PrivilegedExceptionAction {
        private ServletRequest request;
        private ServletResponse response;

        PrivilegedForward(ServletRequest request, ServletResponse response) {
            this.request = request;
            this.response = response;
        }

        public Object run() throws Exception {
            ApplicationDispatcher.this.doForward(this.request, this.response);
            return null;
        }
    }
}

