/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.valves;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.security.NoSuchProviderException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import javax.servlet.ServletException;
import org.apache.catalina.connector.Request;
import org.apache.catalina.connector.Response;
import org.apache.catalina.valves.ValveBase;
import org.apache.tomcat.util.buf.EncodingToCharset;
import org.jboss.web.CatalinaLogger;

public class SSLValve
extends ValveBase {
    protected String sslClientCertHeader = "ssl_client_cert";
    protected String sslCipherHeader = "ssl_cipher";
    protected String sslSessionIdHeader = "ssl_session_id";
    protected String sslCipherUserKeySizeHeader = "ssl_cipher_usekeysize";

    public String mygetHeader(Request request, String header) {
        String strcert0 = request.getHeader(header);
        if (strcert0 == null) {
            return null;
        }
        if ("(null)".equals(strcert0)) {
            return null;
        }
        return strcert0;
    }

    @Override
    public void invoke(Request request, Response response) throws IOException, ServletException {
        String strcert0 = this.mygetHeader(request, this.sslClientCertHeader);
        if (strcert0 != null && strcert0.length() > 28) {
            String strcert1 = strcert0.replace(' ', '\n');
            String strcert2 = strcert1.substring(28, strcert1.length() - 26);
            String strcert3 = "-----BEGIN CERTIFICATE-----\n";
            String strcert4 = strcert3.concat(strcert2);
            String strcerts = strcert4.concat("\n-----END CERTIFICATE-----\n");
            ByteArrayInputStream bais = new ByteArrayInputStream(strcerts.getBytes(EncodingToCharset.ISO_8859_1));
            X509Certificate[] jsseCerts = null;
            String providerName = (String)request.getConnector().getProperty("clientCertProvider");
            try {
                CertificateFactory cf = providerName == null ? CertificateFactory.getInstance("X.509") : CertificateFactory.getInstance("X.509", providerName);
                X509Certificate cert = (X509Certificate)cf.generateCertificate(bais);
                jsseCerts = new X509Certificate[]{cert};
            }
            catch (CertificateException e) {
                CatalinaLogger.VALVES_LOGGER.certificateProcessingFailed(strcerts, e);
            }
            catch (NoSuchProviderException e) {
                CatalinaLogger.VALVES_LOGGER.missingSecurityProvider(providerName, e);
            }
            request.setAttribute("javax.servlet.request.X509Certificate", jsseCerts);
        }
        if ((strcert0 = this.mygetHeader(request, this.sslCipherHeader)) != null) {
            request.setAttribute("javax.servlet.request.cipher_suite", strcert0);
        }
        if ((strcert0 = this.mygetHeader(request, this.sslSessionIdHeader)) != null) {
            request.setAttribute("javax.servlet.request.ssl_session_id", strcert0);
        }
        if ((strcert0 = this.mygetHeader(request, this.sslCipherUserKeySizeHeader)) != null) {
            request.setAttribute("javax.servlet.request.key_size", Integer.valueOf(strcert0));
        }
        this.getNext().invoke(request, response);
    }

    public String getSslClientCertHeader() {
        return this.sslClientCertHeader;
    }

    public void setSslClientCertHeader(String sslClientCertHeader) {
        this.sslClientCertHeader = sslClientCertHeader;
    }

    public String getSslCipherHeader() {
        return this.sslCipherHeader;
    }

    public void setSslCipherHeader(String sslCipherHeader) {
        this.sslCipherHeader = sslCipherHeader;
    }

    public String getSslSessionIdHeader() {
        return this.sslSessionIdHeader;
    }

    public void setSslSessionIdHeader(String sslSessionIdHeader) {
        this.sslSessionIdHeader = sslSessionIdHeader;
    }

    public String getSslCipherUserKeySizeHeader() {
        return this.sslCipherUserKeySizeHeader;
    }

    public void setSslCipherUserKeySizeHeader(String sslCipherUserKeySizeHeader) {
        this.sslCipherUserKeySizeHeader = sslCipherUserKeySizeHeader;
    }
}

