/*
 * Decompiled with CFR 0.152.
 */
package org.apache.coyote.http11;

import java.io.EOFException;
import java.io.IOException;
import java.net.SocketTimeoutException;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.CompletionHandler;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import org.apache.coyote.InputBuffer;
import org.apache.coyote.Request;
import org.apache.coyote.http11.AbstractInternalInputBuffer;
import org.apache.coyote.http11.Http11NioProcessor;
import org.apache.coyote.http11.upgrade.servlet31.ReadListener;
import org.apache.tomcat.util.buf.ByteChunk;
import org.apache.tomcat.util.net.NioChannel;
import org.apache.tomcat.util.net.NioEndpoint;
import org.apache.tomcat.util.net.SocketStatus;
import org.jboss.web.CoyoteLogger;
import org.jboss.web.CoyoteMessages;

public class InternalNioInputBuffer
extends AbstractInternalInputBuffer {
    protected NioChannel channel;
    protected boolean nonBlocking = false;
    protected boolean available = true;
    protected NioEndpoint endpoint = null;
    protected Http11NioProcessor processor;
    private CompletionHandler<Integer, NioChannel> completionHandler;
    private Semaphore semaphore = new Semaphore(1);
    private ReadListener listener = null;

    public InternalNioInputBuffer(Http11NioProcessor processor, Request request, int headerBufferSize, NioEndpoint endpoint) {
        super(request, headerBufferSize);
        this.endpoint = endpoint;
        this.processor = processor;
        this.init();
    }

    protected void init() {
        this.inputBuffer = new InputBufferImpl();
        this.readTimeout = this.endpoint.getSoTimeout() > 0 ? this.endpoint.getSoTimeout() : Integer.MAX_VALUE;
        this.completionHandler = new CompletionHandler<Integer, NioChannel>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void completed(Integer nBytes, NioChannel attachment) {
                if (nBytes < 0) {
                    this.failed((Throwable)new ClosedChannelException(), attachment);
                    return;
                }
                boolean notify = false;
                CompletionHandler completionHandler = InternalNioInputBuffer.this.completionHandler;
                synchronized (completionHandler) {
                    if (nBytes > 0) {
                        InternalNioInputBuffer.this.bbuf.flip();
                        if (nBytes > InternalNioInputBuffer.this.buf.length - InternalNioInputBuffer.this.end) {
                            InternalNioInputBuffer.this.buf = new byte[InternalNioInputBuffer.this.buf.length];
                            InternalNioInputBuffer.this.lastValid = InternalNioInputBuffer.this.pos = (InternalNioInputBuffer.this.end = 0);
                        }
                        InternalNioInputBuffer.this.bbuf.get(InternalNioInputBuffer.this.buf, InternalNioInputBuffer.this.pos, nBytes);
                        InternalNioInputBuffer.this.lastValid = InternalNioInputBuffer.this.pos + nBytes;
                        InternalNioInputBuffer.this.semaphore.release();
                        if (InternalNioInputBuffer.this.processor.getReadNotifications() && InternalNioInputBuffer.this.available) {
                            InternalNioInputBuffer.this.available = false;
                            notify = true;
                        }
                    }
                }
                if (notify && !InternalNioInputBuffer.this.endpoint.processChannel(attachment, SocketStatus.OPEN_READ)) {
                    InternalNioInputBuffer.this.endpoint.closeChannel(attachment);
                }
            }

            @Override
            public void failed(Throwable exc, NioChannel attachment) {
                InternalNioInputBuffer.this.processor.getResponse().setErrorException(exc);
                InternalNioInputBuffer.this.endpoint.removeEventChannel(attachment);
                InternalNioInputBuffer.this.semaphore.release();
                if (!InternalNioInputBuffer.this.endpoint.processChannel(attachment, SocketStatus.ERROR)) {
                    InternalNioInputBuffer.this.endpoint.closeChannel(attachment);
                }
            }
        };
    }

    public void setChannel(NioChannel channel) {
        this.channel = channel;
    }

    public NioChannel getChannel() {
        return this.channel;
    }

    public void setNonBlocking(boolean nonBlocking) {
        this.nonBlocking = nonBlocking;
    }

    public boolean getNonBlocking() {
        return this.nonBlocking;
    }

    public void setReadListener(ReadListener listener) {
        this.listener = listener;
    }

    @Override
    public void recycle() {
        super.recycle();
        this.bbuf.clear();
        this.listener = null;
        this.channel = null;
        this.available = true;
        this.readTimeout = this.endpoint.getSoTimeout() > 0 ? this.endpoint.getSoTimeout() : Integer.MAX_VALUE;
    }

    @Override
    public boolean nextRequest() {
        boolean result = super.nextRequest();
        this.available = true;
        if (this.nonBlocking) {
            this.semaphore.release();
        }
        this.nonBlocking = false;
        return result;
    }

    public boolean parseRequestLine(boolean useAvailableData) throws IOException {
        int start = 0;
        byte chr = 0;
        do {
            if (this.pos < this.lastValid) continue;
            if (useAvailableData) {
                return false;
            }
            if (this.fill()) continue;
            throw new EOFException(CoyoteMessages.MESSAGES.eofError());
        } while ((chr = this.buf[this.pos++]) == 13 || chr == 10);
        --this.pos;
        start = this.pos;
        if (this.pos >= this.lastValid) {
            if (useAvailableData) {
                return false;
            }
            if (!this.fill()) {
                throw new EOFException(CoyoteMessages.MESSAGES.eofError());
            }
        }
        boolean space = false;
        while (!space) {
            if (this.pos >= this.lastValid && !this.fill()) {
                throw new EOFException(CoyoteMessages.MESSAGES.eofError());
            }
            if (this.buf[this.pos] == 32 || this.buf[this.pos] == 9) {
                space = true;
                this.request.method().setBytes(this.buf, start, this.pos - start);
            }
            ++this.pos;
        }
        while (space) {
            if (this.pos >= this.lastValid && !this.fill()) {
                throw new EOFException(CoyoteMessages.MESSAGES.eofError());
            }
            if (this.buf[this.pos] == 32 || this.buf[this.pos] == 9) {
                ++this.pos;
                continue;
            }
            space = false;
        }
        start = this.pos;
        int end = 0;
        int questionPos = -1;
        boolean eol = false;
        while (!space) {
            if (this.pos >= this.lastValid && !this.fill()) {
                throw new EOFException(CoyoteMessages.MESSAGES.eofError());
            }
            if (this.buf[this.pos] == 32 || this.buf[this.pos] == 9) {
                space = true;
                end = this.pos;
            } else if (this.buf[this.pos] == 13 || this.buf[this.pos] == 10) {
                eol = true;
                space = true;
                end = this.pos;
            } else if (this.buf[this.pos] == 63 && questionPos == -1) {
                questionPos = this.pos;
            }
            ++this.pos;
        }
        this.request.unparsedURI().setBytes(this.buf, start, end - start);
        if (questionPos >= 0) {
            this.request.queryString().setBytes(this.buf, questionPos + 1, end - questionPos - 1);
            this.request.requestURI().setBytes(this.buf, start, questionPos - start);
        } else {
            this.request.requestURI().setBytes(this.buf, start, end - start);
        }
        while (space) {
            if (this.pos >= this.lastValid && !this.fill()) {
                throw new EOFException(CoyoteMessages.MESSAGES.eofError());
            }
            if (this.buf[this.pos] == 32 || this.buf[this.pos] == 9) {
                ++this.pos;
                continue;
            }
            space = false;
        }
        start = this.pos;
        end = 0;
        while (!eol) {
            if (this.pos >= this.lastValid && !this.fill()) {
                throw new EOFException(CoyoteMessages.MESSAGES.eofError());
            }
            if (this.buf[this.pos] == 13) {
                end = this.pos;
            } else if (this.buf[this.pos] == 10) {
                if (end == 0) {
                    end = this.pos;
                }
                eol = true;
            }
            ++this.pos;
        }
        if (end - start > 0) {
            this.request.protocol().setBytes(this.buf, start, end - start);
        } else {
            this.request.protocol().setString("");
        }
        return true;
    }

    public void useAvailable() {
        this.available = true;
    }

    public boolean available() {
        return this.lastValid - this.pos > 0;
    }

    @Override
    public int doRead(ByteChunk chunk, Request req) throws IOException {
        return this.lastActiveFilter == -1 ? this.inputBuffer.doRead(chunk, req) : this.activeFilters[this.lastActiveFilter].doRead(chunk, req);
    }

    @Override
    protected boolean fill() throws IOException {
        return this.fill0() >= 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int fill0() throws IOException {
        int nRead;
        block23: {
            nRead = 0;
            if (this.nonBlocking) {
                if (this.semaphore.tryAcquire()) {
                    CompletionHandler<Integer, NioChannel> completionHandler = this.completionHandler;
                    synchronized (completionHandler) {
                        boolean available0;
                        block22: {
                            this.prepare();
                            available0 = this.available;
                            this.available = false;
                            try {
                                this.channel.read(this.bbuf, this.readTimeout, TimeUnit.MILLISECONDS, this.channel, this.completionHandler);
                            }
                            catch (Exception e) {
                                this.processor.getResponse().setErrorException(e);
                                if (!CoyoteLogger.HTTP_LOGGER.isDebugEnabled()) break block22;
                                CoyoteLogger.HTTP_LOGGER.errorWithNonBlockingRead(e);
                            }
                        }
                        nRead = this.lastValid - this.pos;
                        this.available = nRead > 0 ? false : available0;
                    }
                }
                CompletionHandler<Integer, NioChannel> completionHandler = this.completionHandler;
                synchronized (completionHandler) {
                    if (nRead == 0 && !this.available) {
                        try {
                            if (this.semaphore.tryAcquire(this.readTimeout, unit)) {
                                this.semaphore.release();
                            }
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                        nRead = this.lastValid - this.pos;
                    }
                }
            }
            this.prepare();
            try {
                nRead = this.channel.readBytes(this.bbuf, this.readTimeout, unit);
            }
            catch (Exception e) {
                if (!CoyoteLogger.HTTP_LOGGER.isDebugEnabled()) break block23;
                CoyoteLogger.HTTP_LOGGER.errorWithBlockingRead(e);
            }
        }
        if (nRead > 0) {
            this.bbuf.flip();
            if (nRead > this.buf.length - this.end) {
                this.buf = new byte[this.buf.length];
                this.lastValid = this.pos = (this.end = 0);
            }
            this.bbuf.get(this.buf, this.pos, nRead);
            this.lastValid = this.pos + nRead;
        } else {
            if (nRead == -1) {
                throw new EOFException(CoyoteMessages.MESSAGES.failedRead());
            }
            if (nRead == -2) {
                throw new SocketTimeoutException(CoyoteMessages.MESSAGES.failedRead());
            }
            if (nRead == 0) {
                throw new EOFException(CoyoteMessages.MESSAGES.failedRead());
            }
        }
        return nRead;
    }

    private void prepare() {
        this.bbuf.clear();
        if (this.parsingHeader) {
            if (this.lastValid == this.buf.length) {
                throw CoyoteMessages.MESSAGES.requestHeaderTooLarge();
            }
        } else {
            this.lastValid = this.pos = this.end;
        }
    }

    protected class InputBufferImpl
    implements InputBuffer {
        protected InputBufferImpl() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int doRead(ByteChunk chunk, Request req) throws IOException {
            if (InternalNioInputBuffer.this.pos >= InternalNioInputBuffer.this.lastValid) {
                int nRead = InternalNioInputBuffer.this.fill0();
                if (nRead < 0) {
                    return -1;
                }
                if (nRead == 0) {
                    return 0;
                }
            }
            if (InternalNioInputBuffer.this.nonBlocking) {
                CompletionHandler nRead = InternalNioInputBuffer.this.completionHandler;
                synchronized (nRead) {
                    int length = InternalNioInputBuffer.this.lastValid - InternalNioInputBuffer.this.pos;
                    chunk.setBytes(InternalNioInputBuffer.this.buf, InternalNioInputBuffer.this.pos, length);
                    InternalNioInputBuffer.this.pos = InternalNioInputBuffer.this.lastValid;
                    return length;
                }
            }
            int length = InternalNioInputBuffer.this.lastValid - InternalNioInputBuffer.this.pos;
            chunk.setBytes(InternalNioInputBuffer.this.buf, InternalNioInputBuffer.this.pos, length);
            InternalNioInputBuffer.this.pos = InternalNioInputBuffer.this.lastValid;
            return length;
        }
    }
}

