/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.startup;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.channels.FileChannel;
import java.nio.channels.WritableByteChannel;
import java.nio.channels.spi.AbstractInterruptibleChannel;
import org.jboss.web.CatalinaLogger;

public class ExpandWar {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean copy(File src, File dest) {
        boolean result = true;
        String[] files = null;
        if (src.isDirectory()) {
            files = src.list();
            result = dest.mkdir();
        } else {
            files = new String[]{""};
        }
        if (files == null) {
            files = new String[]{};
        }
        for (int i = 0; i < files.length && result; ++i) {
            File fileSrc = new File(src, files[i]);
            File fileDest = new File(dest, files[i]);
            if (fileSrc.isDirectory()) {
                result = ExpandWar.copy(fileSrc, fileDest);
                continue;
            }
            FileChannel ic = null;
            AbstractInterruptibleChannel oc = null;
            try {
                ic = new FileInputStream(fileSrc).getChannel();
                oc = new FileOutputStream(fileDest).getChannel();
                ic.transferTo(0L, ic.size(), (WritableByteChannel)((Object)oc));
                continue;
            }
            catch (IOException e) {
                CatalinaLogger.STARTUP_LOGGER.fileCopyError(fileSrc, fileDest, e);
                result = false;
                continue;
            }
            finally {
                if (ic != null) {
                    try {
                        ic.close();
                    }
                    catch (IOException iOException) {}
                }
                if (oc != null) {
                    try {
                        oc.close();
                    }
                    catch (IOException iOException) {}
                }
            }
        }
        return result;
    }

    public static boolean delete(File dir) {
        return ExpandWar.delete(dir, true);
    }

    public static boolean delete(File dir, boolean logFailure) {
        boolean result = dir.isDirectory() ? ExpandWar.deleteDir(dir, logFailure) : (dir.exists() ? dir.delete() : true);
        if (logFailure && !result) {
            CatalinaLogger.STARTUP_LOGGER.fileDeleteError(dir.getAbsolutePath());
        }
        return result;
    }

    public static boolean deleteDir(File dir) {
        return ExpandWar.deleteDir(dir, true);
    }

    public static boolean deleteDir(File dir, boolean logFailure) {
        String[] files = dir.list();
        if (files == null) {
            files = new String[]{};
        }
        for (int i = 0; i < files.length; ++i) {
            File file = new File(dir, files[i]);
            if (file.isDirectory()) {
                ExpandWar.deleteDir(file, logFailure);
                continue;
            }
            file.delete();
        }
        boolean result = dir.exists() ? dir.delete() : true;
        if (logFailure && !result) {
            CatalinaLogger.STARTUP_LOGGER.fileDeleteError(dir.getAbsolutePath());
        }
        return result;
    }
}

